INV=false; RED=false; BNC=false
# GET OLD/NEW FROM ZIP NAME
case $(basename $ZIP) in
  *inv*|*Inv*|*INV*) INV=true;;
  *red*|*Red*|*RED*) RED=true;;
  *bnc*|*Bnc*|*BNC*) BNC=true;;
esac

# Keycheck binary by someone755 @Github, idea for code below by Zappo @xda-developers
chmod 755 $INSTALLER/common/keycheck

keytest() {
  ui_print "- Vol Key Test -"
  ui_print "   Press Vol Up:"
  (/system/bin/getevent -lc 1 2>&1 | /system/bin/grep VOLUME | /system/bin/grep " DOWN" > $INSTALLER/events) || return 1
  return 0
}   
                                                                            
chooseport() {
  #note from chainfire @xda-developers: getevent behaves weird when piped, and busybox grep likes that even less than toolbox/toybox grep
  while (true); do
    /system/bin/getevent -lc 1 2>&1 | /system/bin/grep VOLUME | /system/bin/grep " DOWN" > $INSTALLER/events
    if (`cat $INSTALLER/events 2>/dev/null | /system/bin/grep VOLUME >/dev/null`); then
      break
    fi
  done
  if (`cat $INSTALLER/events 2>/dev/null | /system/bin/grep VOLUMEUP >/dev/null`); then
    return 0
  else
    return 1
  fi
}

chooseportold() {
  # Calling it first time detects previous input. Calling it second time will do what we want
  $INSTALLER/common/keycheck
  $INSTALLER/common/keycheck
  SEL=$?
  if [ "$1" == "UP" ]; then
    UP=$SEL
  elif [ "$1" == "DOWN" ]; then
    DOWN=$SEL
  elif [ $SEL -eq $UP ]; then
    return 0
  elif [ $SEL -eq $DOWN ]; then
    return 1
  else
    ui_print "   Vol key not detected!"
    abort "   Use name change method in TWRP"
  fi
}

ui_print " "
if ! $INV && ! $RED && ! $BNC; then
  if keytest; then
    FUNCTION=chooseport
  else
    FUNCTION=chooseportold
    ui_print "   ! Legacy device detected! Using old keycheck method"
    ui_print " "
    ui_print "- Vol Key Programming -"
    ui_print "   Press Vol Up Again:"
    $FUNCTION "UP"
    ui_print "   Press Vol Down"
    $FUNCTION "DOWN"
  fi
  ui_print " "
  ui_print "- Select Version -"
  ui_print "   Choose which Dolby Atmos you want installed:"
  ui_print "   Default is Black 'n Cheese Edition"
  ui_print "   Inspired by Swift Black/Violet"
  ui_print " "
  ui_print "   Vol Up = Black 'n Cheese"
  ui_print "   Vol Down = continue to next menu"
  if $FUNCTION; then
    BNC=true
  else
    ui_print "   Choose which Dolby Atmos you want installed:"
    ui_print "   Vol Up = BlackRed"
    ui_print "   Vol Down = Inverted"
    if $FUNCTION; then
      RED=true
    else
      INV=true
    fi
  fi
else
  ui_print "   Dolby Atmos version specified in zipname!"
fi

if $RED; then
  ui_print "   BlackRed Dolby Atmos will be installed"
  cp -f $INSTALLER/custom/DolbyAtmos_BlackRed.apk $INSTALLER/system/app/DolbyAtmos/DolbyAtmos.apk
elif $INV; then
  ui_print "   Inverted Dolby Atmos will be installed"
  cp -f $INSTALLER/custom/DolbyAtmos_Inverted.apk $INSTALLER/system/app/DolbyAtmos/DolbyAtmos.apk
else
  ui_print "   Black 'n Cheese Dolby Atmos will be installed"
fi

if $libsinstall || [ "$htc" ] || [ "$axon" ]; then
  mkdir -p $INSTALLER/system/lib $INSTALLER/system/lib64
  cp -f $INSTALLER/custom/lib/* $INSTALLER/system/lib
  cp -f $INSTALLER/custom/lib64/* $INSTALLER/system/lib64
else
  for FILE in "libradio.so" "libradioservice.so"; do
    if [ ! -f "/system/lib/$FILE" ]; then
      mkdir -p $INSTALLER/system/lib $INSTALLER/system/lib64
      cp -f $INSTALLER/custom/lib/$FILE $INSTALLER/system/lib/$FILE
      $IS64BIT && cp -f $INSTALLER/custom/lib64/$FILE $INSTALLER/system/lib64/$FILE
    fi
  done
fi
for FILE in ${CFGS}; do
  cp_ch $ORIGDIR$FILE $UNITY$FILE
  case $FILE in
    *.conf) sed -i "/effects {/,/^}/ {/^ *music_helper {/,/}/ s/^/#/g}" $UNITY$FILE
            sed -i "/effects {/,/^}/ {/^ *sa3d {/,/^  }/ s/^/#/g}" $UNITY$FILE
            sed -i "/effects {/,/^}/ {/^ *soundalive {/,/^  }/ s/^/#/g}" $UNITY$FILE
            sed -i "/effects {/,/^}/ {/^ *dha {/,/^  }/ s/^/#/g}" $UNITY$FILE
            if [ ! "$(grep "vlldp" $UNITY$FILE)" ]; then
              sed -i "s/^libraries {/libraries {\n  vlldp { #$MODID\n    path \/vendor\/lib\/soundfx\/libswvlldp.so\n  } #$MODID/g" $UNITY$FILE
              sed -i "s/^libraries {/libraries {\n  atmos { #$MODID\n    path \/vendor\/lib\/soundfx\/libatmos.so\n  } #$MODID/g" $UNITY$FILE
              sed -i "s/^effects {/effects {\n  vlldp { #$MODID\n    library vlldp\n    uuid 3783c334-d3a0-4d13-874f-0032e5fb80e2\n  } #$MODID/g" $UNITY$FILE
              sed -i "s/^effects {/effects {\n  atmos { #$MODID\n    library atmos\n    uuid 9d4921da-8225-4f29-aefa-aacb40a73593\n  } #$MODID/g" $UNITY$FILE
            fi
            if [ ! "$(sed -n "/^output_session_processing {/,/^}/p" $UNITY$FILE)" ]; then
              echo -e "output_session_processing {\n    music {\n        atmos {\n        }\n    }\n}" >> $UNITY$FILE
            elif [ ! "$(sed -n "/^output_session_processing {/,/^}/ {/music {/,/^    }/p}" $UNITY$FILE)" ]; then
              sed -i "/output_session_processing {/,/^}/ s/output_session_processing {/output_session_processing {\n    music {\n        atmos {\n        }\n    }/" $UNITY$FILE
            elif [ ! "$(sed -n "/^output_session_processing {/,/^}/ {/music {/,/^    }/ {/atmos {/,/}/p}}" $UNITY$FILE)" ]; then
              sed -i "/output_session_processing {/,/^}/ {/music {/,/^    }/ s/music {/music {\n        atmos {\n        }/}" $UNITY$FILE
            fi;;
   *.xml) sed -ri "/^ *<postprocess>$/,/<\/postprocess>/ {/<stream type=\"music\">/,/<\/stream>/ s/^( *)<apply effect=\"music_helper\"\/>/\1<\!--<apply effect=\"music_helper\"\/>-->/}" $UNITY$FILE
          sed -ri "/^ *<postprocess>$/,/<\/postprocess>/ {/<stream type=\"music\">/,/<\/stream>/ s/^( *)<apply effect=\"sa3d\"\/>/\1<\!--<apply effect=\"sa3d\"\/>-->/}" $UNITY$FILE
          sed -ri "/^ *<postprocess>$/,/<\/postprocess>/ {/<stream type=\"music\">/,/<\/stream>/ s/^( *)<apply effect=\"soundalive\"\/>/\1<\!--<apply effect=\"soundalive\"\/>-->/}" $UNITY$FILE
          sed -ri "/^ *<postprocess>$/,/<\/postprocess>/ {/<stream type=\"music\">/,/<\/stream>/ s/^( *)<apply effect=\"dha\"\/>/\1<\!--<apply effect=\"dha\"\/>-->/}" $UNITY$FILE
          if [ ! "$(grep "vlldp" $UNITY$FILE)" ]; then
            sed -i "/<libraries>/ a\        <library name=\"atmos\" path=\"libatmos.so\"\/><!--$MODID-->" $UNITY$FILE
            sed -i "/<libraries>/ a\        <library name=\"vlldp\" path=\"libswvlldp.so\"\/><!--$MODID-->" $UNITY$FILE
            sed -i "/<effects>/ a\        <effect name=\"vlldp\" library=\"vlldp\" uuid=\"3783c334-d3a0-4d13-874f-0032e5fb80e2\"\/><!--$MODID-->" $UNITY$FILE
            sed -i "/<effects>/ a\        <effect name=\"atmos\" library=\"atmos\" uuid=\"9d4921da-8225-4f29-aefa-aacb40a73593\"\/><!--$MODID-->" $UNITY$FILE
          fi
          if [ ! "$(sed -n "/<postprocess>/,/<\/postprocess>/p" $UNITY$FILE)" ]; then     
            sed -i "/<\/audio_effects_conf>/i\    <postprocess>\n       <stream type=\"music\">\n            <apply effect=\"atmos\"\/>\n        <\/stream>\n    <\/postprocess>" $UNITY$FILE
          elif [ ! "$(sed -n "/<postprocess>/,/<\/postprocess>/ {/<stream type=\"music\">/,/<\/stream>/p}" $UNITY$FILE)" ]; then     
            sed -i "/<postprocess>/,/<\/postprocess>/ s/    <postprocess>/    <postprocess>\n        <stream type=\"music\">\n            <apply effect=\"atmos\"\/>\n        <\/stream>/" $UNITY$FILE
          elif [ ! "$(sed -n "/<postprocess>/,/<\/postprocess>/ {/<stream type=\"music\">/,/<\/stream>/ {/^ *<apply effect=\"atmos\"\/>/p}}" $UNITY$FILE )" ]; then
            sed -i "/<postprocess>/,/<\/postprocess>/ {/<stream type=\"music\">/,/<\/stream>/ s/<stream type=\"music\">/<stream type=\"music\">\n            <apply effect=\"atmos\"\/>/}" $UNITY$FILE
          fi;;
  esac  
done
