if [ "$ROOT" ]; then mount -o rw,remount $ROOT; else mount -o rw,remount /; fi

dts=/data/misc/dts
if [ ! -d "$dts" ]; then

  mkdir -p $dts
  chmod 0775 $dts
  chown 1013.1005 $dts
  chcon -R u:object_r:dts_data_file:s0 $dts

elif [ -e "$dts/dax_sqlite3.db" ]; then

  chmod 0644 $dts/dax_sqlite3.db
  chown 1041.1005 $dts/dax_sqlite3.db
  chcon -R u:object_r:dts_data_file:s0 $dts
  
fi

if [ ! -d "$ROOT/odm" ]; then

  mkdir -p $ROOT/odm/etc
  chmod 0755 $ROOT/odm $ROOT/odm/etc
  chown 1000.1000 $ROOT/odm $ROOT/odm/etc
  chcon -R u:object_r:system_file:s0 $ROOT/odm

  if [ -d "$VEN/etc/audio" ]; then
    AP="$(find -L $VEN/etc/audio -type f -name "audio_policy_configuration*.xml" | head -n 1)"
    APDIR=$VEN/etc
  else
    AP="$(find -L $SYS/etc -type f -name "audio_policy_configuration*.xml" | head -n 1)"
    APDIR=$SYS/etc
  fi
  
  POLS="$(find -L $APDIR -type f -name "audio_policy_configuration*.xml") $(grep "include href=" $AP | sed -r "s|.*=\"(.*)\".*|$APDIR/\1|g")"
  for POL in ${POLS}; do
    [ -f "$POL" ] && ln -sf $POL $ROOT/odm/etc/
  done
  
fi

if [ "$ROOT" ]; then mount -o ro,remount $ROOT; else mount -o ro,remount /; fi

exit 0
