osp_detect() {
  case $1 in
    *.conf) SPACES=$(sed -n "/^output_session_processing {/,/^}/ {/^ *music {/p}" $1 | sed -r "s/( *).*/\1/")
            EFFECTS=$(sed -n "/^output_session_processing {/,/^}/ {/^$SPACES\music {/,/^$SPACES}/p}" $1 | grep -E "^$SPACES +[A-Za-z]+" | sed -r "s/( *.*) .*/\1/g")
            for EFFECT in ${EFFECTS}; do
              SPACES=$(sed -n "/^effects {/,/^}/ {/^ *$EFFECT {/p}" $1 | sed -r "s/( *).*/\1/")
              [ "$EFFECT" != "atmos" ] && sed -i "/^effects {/,/^}/ {/^$SPACES$EFFECT {/,/^$SPACES}/ s/^/#/g}" $1
            done;;
     *.xml) EFFECTS=$(sed -n "/^ *<postprocess>$/,/^ *<\/postprocess>$/ {/^ *<stream type=\"music\">$/,/^ *<\/stream>$/ {/<stream type=\"music\">/d; /<\/stream>/d; s/<apply effect=\"//g; s/\"\/>//g; p}}" $1)
            for EFFECT in ${EFFECTS}; do
              [ "$EFFECT" != "atmos" ] && sed -ri "s/^( *)<apply effect=\"$EFFECT\"\/>/\1<\!--<apply effect=\"$EFFECT\"\/>-->/" $1
            done;;
  esac
}

# Tell user aml is needed if applicable
if $MAGISK && ! $SYSOVER; then
  if $BOOTMODE; then LOC="$MOUNTEDROOT/*/system $MODULEROOT/*/system"; else LOC="$MODULEROOT/*/system"; fi
  FILES=$(find $LOC -type f -name "*audio_effects*.conf" -o -name "*audio_effects*.xml" 2>/dev/null)
  if [ ! -z "$FILES" ] && [ ! "$(echo $FILES | grep '/aml/')" ]; then
    ui_print " "
    ui_print "   ! Conflicting audio mod found!"
    ui_print "   ! You will need to install !"
    ui_print "   ! Audio Modification Library !"
    sleep 3
  fi
fi

ui_print " "
ui_print "   Removing remnants from past Dolby installs..."
DAPPS=$(find /data/app -type d -name "*com.Dolby*")
if [ "$DAPPS" ]; then
  if $BOOTMODE; then
    for APP in ${DAPPS}; do
      case $DAPP in
        *com.dolby*) pm uninstall com.dolby >/dev/null 2>&1;;
      esac
    done
  else
    for APP in ${DAPPS}; do
      rm -rf $APP
    done
  fi
fi
# Remove remnants of any old Dolby installs
for REMNANT in $(find /data -name "*Dolby*" -o -name "*com.dolby*"); do
  [ "$(echo $REMNANT | cut -d '/' -f-4)" == "/data/media/0" ] && continue
  if [ -d "$REMNANT" ]; then
    rm -rf $REMNANT
  else
    rm -f $REMNANT
  fi
done

# Add aml script if applicable
#$MAGISK && ! $SYSOVERRIDE && cp -f $INSTALLER/common/.aml.sh $UNITY/.aml.sh

# Lib fix for pixel 2's, 3's, and essential phone
if device_check "walleye" || device_check "taimen" || device_check "crosshatch" || device_check "blueline" || device_check "mata" || device_check "jasmine"; then
  if [ -f $ORIGDIR/system/lib/libstdc++.so ] && [ ! -f $ORIGVEN/lib/libstdc++.so ]; then
    cp_ch $ORIGDIR/system/lib/libstdc++.so $UNITY$VEN/lib/libstdc++.so
  elif [ -f $ORIGVEN/lib/libstdc++.so ] && [ ! -f $ORIGDIR/system/lib/libstdc++.so ]; then
    cp_ch $ORIGVEN/lib/libstdc++.so $UNITY/system/lib/libstdc++.so
  fi
fi

# Extract Module
tar -xf $TMPDIR/system.tar.xz -C $TMPDIR 2>/dev/null
[ ! -f $TMPDIR/system/etc/ds1-default.xml ] && { ui_print "! Unable to extract mod file !"; exit 1; }

ui_print " "
ui_print "   Patching existing audio_effects files..."
for OFILE in ${CFGS}; do
  FILE="$UNITY$(echo $OFILE | sed "s|^/vendor|/system/vendor|g")"
  cp_ch -i $ORIGDIR$OFILE $FILE
  osp_detect $FILE
  case $FILE in
    *.conf) sed -i "/dsplus {/,/}/d" $FILE
            sed -i "s/^effects {/effects {\n  dsplus { #$MODID\n    library dsplus\n    uuid 9d4921da-8225-4f29-aefa-39537a04bcaa\n  } #$MODID/g" $FILE
            sed -i "s/^libraries {/libraries {\n  dsplus { #$MODID\n    path $LIBPATCH\/lib\/soundfx\/libdseffect.so\n  } #$MODID/g" $FILE;;
    *.xml) sed -i "/dsplus/d" $FILE
           sed -i "/<libraries>/ a\        <library name=\"dsplus\" path=\"libdseffect.so\"\/><!--$MODID-->" $FILE
           sed -i "/<effects>/ a\        <effect name=\"dsplus\" library=\"dsplus\" uuid=\"9d4921da-8225-4f29-aefa-39537a04bcaa\"\/><!--$MODID-->" $FILE;;
  esac
done
