cd `dirname $0`

printf "\nThis is a recovery rom installation script for Redmi Note 10 (Linux)\n"
printf "Make sure you installed python & pip specific to your linux...\n"

if [ ! -f "extracted" ]; then
    printf "\nExtracting files from ROM...\n"
    unzip *.zip
	if [ -f "payload.bin" ]; then
        printf "\nInstalling payload dependencies...\n"
        python -m pip install protobuf
        printf "\nExtracting images from the payload...\n"
        python tools/payload_dumper.py payload.bin
        touch .extracted
	elif [ -f "dynamic_partitions_op_list" ]; then
		printf "\nInstalling payload dependencies...\n"
		python -m pip install Brotli
		printf "\nUncompressing the data...\n"
		brotli -d system.new.dat.br system_ext.new.dat.br product.new.dat.br vendor.new.dat.br
		printf "\nExtracting all the images...\n"
		python tools/sdat2img.py system.transfer.list system.new.dat system.img
		printf "\nDone extracting system...\n"
		python tools/sdat2img.py system_ext.transfer.list system_ext.new.dat system_ext.img
		printf "\nDone extracting system_ext...\n"
		python tools/sdat2img.py product.transfer.list product.new.dat product.img
		printf "\nDone extracting product...\n"
		python tools/sdat2img.py vendor.transfer.list vendor.new.dat vendor.img
		printf "\nDone extracting vendor...\n"
		rm system.new.dat system_ext.new.dat product.new.dat vendor.new.dat
		touch extracted
    fi
fi

if [ ! -f "sparsed" ]; then
    printf "Converting RAW images into sparse...\n"
    printf "sparsing system...\n"
    tools/simg_tools/img2simg system.img temp.img
    rm system.img
    mv temp.img system.img
    printf "sparsing system_ext...\n"
    tools/simg_tools/img2simg system_ext.img temp.img
    rm system_ext.img
    mv temp.img system_ext.img
    printf "sparsing product...\n"
    tools/simg_tools/img2simg product.img temp.img
    rm product.img
    mv temp.img product.img
    printf "sparsing vendor...\n"
    tools/simg_tools/img2simg vendor.img temp.img
    rm vendor.img
    mv temp.img vendor.img
    touch sparsed
fi

if [ -f "extracted" ]; then
    printf "\nChecking fastboot version...\n"
    tools/fastboot_linux $* --version
    printf "\nNow you can boot the device in fastboot mode & connect to PC\n"
    tools/fastboot_linux $* flash boot tools/fastbootd_mojito.img
    printf "\nBooting to fastbootD\n"
    tools/fastboot_linux $* reboot fastboot
    printf "\nRecreating logical partitions...\n"
    tools/fastboot_linux $* delete-logical-partition system_a
    tools/fastboot_linux $* delete-logical-partition system_ext_a
    tools/fastboot_linux $* delete-logical-partition product_a
    tools/fastboot_linux $* delete-logical-partition vendor_a
    tools/fastboot_linux $* delete-logical-partition system_b
    tools/fastboot_linux $* delete-logical-partition system_ext_b
    tools/fastboot_linux $* delete-logical-partition product_b
    tools/fastboot_linux $* delete-logical-partition vendor_b
    tools/fastboot_linux $* create-logical-partition system_a 4096
    tools/fastboot_linux $* create-logical-partition system_ext_a 4096
    tools/fastboot_linux $* create-logical-partition product_a 4096
    tools/fastboot_linux $* create-logical-partition vendor_a 4096
    tools/fastboot_linux $* create-logical-partition system_b 4096
    tools/fastboot_linux $* create-logical-partition system_ext_b 4096
    tools/fastboot_linux $* create-logical-partition product_b 4096
    tools/fastboot_linux $* create-logical-partition vendor_b 4096
    printf "\nFlashing the ROM into the active slot...\n"
    tools/fastboot_linux $* flash system system.img
    tools/fastboot_linux $* flash system_ext system_ext.img
    tools/fastboot_linux $* flash product product.img
    tools/fastboot_linux $* flash vendor vendor.img
    printf "\nFlashing boot partitions...\n"
    tools/fastboot_linux $* reboot bootloader
    tools/fastboot_linux $* flash boot_a boot.img
    tools/fastboot_linux $* flash boot_b boot.img
    tools/fastboot_linux $* flash vendor_boot_a vendor_boot.img
    tools/fastboot_linux $* flash vendor_boot_b vendor_boot.img
    tools/fastboot_linux $* reboot recovery
    printf "\nRebooting to recovery in...\n"
    sleep 1
    printf "......6......\n"
    sleep 1
    printf " .....5.....\n"
    sleep 1
    printf "  ....4....\n"
    sleep 1
    printf "   ...3...\n"
    sleep 1
    printf "    ..2..\n"
    sleep 1
    printf "     .1.\n"
    sleep 1
fi

read -p "Done. Now you can format from recovery to clean start, or just simply reboot to retain your previous configuration..."
