#!/sbin/sh
# 
# /system/addon.d/70-gapps_xposed.sh
# During a CM14.1 upgrade, this script backs up /system/*,
# /system is formatted and reinstalled, then the file is restored.
#

. /tmp/backuptool.functions

list_files() {
cat <<EOF
etc/hosts
etc/permissions/com.google.android.maps.xml
framework/com.google.android.maps.jar
priv-app/GmsCore/GmsCore.apk
priv-app/GmsCore/lib/arm/libAppDataSearch.so
priv-app/GmsCore/lib/arm/libconscrypt_gmscore_jni.so
priv-app/GmsCore/lib/arm/libgmscore.so
priv-app/GmsCore/lib/arm/libleveldbjni.so
priv-app/GmsCore/lib/arm/libNearbyApp.so
priv-app/GmsCore/lib/arm/libtango_utility_lib.so
priv-app/GmsCore/lib/arm/libwearable-selector.so
priv-app/GmsCore/lib/arm/libWhisper.so
priv-app/GmsCore/lib/arm64/libAppDataSearch.so
priv-app/GmsCore/lib/arm64/libconscrypt_gmscore_jni.so
priv-app/GmsCore/lib/arm64/libgcastv2_base.so
priv-app/GmsCore/lib/arm64/libgcastv2_support.so
priv-app/GmsCore/lib/arm64/libgmscore.so
priv-app/GmsCore/lib/arm64/libgoogle-ocrclient-v3.so
priv-app/GmsCore/lib/arm64/libjgcastservice.so
priv-app/GmsCore/lib/arm64/libleveldbjni.so
priv-app/GmsCore/lib/arm64/libNearbyApp.so
priv-app/GmsCore/lib/arm64/libsslwrapper_jni.so
priv-app/GmsCore/lib/arm64/libtango_utility_lib.so
priv-app/GmsCore/lib/arm64/libwearable-selector.so
priv-app/GmsCore/lib/arm64/libWhisper.so
priv-app/GoogleCalendarSyncAdapter/GoogleCalendarSyncAdapter.apk
priv-app/GoogleContactsSyncAdapter/GoogleContactsSyncAdapter.apk
priv-app/GoogleBackupTransport/GoogleBackupTransport.apk
priv-app/GoogleLoginService/GoogleLoginService.apk
priv-app/GoogleServicesFramework/GoogleServicesFramework.apk
priv-app/Phonesky/Phonesky.apk
EOF
}

case "$1" in
  backup)
    list_files | while read FILE DUMMY; do
      backup_file $S/"$FILE"
    done
  ;;
  restore)
    list_files | while read FILE REPLACEMENT; do
      R=""
      [ -n "$REPLACEMENT" ] && R="$S/$REPLACEMENT"
      [ -f "$C/$S/$FILE" ] && restore_file $S/"$FILE" "$R"
    done
  ;;
  pre-backup)
    # Stub
  ;;
  post-backup)
    # Stub
  ;;
  pre-restore)
    # Stub
  ;;
  post-restore)
	# App Permissions
	  chmod 755 /system/priv-app/*
	  chmod 755 /system/priv-app/GmsCore/lib
	  chmod 755 /system/priv-app/GmsCore/lib/arm
	  chmod 755 /system/priv-app/GmsCore/lib/arm64
	  chmod 755 /system/priv-app/PlayGames/lib
	  chmod 755 /system/priv-app/PlayGames/lib/arm64
  ;;
esac
