/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.apk;

import com.miui.theme.tool.util.ThemeHelper;
import java.io.File;

public class Activity {
    private String icon;
    private boolean mIsDefault;
    private boolean mSameWithPackageIcon;
    private boolean mIsCache;
    private static String fakedIconDir = String.valueOf(System.getProperty("user.dir")) + File.separator + "tmp" + File.separator + "icons";
    private String className;
    private String pkgName;
    private static String SEPARATOR = "__";

    public boolean isCache() {
        return this.mIsCache;
    }

    public void setFacked(boolean facked) {
        this.mIsCache = facked;
    }

    public static String getFakedIconDir() {
        return fakedIconDir;
    }

    public boolean isSameWithPackageIcon() {
        return this.mSameWithPackageIcon;
    }

    public void setSameWithPackageIcon(boolean sameWithPackageIcon) {
        this.mSameWithPackageIcon = sameWithPackageIcon;
    }

    public String getPkgName() {
        return this.pkgName;
    }

    public String getClassName() {
        return this.className;
    }

    public Activity(String pkgName, String className) {
        this.pkgName = pkgName;
        this.className = className;
    }

    public Activity(String pkgName, String className, boolean isDefault) {
        this.pkgName = pkgName;
        this.className = className;
        this.mIsDefault = isDefault;
    }

    public boolean isDefault() {
        return this.mIsDefault;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getThemeIcon() {
        String iconDesName = this.isSameWithPackageIcon() ? this.getPkgName() : this.getName();
        return String.valueOf(iconDesName) + ".png";
    }

    public void setDefault() {
        this.mIsDefault = true;
    }

    public String getName() {
        if (this.className.startsWith(this.pkgName)) {
            return this.className;
        }
        if (ThemeHelper.startWidthNetName(this.className)) {
            return this.className;
        }
        return String.valueOf(this.pkgName) + this.className;
    }

    public String getComponentName() {
        return String.valueOf(this.pkgName) + "/" + this.className;
    }

    public String toString() {
        return this.getComponentName();
    }

    public static Activity getCachedActivityFromIcon(String iconName) {
        if (iconName == null) {
            return null;
        }
        String[] res = (iconName = iconName.split(".png")[0]).split(SEPARATOR);
        if (res.length < 2) {
            return null;
        }
        Activity ac = new Activity(res[0], res[1]);
        ac.setFacked(true);
        if (res.length == 2) {
            return ac;
        }
        if (res.length == 3 && res[2].equals("S")) {
            ac.setSameWithPackageIcon(true);
            return ac;
        }
        return null;
    }

    public String getFackedIconName() {
        if (this.isSameWithPackageIcon()) {
            return String.valueOf(this.pkgName) + SEPARATOR + this.className + SEPARATOR + "S";
        }
        return String.valueOf(this.pkgName) + SEPARATOR + this.className;
    }

    public String getCacheIconPath() {
        return String.valueOf(Activity.getFakedIconDir()) + File.separator + this.getFackedIconName() + ".png";
    }
}

