/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui;

import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Observable;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;

public class ImageLabel
extends Observable
implements ActionListener {
    private JMenuItem delItem;
    private JPopupMenu popMenu;
    private CoverLabel label = new CoverLabel();

    public ImageLabel() {
        this.label.addMouseListener(new ImageLabelMouseListener());
        this.label.setToolTipText(ResourceFactory.getString("image_label_tool_tip"));
        this.popMenu = new JPopupMenu();
        this.delItem = new JMenuItem(ResourceFactory.getString("global_delete"));
        this.popMenu.add(this.delItem);
        this.delItem.addActionListener(this);
        this.label.setHorizontalAlignment(0);
        this.label.setVerticalAlignment(0);
        if (this.label.getWidth() < 100) {
            this.label.setSize(100, this.label.getHeight());
        }
    }

    public JLabel showLabel() {
        return this.label;
    }

    public void setImgPath(String imgPath) {
        this.label.imgPath = imgPath;
        this.label.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.delItem) {
            new File(this.label.imgPath).delete();
            this.label.repaint();
        }
    }

    class CoverLabel
    extends JLabel {
        public String imgPath;

        CoverLabel() {
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.black);
            try {
                if (this.imgPath == null || "".equals(this.imgPath) || !new File(this.imgPath).exists()) {
                    super.paint(g);
                    return;
                }
                FileInputStream fis = new FileInputStream(this.imgPath);
                BufferedImage img = ImageIO.read(fis);
                fis.close();
                double rate1 = (double)img.getWidth(null) / ((double)this.getWidth() - 20.0) + 0.1;
                double rate2 = (double)img.getHeight(null) / ((double)this.getHeight() - 20.0) + 0.1;
                double rate = rate1 > rate2 ? rate1 : rate2;
                int new_w = (int)((double)img.getWidth(null) / rate);
                int new_h = (int)((double)img.getHeight(null) / rate);
                g.drawImage(img, (this.getWidth() - new_w) / 2, (this.getHeight() - new_h) / 2, new_w, new_h, null);
                super.paint(g);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class ImageLabelMouseListener
    implements MouseListener {
        ImageLabelMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ImageLabel.this.label.setCursor(new Cursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                JFileChooser jfc = new JFileChooser();
                jfc.setBounds(20, 20, 300, 300);
                jfc.setVisible(true);
                jfc.setDialogTitle(ResourceFactory.getString("image_label_choose_img_title"));
                jfc.setFileSelectionMode(0);
                jfc.addChoosableFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() || file.isFile() && (file.getName().toLowerCase().endsWith(".jpg") || file.getName().toLowerCase().endsWith(".png"));
                    }

                    @Override
                    public String getDescription() {
                        return "image";
                    }
                });
                int state = jfc.showOpenDialog(null);
                if (state == 0) {
                    File f = jfc.getSelectedFile();
                    File target = new File(((ImageLabel)ImageLabel.this).label.imgPath);
                    if (!target.getParentFile().exists()) {
                        target.getParentFile().mkdirs();
                    }
                    try {
                        ThemeHelper.copyFile(f, target);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    ImageLabel.this.label.repaint();
                    if (f.getParent() != null) {
                        ThemeHelper.sLastClosedInfo.put("iconPath", f.getParent());
                    }
                }
            } else if (e.getButton() == 3) {
                ImageLabel.this.popMenu.setLocation(e.getX(), e.getY());
                ImageLabel.this.popMenu.show(ImageLabel.this.label, e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

