/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.resourceeditor;

import com.miui.theme.tool.gui.MainFrame;
import com.miui.theme.tool.gui.SetVectorableJList;
import com.miui.theme.tool.resourceeditor.ScreenshotXml;
import com.miui.theme.tool.util.GridBagHelper;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ScreenshotList
extends SetVectorableJList
implements MouseListener {
    public int resizeFlag = 15;

    @Override
    public void updateUI() {
        this.init();
        super.updateUI();
    }

    public ScreenshotList(Vector<ScreenshotXml> screenshotXmls) {
        this.setVector(screenshotXmls);
        this.setSelectionMode(0);
        this.addMouseListener(this);
    }

    public void init() {
        this.setCellRenderer(new CellRenderer());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            ScreenshotXml sx = (ScreenshotXml)this.getSelectedValue();
            ThemeHelper.openInExplorer(sx.mFile);
        }
    }

    class CellRenderer
    implements ListCellRenderer {
        int lastSelectedIndex = -1;
        Vector<RendererPanel> rp = new Vector();

        CellRenderer() {
        }

        private void init() {
            int i = 0;
            while (i < ScreenshotList.this.getModel().getSize()) {
                this.rp.add(i, new RendererPanel((ScreenshotXml)ScreenshotList.this.getModel().getElementAt(i)));
                ++i;
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (this.rp.size() <= index || this.rp.get(index) == null) {
                this.init();
            }
            if (ScreenshotList.this.getSelectedIndex() != -1 && this.rp.size() > ScreenshotList.this.getSelectedIndex()) {
                this.rp.get(ScreenshotList.this.getSelectedIndex()).setBackground(Color.GRAY);
                if (this.lastSelectedIndex != -1 && this.rp.size() > this.lastSelectedIndex && this.lastSelectedIndex != ScreenshotList.this.getSelectedIndex()) {
                    this.rp.get(this.lastSelectedIndex).setBackground(MainFrame.getInstance().getBackground());
                }
            }
            this.lastSelectedIndex = ScreenshotList.this.getSelectedIndex();
            return this.rp.get(index);
        }
    }

    class RendererPanel
    extends JPanel {
        ScreenshotXml mScreenshotXml;
        private JLabel mDesc;
        private BufferedImage mImage;
        private JPanel mTopPanel;
        private int x;
        private int y;
        private int scaledW;
        private int scaledH;

        private RendererPanel(ScreenshotXml sx) {
            this.mScreenshotXml = sx;
            this.initPanel();
        }

        private void initPanel() {
            this.mTopPanel = new JPanel();
            this.mTopPanel.setOpaque(false);
            try {
                FileInputStream fis = new FileInputStream(this.mScreenshotXml.mFile);
                this.mImage = ImageIO.read(fis);
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.mDesc = new JLabel(String.valueOf(this.mScreenshotXml.mDescription) + "(" + this.mScreenshotXml.mVersion + ")");
            this.setLayout(new GridBagLayout());
            GridBagHelper.addComponent(this, this.mTopPanel, 0, 0, 1, 1, 0, 0, 0.0, 1.0, 3, 10);
            GridBagHelper.addComponent(this, this.mDesc, 0, 1, 1, 1, 0, 0, 1.0, 0.0, 3, 15);
            this.adjustIcon(200);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            Rectangle clip = g2d.getClipBounds();
            int width = (int)clip.getWidth();
            this.adjustIcon(width);
            g.drawImage(this.mImage, this.x, this.y, this.scaledW, this.scaledH, null);
        }

        private void adjustIcon(int width) {
            double scale = 0.9;
            int w = this.mImage.getWidth();
            int h = this.mImage.getHeight();
            int imgHeight = (int)(1.0 * (double)h / (double)w * (double)width);
            int imgWidth = width;
            int gap = 2;
            if (ScreenshotList.this.resizeFlag > 0) {
                ScreenshotList.this.setFixedCellHeight(this.mDesc.getHeight() + gap + imgHeight);
                --ScreenshotList.this.resizeFlag;
            }
            this.scaledW = (int)((double)imgWidth * scale);
            this.scaledH = (int)((double)imgHeight * scale);
            this.x = (imgWidth - this.scaledW) / 2;
            this.y = (imgHeight - this.scaledH) / 2;
        }

        public void updateTitle() {
            this.mDesc.setText(this.mScreenshotXml.mDescription);
        }
    }
}

