/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;

public class ImageHelper {
    public static final String path = System.getProperty("user.dir");

    public static BufferedImage thumb(BufferedImage source, int width, int height, boolean b) {
        int type = source.getType();
        BufferedImage target = null;
        double sx = (double)width / (double)source.getWidth();
        double sy = (double)height / (double)source.getHeight();
        if (b) {
            if (sx > sy) {
                sx = sy;
                width = (int)(sx * (double)source.getWidth());
            } else {
                sy = sx;
                height = (int)(sy * (double)source.getHeight());
            }
        }
        if (type == 0) {
            ColorModel cm = source.getColorModel();
            WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
            boolean alphaPremultiplied = cm.isAlphaPremultiplied();
            target = new BufferedImage(cm, raster, alphaPremultiplied, null);
        } else {
            target = new BufferedImage(width, height, type);
        }
        Graphics2D g = target.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.drawRenderedImage(source, AffineTransform.getScaleInstance(sx, sy));
        g.dispose();
        return target;
    }

    public static int rgbToGray(int pixels) {
        int _red = pixels >> 16 & 0xFF;
        int _green = pixels >> 8 & 0xFF;
        int _blue = pixels & 0xFF;
        return (int)(0.3 * (double)_red + 0.59 * (double)_green + 0.11 * (double)_blue);
    }

    public static int average(int[] pixels) {
        float m = 0.0f;
        int i = 0;
        while (i < pixels.length) {
            m += (float)pixels[i];
            ++i;
        }
        return (int)(m /= (float)pixels.length);
    }
}

