/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;

public class JPEGOutputUtil {
    private JPEGOutputUtil() {
    }

    public static boolean writeJPEGImageStream(OutputStream os, RenderedImage image) {
        try {
            JPEGOutputUtil.compressJpegStream(os, image, 1.0f);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void compressJpegFile(File outFile, RenderedImage image, float compressionQuality) throws IOException {
        FileOutputStream outStream = new FileOutputStream(outFile);
        JPEGOutputUtil.compressJpegStream(outStream, image, compressionQuality);
        ((OutputStream)outStream).close();
    }

    public static void compressJpegStream(OutputStream outStream, RenderedImage image, float compressionQuality) throws IOException {
        ImageWriter writer = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
        if (iter.hasNext()) {
            writer = iter.next();
        }
        JPEGImageWriteParam iwparam = new JPEGImageWriteParam(Locale.getDefault()){

            @Override
            public void setCompressionQuality(float quality) {
                if (quality < 0.0f || quality > 1.0f) {
                    throw new IllegalArgumentException("Quality out-of-bounds!");
                }
                this.compressionQuality = quality;
            }
        };
        iwparam.setCompressionMode(2);
        iwparam.setCompressionQuality(compressionQuality);
        ImageOutputStream ios = ImageIO.createImageOutputStream(outStream);
        writer.setOutput(ios);
        writer.write(null, new IIOImage(image, null, null), iwparam);
        ios.flush();
        writer.dispose();
        ios.close();
    }
}

