/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import com.miui.theme.tool.apk.Activity;
import com.miui.theme.tool.apk.ApkInfo;
import com.miui.theme.tool.apk.ApkUtils;
import com.miui.theme.tool.apk.CacheActivityManager;
import com.miui.theme.tool.apk.Member;
import com.miui.theme.tool.gui.ApkSelectDialog;
import com.miui.theme.tool.gui.MainFrame;
import com.miui.theme.tool.gui.StateBar;
import com.miui.theme.tool.gui.ThemeEditPanel;
import com.miui.theme.tool.os.CmdUtils;
import com.miui.theme.tool.os.OS;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.upsidescene.ShortcutSelectDialog;
import com.miui.theme.tool.xml.AndroidManifestParser;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Logger;

public class SelectComponentNameHelper
implements Observer {
    static Logger logger = Logger.getLogger(ThemeEditPanel.class.getName());
    public String mCurrentValue;
    private HashMap<String, Member> hashMapApp;
    private String mSelectedItem;
    private String userDir = System.getProperty("user.dir");

    public void show() {
        ApkSelectDialog dialog = new ApkSelectDialog(MainFrame.getInstance(), true);
        dialog.addObserver(this);
        dialog.openDialog();
        this.doImport();
    }

    @Override
    public void update(Observable observable, Object obj) {
        if (observable instanceof ApkSelectDialog && obj instanceof HashMap) {
            this.hashMapApp = (HashMap)obj;
        }
        if (observable instanceof ApkSelectDialog && obj instanceof String) {
            this.mSelectedItem = (String)obj;
            if (!new File(Activity.getFakedIconDir()).exists()) {
                new File(Activity.getFakedIconDir()).mkdirs();
            }
        }
    }

    private void doImport() {
        if (this.mSelectedItem == null) {
            return;
        }
        String appName = this.mSelectedItem.toString();
        ImportOneApkShortcutThread toast = new ImportOneApkShortcutThread(appName);
        toast.run();
        String selectedItemStr = this.mSelectedItem.toString();
        if (selectedItemStr == null || selectedItemStr.trim().equals("")) {
            return;
        }
    }

    private void onImportActivityInfo(Activity ac, File f) {
        this.mCurrentValue = ac.getComponentName();
        StateBar.getInstance().setText(ResourceFactory.getString("complete"));
        if (ac.isCache()) {
            return;
        }
        CacheActivityManager.putCacheActivity(ac, f);
    }

    class ImportOneApkShortcutThread
    extends Thread
    implements Observer {
        protected File apkFile;
        protected String packageName;
        private Member member;
        private String appName;
        private ApkInfo apkInfo;

        public ImportOneApkShortcutThread(String appName) {
            this.appName = appName;
            String sKey = null;
            int i = appName.indexOf(40);
            sKey = appName.substring(0, i - 1);
            this.member = (Member)SelectComponentNameHelper.this.hashMapApp.get(sKey);
            this.packageName = this.member.mPackageName;
        }

        @Override
        public void run() {
            String name = new File(this.member.mLocation).getName();
            StateBar.getInstance().setText(ResourceFactory.getString("pulling_apk"));
            boolean flag = true;
            flag = CmdUtils.adb_pull(this.member.mLocation);
            this.apkFile = new File(String.valueOf(SelectComponentNameHelper.this.userDir) + File.separator + name);
            if (!flag) {
                logger.error("adb pull apk file error.");
                StateBar.getInstance().setText(ResourceFactory.getString("pulling_apk.fail"));
                return;
            }
            StateBar.getInstance().setText(ResourceFactory.getString("decompile_apk"));
            flag = CmdUtils.apktool(this.apkFile.getAbsolutePath(), this.packageName);
            if (!flag) {
                StateBar.getInstance().setText(ResourceFactory.getString("decompile_apk.fail"));
                OS.rmDir(String.valueOf(SelectComponentNameHelper.this.userDir) + File.separator + this.packageName);
                OS.rmFile(this.apkFile.getAbsolutePath());
                return;
            }
            this.apkInfo = new AndroidManifestParser().parserXml(String.valueOf(SelectComponentNameHelper.this.userDir) + File.separator + this.packageName + File.separator + "AndroidManifest.xml");
            if (this.apkInfo == null) {
                StateBar.getInstance().setText(ResourceFactory.getString("fail"));
                OS.rmDir(String.valueOf(SelectComponentNameHelper.this.userDir) + File.separator + this.packageName);
                OS.rmFile(this.apkFile.getAbsolutePath());
                return;
            }
            ArrayList<Activity> activities = this.apkInfo.getActivities();
            if (activities.size() <= 0) {
                StateBar.getInstance().setText(ResourceFactory.getString("fail"));
                OS.rmDir(String.valueOf(SelectComponentNameHelper.this.userDir) + File.separator + this.packageName);
                OS.rmFile(this.apkFile.getAbsolutePath());
                return;
            }
            if (1 == activities.size()) {
                this.update(null, activities.get(0));
            } else {
                ShortcutSelectDialog isd = new ShortcutSelectDialog(MainFrame.getInstance(), activities);
                isd.addObserver(this);
                isd.openDialog();
            }
        }

        @Override
        public void update(Observable o, Object arg) {
            if (arg == null) {
                StateBar.getInstance().setText(ResourceFactory.getString("complete"));
                OS.rmDir(String.valueOf(SelectComponentNameHelper.this.userDir) + File.separator + this.packageName);
                OS.rmFile(this.apkFile.getAbsolutePath());
                return;
            }
            if (!(arg instanceof Activity)) {
                return;
            }
            Activity ac = (Activity)arg;
            String iconName = ac.getIcon();
            File f = new ApkUtils().searchResource(String.valueOf(SelectComponentNameHelper.this.userDir) + File.separator + this.packageName, iconName, null);
            if (f == null) {
                StateBar.getInstance().setText(ResourceFactory.getString("fail"));
                return;
            }
            SelectComponentNameHelper.this.onImportActivityInfo(ac, f);
            OS.rmDir(String.valueOf(SelectComponentNameHelper.this.userDir) + File.separator + this.packageName);
            OS.rmFile(this.apkFile.getAbsolutePath());
        }
    }
}

