/*
 * Decompiled with CFR 0.152.
 */
package miui.imagefilters;

import miui.imagefilters.IImageFilter;
import miui.imagefilters.ImageData;
import miui.imagefilters.ImageFilterUtils;

public class GrayScaleFilter
implements IImageFilter {
    private int mBlackColor = -16777216;
    private int mWhiteColor = -1;

    public void setBlackColor(String strColor) {
        this.mBlackColor = GrayScaleFilter.parseColor(strColor);
    }

    public void setWhiteColor(String strColor) {
        this.mWhiteColor = GrayScaleFilter.parseColor(strColor);
    }

    public static int parseColor(String colorString) {
        if (colorString.charAt(0) == '#') {
            long color = Long.parseLong(colorString.substring(1), 16);
            if (colorString.length() == 7) {
                color |= 0xFFFFFFFFFF000000L;
            } else if (colorString.length() != 9) {
                throw new IllegalArgumentException("Unknown color");
            }
            return (int)color;
        }
        throw new IllegalArgumentException("Unknown color");
    }

    @Override
    public void process(ImageData imgData) {
        int width = imgData.width;
        int height = imgData.height;
        int[] pixels = imgData.pixels;
        int aBlack = this.mBlackColor >>> 24;
        int aWhite = this.mWhiteColor >>> 24;
        int rBlack = this.mBlackColor >>> 16 & 0xFF;
        int rWhite = this.mWhiteColor >>> 16 & 0xFF;
        int gBlack = this.mBlackColor >>> 8 & 0xFF;
        int gWhite = this.mWhiteColor >>> 8 & 0xFF;
        int bBlack = this.mBlackColor & 0xFF;
        int bWhite = this.mWhiteColor & 0xFF;
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int colorIndex = y * width + x;
                int argb = pixels[colorIndex];
                int luminance = ImageFilterUtils.convertColorToGrayscale(argb);
                int newA = ImageFilterUtils.interpolate(0, 255, aBlack, aWhite, luminance);
                int newR = ImageFilterUtils.interpolate(0, 255, rBlack, rWhite, luminance);
                int newG = ImageFilterUtils.interpolate(0, 255, gBlack, gWhite, luminance);
                int newB = ImageFilterUtils.interpolate(0, 255, bBlack, bWhite, luminance);
                newA = newA * (argb >>> 24) / 255;
                pixels[colorIndex] = newA << 24 | newR << 16 | newG << 8 | newB;
                ++y;
            }
            ++x;
        }
    }
}

