/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.breadcrumb;

import com.alee.extended.breadcrumb.BreadcrumbElement;
import com.alee.extended.breadcrumb.BreadcrumbElementType;
import com.alee.extended.breadcrumb.BreadcrumbUtils;
import com.alee.extended.breadcrumb.WebBreadcrumbStyle;
import com.alee.extended.layout.BreadcrumbLayout;
import com.alee.laf.panel.WebPanel;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;

public class WebBreadcrumb
extends WebPanel {
    private int overlap = WebBreadcrumbStyle.overlap;
    private Insets margin = WebBreadcrumbStyle.margin;
    private boolean encloseLastElement = WebBreadcrumbStyle.encloseLastElement;
    private boolean autoUpdate = true;

    public WebBreadcrumb() {
        this(true);
    }

    public WebBreadcrumb(boolean bl) {
        super(bl, BreadcrumbUtils.createDefaultLayout());
        this.setDrawFocus(true);
        this.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                if (WebBreadcrumb.this.autoUpdate) {
                    WebBreadcrumb.this.updateElement(containerEvent.getChild());
                    WebBreadcrumb.this.updateElementTypes();
                }
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                if (WebBreadcrumb.this.autoUpdate) {
                    WebBreadcrumb.this.updateElementTypes();
                }
            }
        });
    }

    protected boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    protected void setAutoUpdate(boolean bl) {
        this.autoUpdate = bl;
    }

    public int getOverlap() {
        return this.overlap;
    }

    public void setOverlap(int n) {
        this.overlap = n;
        this.getBreadcrumbLayout().setOverlap(n + WebBreadcrumbStyle.shadeWidth);
        this.updateElements();
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(int n, int n2, int n3, int n4) {
        this.setMargin(new Insets(n, n2, n3, n4));
    }

    @Override
    public void setMargin(int n) {
        this.setMargin(n, n, n, n);
    }

    @Override
    public void setMargin(Insets insets) {
        this.margin = insets;
        this.updateElements();
    }

    public boolean isEncloseLastElement() {
        return this.encloseLastElement;
    }

    public void setEncloseLastElement(boolean bl) {
        this.encloseLastElement = bl;
        this.updateElementTypes();
    }

    public void updateBreadcrumb() {
        this.revalidate();
        this.repaint();
    }

    public BreadcrumbLayout getBreadcrumbLayout() {
        return (BreadcrumbLayout)super.getLayout();
    }

    protected void updateElements() {
        for (Component component : this.getComponents()) {
            this.updateElement(component);
        }
        this.updateBreadcrumb();
    }

    protected void updateElement(Component component) {
        SwingUtils.copyOrientation(this, component);
        if (component instanceof BreadcrumbElement) {
            BreadcrumbElement breadcrumbElement = (BreadcrumbElement)((Object)component);
            this.updateElementType(component, breadcrumbElement);
            breadcrumbElement.setOverlap(this.overlap);
            breadcrumbElement.setMargin(this.margin);
        }
    }

    protected void updateElementTypes() {
        for (Component component : this.getComponents()) {
            if (!(component instanceof BreadcrumbElement)) continue;
            this.updateElementType(component, (BreadcrumbElement)((Object)component));
        }
        this.setLayout(this.getLayout());
        this.updateBreadcrumb();
    }

    protected void updateElementType(Component component, BreadcrumbElement breadcrumbElement) {
        int n = this.getComponentZOrder(component);
        int n2 = this.getComponentCount() - 1;
        if (n2 == 0 && !this.encloseLastElement) {
            breadcrumbElement.setType(BreadcrumbElementType.none);
        } else if (n == 0) {
            breadcrumbElement.setType(BreadcrumbElementType.start);
        } else if (n == n2 && !this.encloseLastElement) {
            breadcrumbElement.setType(BreadcrumbElementType.end);
        } else {
            breadcrumbElement.setType(BreadcrumbElementType.middle);
        }
    }
}

