/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.colorchooser;

import com.alee.extended.colorchooser.GradientColorData;
import com.alee.extended.colorchooser.GradientData;
import com.alee.extended.colorchooser.WebGradientColorChooserStyle;
import com.alee.laf.StyleConstants;
import com.alee.laf.colorchooser.WebColorChooser;
import com.alee.managers.settings.SettingsManager;
import com.alee.utils.ColorUtils;
import com.alee.utils.CompareUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WebGradientColorChooser
extends JComponent
implements MouseListener,
MouseMotionListener,
FocusListener {
    private static Color borderColor = Color.DARK_GRAY;
    private static Color disabledBorderColor = Color.LIGHT_GRAY;
    private static Color foreground = Color.BLACK;
    private static Color disabledForeground = new Color(178, 178, 178);
    private static Color innerBorderColor = ColorUtils.white(180);
    private static float[] overlayFractions = new float[]{0.0f, 0.4f, 0.41f, 1.0f};
    private static Color[] lineOverlayColors = new Color[]{ColorUtils.white(160), ColorUtils.white(120), ColorUtils.white(100), ColorUtils.white(40)};
    private static Color[] controlOverlayColors = new Color[]{ColorUtils.white(80), ColorUtils.white(50), ColorUtils.white(20), StyleConstants.transparent};
    private static final Stroke stripeStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{4.0f, 4.0f}, 0.0f);
    private static final float closestPoint = 0.001f;
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private GradientData gradientData;
    private int shadeWidth = WebGradientColorChooserStyle.shadeWidth;
    private int lineWidth = WebGradientColorChooserStyle.lineWidth;
    private Dimension gripperSize = WebGradientColorChooserStyle.gripperSize;
    private Insets margin = WebGradientColorChooserStyle.margin;
    private boolean paintLabels = WebGradientColorChooserStyle.paintLabels;
    private int preferredWidth = WebGradientColorChooserStyle.preferredWidth;
    private GradientColorData draggedGripper = null;
    private boolean draggedOut = false;

    public WebGradientColorChooser() {
        this(SettingsManager.getDefaultValue(GradientData.class));
    }

    public WebGradientColorChooser(GradientData gradientData) {
        this.setGradientData(gradientData);
        this.setFocusable(true);
        this.setFont(WebGradientColorChooserStyle.labelsFont);
        this.setForeground(WebGradientColorChooserStyle.foreground);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Color color;
        GradientColorData gradientColorData;
        if (!this.isEnabled()) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && (gradientColorData = this.getColorDataUnderPoint(mouseEvent.getPoint())) != null && (color = WebColorChooser.showDialog((Component)this, gradientColorData.getColor())) != null) {
            gradientColorData.setColor(color);
            this.fireStateChanged();
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        GradientColorData gradientColorData;
        if (!this.isEnabled()) {
            return;
        }
        if (!this.isFocusOwner()) {
            this.requestFocusInWindow();
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            float f;
            GradientColorData gradientColorData2 = this.getColorDataUnderPoint(mouseEvent.getPoint());
            if (gradientColorData2 != null) {
                if (SwingUtils.isAlt(mouseEvent)) {
                    this.draggedGripper = gradientColorData2.clone();
                    this.draggedGripper.setLocation(this.findFreeLocation(this.draggedGripper.getLocation()));
                    this.gradientData.addGradientColorData(this.draggedGripper);
                    this.draggedOut = false;
                    this.fireStateChanged();
                    this.repaint();
                } else {
                    this.draggedGripper = gradientColorData2;
                    this.draggedOut = false;
                }
            }
            if (this.draggedGripper == null && mouseEvent.getY() > 0 && this.isFree(f = this.getLocationForPoint(mouseEvent))) {
                this.draggedGripper = new GradientColorData(f, this.getColorForLocation(f));
                this.gradientData.addGradientColorData(this.draggedGripper);
                this.draggedOut = false;
                this.fireStateChanged();
                this.repaint();
            }
        } else if ((SwingUtils.isMiddleMouseButton(mouseEvent) || SwingUtils.isRightMouseButton(mouseEvent)) && this.gradientData.size() > 2 && (gradientColorData = this.getColorDataUnderPoint(mouseEvent.getPoint())) != null) {
            this.gradientData.removeGradientColorData(gradientColorData);
            this.fireStateChanged();
            this.repaint();
        }
    }

    public GradientColorData getColorDataUnderPoint(Point point) {
        GradientColorData gradientColorData = null;
        for (int i = this.gradientData.size() - 1; i >= 0; --i) {
            GradientColorData gradientColorData2 = this.gradientData.get(i);
            if (!this.getGripperBounds(gradientColorData2).contains(point)) continue;
            gradientColorData = gradientColorData2;
            break;
        }
        return gradientColorData;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.draggedGripper != null) {
            if (mouseEvent.getY() < -10 && this.gradientData.size() + (this.draggedOut ? 1 : 0) > 2) {
                if (!this.draggedOut) {
                    this.draggedOut = true;
                    this.gradientData.removeGradientColorData(this.draggedGripper);
                    this.fireStateChanged();
                    this.repaint();
                }
            } else {
                if (this.draggedOut) {
                    this.draggedOut = false;
                    this.gradientData.addGradientColorData(this.draggedGripper);
                }
                float f = this.getLocationForPoint(mouseEvent);
                f = this.findFreeLocation(f);
                this.draggedGripper.setLocation(f);
                this.fireStateChanged();
                this.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.draggedGripper = null;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public boolean isFree(float f) {
        return !this.gradientData.containtsLocation(f);
    }

    private float findFreeLocation(float f) {
        block4: {
            if (!this.gradientData.containtsLocation(f)) break block4;
            if (f == 1.0f) {
                while (this.gradientData.containtsLocation(f)) {
                    f -= 0.001f;
                }
            } else {
                while (this.gradientData.containtsLocation(f)) {
                    f += 0.001f;
                }
            }
        }
        return f;
    }

    public Rectangle getGripperBounds(int n) {
        return this.getGripperBounds(this.gradientData.getGradientColorsData().get(n));
    }

    public Rectangle getGripperBounds(GradientColorData gradientColorData) {
        float f = gradientColorData.getLocation();
        Rectangle rectangle = this.getLineBounds();
        int n = rectangle.x + 2 + Math.round((float)(rectangle.width - 4) * f) - this.gripperSize.width / 2;
        int n2 = rectangle.y + rectangle.height - this.gripperSize.height / 2;
        return new Rectangle(n, n2, this.gripperSize.width, this.gripperSize.height);
    }

    private float getLocationForPoint(MouseEvent mouseEvent) {
        return this.getLocationForPoint(mouseEvent.getPoint());
    }

    public float getLocationForPoint(Point point) {
        Rectangle rectangle = this.getLineBounds();
        int n = rectangle.x + 2;
        int n2 = rectangle.width - 4;
        return (float)Math.max(0, Math.min(point.x - n, n2)) / (float)n2;
    }

    public Color getColorForLocation(float f) {
        return this.gradientData.getColorForLocation(f);
    }

    public GradientData getGradientData() {
        return this.gradientData;
    }

    public void setGradientData(GradientData gradientData) {
        if (!CompareUtils.equals(this.gradientData, gradientData)) {
            this.gradientData = gradientData;
            this.draggedGripper = null;
            this.fireStateChanged();
            this.repaint();
        }
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int n) {
        this.shadeWidth = n;
        this.updateBorder();
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int n) {
        this.lineWidth = n;
    }

    public Dimension getGripperSize() {
        return this.gripperSize;
    }

    public void setGripperSize(Dimension dimension) {
        this.gripperSize = dimension;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
        this.updateBorder();
    }

    public void setMargin(int n, int n2, int n3, int n4) {
        this.setMargin(new Insets(n, n2, n3, n4));
    }

    public void setMargin(int n) {
        this.setMargin(n, n, n, n);
    }

    private void updateBorder() {
        this.setBorder(BorderFactory.createEmptyBorder(this.margin.top, this.margin.left, this.margin.bottom, this.margin.right));
    }

    public boolean isPaintLabels() {
        return this.paintLabels;
    }

    public void setPaintLabels(boolean bl) {
        this.paintLabels = bl;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        LafUtils.setupAntialias(graphics2D);
        Rectangle rectangle = this.getLineBounds();
        this.paintBorderedBackground(graphics2D, rectangle, this.getLineBackgroundPainter(rectangle), this.getLineOverlayPainter(rectangle), false);
        this.paintControls(graphics2D, rectangle);
    }

    private void paintControls(Graphics2D graphics2D, Rectangle rectangle) {
        int n = rectangle.x + 2;
        int n2 = rectangle.x + rectangle.width - 2;
        int n3 = rectangle.width - 4;
        int n4 = rectangle.y + rectangle.height - this.gripperSize.height / 2;
        int n5 = n4 + this.gripperSize.height;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n6 = n5 + fontMetrics.getDescent() - fontMetrics.getHeight() / 2;
        for (int i = 0; i < this.gradientData.size(); ++i) {
            int n7;
            int n8;
            GradientColorData gradientColorData = this.gradientData.get(i);
            float f = gradientColorData.getLocation();
            int n9 = n + Math.round((float)n3 * f) - this.gripperSize.width / 2;
            Rectangle rectangle2 = new Rectangle(n9, n4, this.gripperSize.width, this.gripperSize.height);
            this.paintBorderedBackground(graphics2D, rectangle2, gradientColorData.getColor(), this.getControlOverlayPainter(rectangle2), true);
            if (!this.paintLabels || i >= this.gradientData.size() - 1) continue;
            GradientColorData gradientColorData2 = this.gradientData.get(i + 1);
            int n10 = n9 + this.gripperSize.width;
            int n11 = n + Math.round((float)n3 * gradientColorData2.getLocation()) - this.gripperSize.width / 2;
            if (n11 - n10 <= (n8 = fontMetrics.stringWidth((n7 = Math.round((gradientColorData2.getLocation() - f) * 100.0f)) + "")) + 4) continue;
            int n12 = (n10 + n11) / 2 - n8 / 2;
            graphics2D.setPaint(this.isEnabled() ? foreground : disabledForeground);
            graphics2D.drawString(n7 + "", n12, n5);
            if (n11 - n10 <= n8 + 14) continue;
            graphics2D.setPaint(new GradientPaint(n10 + 2, 0.0f, StyleConstants.transparent, n12 - 2, 0.0f, Color.LIGHT_GRAY));
            graphics2D.drawLine(n10 + 2, n6, n12 - 2, n6);
            graphics2D.setPaint(new GradientPaint(n12 + n8 + 2, 0.0f, Color.LIGHT_GRAY, n11 - 2, 0.0f, StyleConstants.transparent));
            graphics2D.drawLine(n12 + n8 + 2, n6, n11 - 2, n6);
        }
    }

    private void paintBorderedBackground(Graphics2D graphics2D, Rectangle rectangle, Paint paint, Paint paint2, boolean bl) {
        if (this.isEnabled() && !bl) {
            LafUtils.drawShade(graphics2D, new RoundRectangle2D.Double(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 4.0, 4.0), this.isFocusOwner() ? StyleConstants.fieldFocusColor : StyleConstants.borderColor, this.shadeWidth);
        }
        graphics2D.setPaint(paint);
        graphics2D.fillRoundRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2, 2, 2);
        graphics2D.setPaint(innerBorderColor);
        graphics2D.drawRoundRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 3, rectangle.height - 3, 2, 2);
        if (bl) {
            graphics2D.setPaint(new GradientPaint(rectangle.x + 2, rectangle.y + 2, ColorUtils.white(180), rectangle.x + rectangle.width * 2 / 3, rectangle.y + rectangle.height - 2, StyleConstants.transparent));
            graphics2D.fillRect(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
        }
        graphics2D.setPaint(paint2);
        graphics2D.fillRect(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
        graphics2D.setPaint(this.isEnabled() ? borderColor : disabledBorderColor);
        graphics2D.drawRoundRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 4, 4);
    }

    private LinearGradientPaint getLineBackgroundPainter(Rectangle rectangle) {
        return new LinearGradientPaint(rectangle.x + 1, 0.0f, rectangle.x + rectangle.width - 1, 0.0f, this.gradientData.getFractions(), this.gradientData.getColors());
    }

    private LinearGradientPaint getLineOverlayPainter(Rectangle rectangle) {
        return this.getOverlayPainter(rectangle, overlayFractions, lineOverlayColors);
    }

    private LinearGradientPaint getControlOverlayPainter(Rectangle rectangle) {
        return this.getOverlayPainter(rectangle, overlayFractions, controlOverlayColors);
    }

    private LinearGradientPaint getOverlayPainter(Rectangle rectangle, float[] fArray, Color[] colorArray) {
        return new LinearGradientPaint(0.0f, rectangle.y + 2, 0.0f, rectangle.y + rectangle.height - 2, fArray, colorArray);
    }

    private Rectangle getLineBounds() {
        Insets insets = this.getInsets();
        return new Rectangle(insets.left + Math.max(this.gripperSize.width / 2, this.shadeWidth) - 2, insets.top + this.shadeWidth, this.getWidth() - insets.left - insets.right - Math.max(this.gripperSize.width, this.shadeWidth * 2) + 4, this.lineWidth);
    }

    public void setPreferredWidth(int n) {
        this.preferredWidth = n;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Dimension dimension = new Dimension(insets.left + this.gripperSize.width * 5 + Math.max(this.gripperSize.width, this.shadeWidth * 2) - 4 + insets.right, insets.top + this.shadeWidth * 2 + this.lineWidth + this.gripperSize.height / 2 + (this.gripperSize.height % 2 == 0 ? 0 : 1) + insets.bottom);
        if (this.preferredWidth != -1) {
            dimension.width = this.preferredWidth;
        }
        return dimension;
    }

    public List<ChangeListener> getChangeListeners() {
        return this.changeListeners;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    private void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

