/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.extended.drag.FileDropHandler;
import com.alee.extended.filechooser.FilesSelectionListener;
import com.alee.extended.filechooser.WebFilePlate;
import com.alee.extended.filefilter.DefaultFileFilter;
import com.alee.extended.layout.WrapFlowLayout;
import com.alee.laf.StyleConstants;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.Timer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

public class WebFileDrop
extends WebPanel
implements LanguageMethods {
    public static final ImageIcon CROSS_ICON = new ImageIcon(WebFileDrop.class.getResource("icons/cross.png"));
    private static final BasicStroke dashStroke = new BasicStroke(3.0f, 1, 1, 1.0f, new float[]{8.0f, 8.0f}, 0.0f);
    public int dashRound = StyleConstants.smallRound;
    public int dashSideSpacing = 10;
    private Color dropBackground = new Color(242, 242, 242);
    private Color dropBorder = new Color(192, 192, 192);
    private List<FilesSelectionListener> listeners = new ArrayList<FilesSelectionListener>();
    private boolean showRemoveButton = true;
    private boolean showFileExtensions = false;
    private boolean filesDropEnabled = true;
    private boolean allowSameFiles = false;
    private DefaultFileFilter fileFilter = null;
    private boolean showDropText = true;
    private float dropTextOpacity = 1.0f;
    private String dropText = null;
    private List<File> selectedFiles = new ArrayList<File>();

    public WebFileDrop() {
        this.setBackground(Color.WHITE);
        this.setLayout(new WrapFlowLayout(true));
        this.setMargin(1, 1, 1, 1);
        this.setFocusable(true);
        this.setFont(SwingUtils.getDefaultLabelFont().deriveFont(1).deriveFont(20.0f));
        this.setShowDefaultDropText(true);
        this.setTransferHandler(new FileDropHandler(){

            @Override
            protected boolean isDropEnabled() {
                return WebFileDrop.this.filesDropEnabled;
            }

            @Override
            protected boolean filesImported(List<File> list) {
                boolean bl = false;
                for (File file : list) {
                    if (WebFileDrop.this.fileFilter != null && !WebFileDrop.this.fileFilter.accept(file) || !WebFileDrop.this.allowSameFiles && FileUtils.containtsFile(WebFileDrop.this.selectedFiles, file)) continue;
                    WebFileDrop.this.selectedFiles.add(file);
                    WebFileDrop.this.add((Component)WebFileDrop.this.createFilePlate(file));
                    bl = true;
                }
                if (bl) {
                    WebFileDrop.this.revalidate();
                    WebFileDrop.this.repaint();
                    WebFileDrop.this.fireSelectionChanged(WebFileDrop.this.selectedFiles);
                }
                return bl;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                WebFileDrop.this.requestFocusInWindow();
            }
        });
        this.addFileSelectionListener(new FilesSelectionListener(){
            private int filesCount = 0;
            private Timer animator = null;

            @Override
            public void selectionChanged(List<File> list) {
                if (this.filesCount == 0 && list.size() > 0) {
                    this.stopAnimator();
                    this.filesCount = list.size();
                    this.animator = new Timer("WebFileDrop.textFadeOutTimer", (long)StyleConstants.animationDelay, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (WebFileDrop.this.dropTextOpacity > 0.0f) {
                                WebFileDrop.this.dropTextOpacity -= 0.1f;
                            }
                            WebFileDrop.this.dropTextOpacity = Math.max(WebFileDrop.this.dropTextOpacity, 0.0f);
                            WebFileDrop.this.repaint();
                            if (WebFileDrop.this.dropTextOpacity <= 0.0f) {
                                animator.stop();
                            }
                        }
                    });
                    this.animator.start();
                } else if (this.filesCount > 0 && list.size() == 0) {
                    this.stopAnimator();
                    this.filesCount = list.size();
                    this.animator = new Timer("WebFileDrop.textFadeInTimer", (long)StyleConstants.animationDelay, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (WebFileDrop.this.dropTextOpacity < 1.0f) {
                                WebFileDrop.this.dropTextOpacity += 0.1f;
                            }
                            WebFileDrop.this.dropTextOpacity = Math.min(WebFileDrop.this.dropTextOpacity, 1.0f);
                            WebFileDrop.this.repaint();
                            if (WebFileDrop.this.dropTextOpacity >= 1.0f) {
                                animator.stop();
                            }
                        }
                    });
                    this.animator.start();
                }
            }

            private void stopAnimator() {
                if (this.animator != null && this.animator.isRunning()) {
                    this.animator.stop();
                }
            }
        });
    }

    public boolean isShowDropText() {
        return this.showDropText;
    }

    public void setShowDropText(boolean bl) {
        this.showDropText = bl;
        this.repaint();
    }

    public boolean isFilesDropEnabled() {
        return this.filesDropEnabled;
    }

    public void setFilesDropEnabled(boolean bl) {
        this.filesDropEnabled = bl;
    }

    public List<File> getSelectedFiles() {
        return this.selectedFiles;
    }

    public void setSelectedFiles(List<File> list) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : list) {
            if (this.fileFilter != null && !this.fileFilter.accept(file) || !this.allowSameFiles && FileUtils.containtsFile(arrayList, file)) continue;
            arrayList.add(file);
        }
        if (FileUtils.equals(arrayList, this.selectedFiles)) {
            this.selectedFiles = arrayList;
            this.updateFilesList();
            this.fireSelectionChanged(arrayList);
        }
    }

    public boolean isAllowSameFiles() {
        return this.allowSameFiles;
    }

    public void setAllowSameFiles(boolean bl) {
        this.allowSameFiles = bl;
        this.setSelectedFiles(this.selectedFiles);
    }

    public DefaultFileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(DefaultFileFilter defaultFileFilter) {
        this.fileFilter = defaultFileFilter;
        this.setSelectedFiles(this.selectedFiles);
    }

    public boolean isShowRemoveButton() {
        return this.showRemoveButton;
    }

    public void setShowRemoveButton(boolean bl) {
        this.showRemoveButton = bl;
        this.updateFilesList();
    }

    public boolean isShowFileExtensions() {
        return this.showFileExtensions;
    }

    public void setShowFileExtensions(boolean bl) {
        this.showFileExtensions = bl;
        this.updateFilesList();
    }

    public Color getDropBackground() {
        return this.dropBackground;
    }

    public void setDropBackground(Color color) {
        this.dropBackground = color;
        this.repaint();
    }

    public Color getDropBorder() {
        return this.dropBorder;
    }

    public void setDropBorder(Color color) {
        this.dropBorder = color;
        this.repaint();
    }

    public int getDashRound() {
        return this.dashRound;
    }

    public void setDashRound(int n) {
        this.dashRound = n;
        this.repaint();
    }

    public int getDashSideSpacing() {
        return this.dashSideSpacing;
    }

    public void setDashSideSpacing(int n) {
        this.dashSideSpacing = n;
        this.repaint();
    }

    public String getDropText() {
        return this.dropText;
    }

    public void setDropText(String string) {
        this.dropText = string;
        this.repaint();
    }

    public void setShowDefaultDropText(boolean bl) {
        if (bl) {
            this.setLanguage("weblaf.ex.filedrop.drop", new Object[0]);
        } else {
            this.removeLanguage();
        }
        this.repaint();
    }

    public boolean isDropTextVisible() {
        return this.dropText != null && this.showDropText && this.dropTextOpacity > 0.0f;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.isDropTextVisible()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = LafUtils.setupAlphaComposite(graphics2D, this.dropTextOpacity);
            Object object = LafUtils.setupAntialias(graphics2D);
            graphics2D.setPaint(this.dropBackground);
            graphics2D.fillRoundRect(this.dashSideSpacing + Math.round(dashStroke.getLineWidth() / 2.0f), this.dashSideSpacing + Math.round(dashStroke.getLineWidth() / 2.0f), this.getWidth() - this.dashSideSpacing * 2 - Math.round(dashStroke.getLineWidth()), this.getHeight() - this.dashSideSpacing * 2 - Math.round(dashStroke.getLineWidth()), this.dashRound * 2, this.dashRound * 2);
            graphics2D.setPaint(this.dropBorder);
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(dashStroke);
            graphics2D.drawRoundRect(this.dashSideSpacing, this.dashSideSpacing, this.getWidth() - this.dashSideSpacing * 2 - 1, this.getHeight() - this.dashSideSpacing * 2 - 1, this.dashRound * 2, this.dashRound * 2);
            graphics2D.setStroke(stroke);
            LafUtils.restoreAntialias(graphics2D, object);
            Map map = SwingUtils.setupTextAntialias(graphics2D, (Component)this);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            graphics2D.drawString(this.dropText, this.getWidth() / 2 - fontMetrics.stringWidth(this.dropText) / 2, this.getHeight() / 2 + fontMetrics.getAscent() / 2);
            SwingUtils.restoreTextAntialias(graphics2D, map);
            LafUtils.restoreComposite(graphics2D, composite);
        }
    }

    private void updateFilesList() {
        this.removeAll();
        for (File file : this.selectedFiles) {
            this.add((Component)this.createFilePlate(file));
        }
        this.revalidate();
        this.repaint();
    }

    private WebFilePlate createFilePlate(final File file) {
        WebFilePlate webFilePlate = new WebFilePlate(file);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                WebFileDrop.this.requestFocusInWindow();
            }
        });
        webFilePlate.addCloseListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebFileDrop.this.selectedFiles.remove(file);
                WebFileDrop.this.fireSelectionChanged(WebFileDrop.this.selectedFiles);
            }
        });
        return webFilePlate;
    }

    public void addFileSelectionListener(FilesSelectionListener filesSelectionListener) {
        this.listeners.add(filesSelectionListener);
    }

    public void removeFileSelectionListener(FilesSelectionListener filesSelectionListener) {
        this.listeners.remove(filesSelectionListener);
    }

    private void fireSelectionChanged(List<File> list) {
        for (FilesSelectionListener filesSelectionListener : CollectionUtils.copy(this.listeners)) {
            filesSelectionListener.selectionChanged(list);
        }
    }

    @Override
    public void setLanguage(String string, Object ... objectArray) {
        LanguageManager.registerComponent(this, string, objectArray);
    }

    @Override
    public void updateLanguage(Object ... objectArray) {
        LanguageManager.updateComponent((Component)this, objectArray);
    }

    @Override
    public void updateLanguage(String string, Object ... objectArray) {
        LanguageManager.updateComponent((Component)this, string, objectArray);
    }

    @Override
    public void removeLanguage() {
        LanguageManager.unregisterComponent(this);
    }

    @Override
    public boolean isLanguageSet() {
        return LanguageManager.isRegisteredComponent(this);
    }

    @Override
    public void setLanguageUpdater(LanguageUpdater languageUpdater) {
        LanguageManager.registerLanguageUpdater(this, languageUpdater);
    }

    @Override
    public void removeLanguageUpdater() {
        LanguageManager.unregisterLanguageUpdater(this);
    }
}

