/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.managers.settings.SettingsManager;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.Timer;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class WebTipLabel
extends JComponent
implements SwingConstants,
ActionListener {
    public static final ImageIcon HIDE_ICON = new ImageIcon(WebTipLabel.class.getResource("icons/hide.png"));
    public static final ImageIcon HIDE_DARK_ICON = new ImageIcon(WebTipLabel.class.getResource("icons/hide_dark.png"));
    public static final String SETTINGS_GROUP = "WebTipLabel";
    private String id;
    private int opacity = 100;
    private Timer timer = null;
    private WebButton hideButton;
    private WebLabel helpLabel;

    public WebTipLabel(String string) {
        this(string, "");
    }

    public WebTipLabel(String string, String string2) {
        this(string, string2, null);
    }

    public WebTipLabel(String string, int n) {
        this(string, "", n);
    }

    public WebTipLabel(String string, Icon icon) {
        this(string, "", icon);
    }

    public WebTipLabel(String string, String string2, Icon icon) {
        this(string, string2, icon, 2);
    }

    public WebTipLabel(String string, String string2, int n) {
        this(string, string2, null, n);
    }

    public WebTipLabel(String string, String string2, Icon icon, int n) {
        double[] dArray;
        this.id = string;
        SwingUtils.setOrientation(this);
        this.setFocusable(false);
        this.setOpaque(false);
        double[][] dArrayArray = new double[2][];
        if (n == 2) {
            double[] dArray2 = new double[2];
            dArray2[0] = -2.0;
            dArray = dArray2;
            dArray2[1] = -2.0;
        } else if (n == 0) {
            double[] dArray3 = new double[4];
            dArray3[0] = -1.0;
            dArray3[1] = -2.0;
            dArray3[2] = -2.0;
            dArray = dArray3;
            dArray3[3] = -1.0;
        } else {
            double[] dArray4 = new double[3];
            dArray4[0] = -1.0;
            dArray4[1] = -2.0;
            dArray = dArray4;
            dArray4[2] = -2.0;
        }
        dArrayArray[0] = dArray;
        dArrayArray[1] = new double[]{-2.0};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        tableLayout.setHGap(4);
        this.setLayout(tableLayout);
        this.hideButton = new WebButton(HIDE_ICON);
        this.hideButton.setRolloverIcon(HIDE_DARK_ICON);
        this.hideButton.setUndecorated(true);
        this.hideButton.addActionListener(this);
        this.helpLabel = new WebLabel();
        this.helpLabel.setIcon(icon);
        this.helpLabel.setText(string2);
        this.helpLabel.setForeground(Color.DARK_GRAY);
        SwingUtils.changeFontSize(this.helpLabel, -1);
        if (n == 2) {
            this.add((Component)this.hideButton, "0,0");
            this.add((Component)this.helpLabel, "1,0");
        } else {
            this.add((Component)this.hideButton, "1,0");
            this.add((Component)this.helpLabel, "2,0");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.hideButton.setEnabled(false);
        this.timer = new Timer("WebTipLabel.animator", (long)StyleConstants.animationDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WebTipLabel.this.opacity > 0) {
                    WebTipLabel.this.opacity -= 10;
                    WebTipLabel.this.repaint();
                } else {
                    Container container = WebTipLabel.this.getParent();
                    container.remove(WebTipLabel.this);
                    if (container instanceof JComponent) {
                        ((JComponent)container).revalidate();
                    } else {
                        container.invalidate();
                    }
                    container.repaint();
                    SettingsManager.set(WebTipLabel.SETTINGS_GROUP, WebTipLabel.this.id, false);
                    WebTipLabel.this.timer.stop();
                }
            }
        });
        this.timer.start();
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = LafUtils.setupAntialias(graphics2D);
        Composite composite = LafUtils.setupAlphaComposite(graphics2D, (float)this.opacity / 100.0f, this.opacity < 100);
        super.paint(graphics);
        LafUtils.restoreComposite(graphics2D, composite);
        LafUtils.restoreAntialias(graphics2D, object);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setText(String string) {
        this.helpLabel.setText(string);
    }

    public String getText() {
        return this.helpLabel.getText();
    }

    public void setIcon(Icon icon) {
        this.helpLabel.setIcon(icon);
    }

    public Icon getIcon() {
        return this.helpLabel.getIcon();
    }

    public void setVerticalAlignment(int n) {
        this.helpLabel.setVerticalAlignment(n);
    }

    public void setHorizontalAlignment(int n) {
        this.helpLabel.setHorizontalAlignment(n);
    }

    public void setVerticalTextPosition(int n) {
        this.helpLabel.setVerticalTextPosition(n);
    }

    public void setHorizontalTextPosition(int n) {
        this.helpLabel.setHorizontalTextPosition(n);
    }

    public WebLabel getHelpLabel() {
        return this.helpLabel;
    }

    public WebButton getHideButton() {
        return this.hideButton;
    }
}

