/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.extended.layout.RowData;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.SwingConstants;

public class WrapFlowLayout
implements LayoutManager,
SwingConstants {
    private boolean fitWidth = true;
    private boolean fillWidth = true;
    private int hgap = 0;
    private int vgap = 0;
    private int halign = 2;
    private int valign = 1;
    private boolean wrapEachComponent = false;
    private int maxWidth = 0;
    private int maxHeight = 0;
    private ArrayList<RowData> rowsData;

    public WrapFlowLayout() {
        this(false);
    }

    public WrapFlowLayout(boolean bl) {
        this(bl, 0, 0);
    }

    public WrapFlowLayout(int n, int n2) {
        this(false, n, n2);
    }

    public WrapFlowLayout(boolean bl, int n, int n2) {
        this.fillWidth = bl;
        this.hgap = n;
        this.vgap = n2;
    }

    public boolean isFitWidth() {
        return this.fitWidth;
    }

    public void setFitWidth(boolean bl) {
        this.fitWidth = bl;
    }

    public boolean isFillWidth() {
        return this.fillWidth;
    }

    public void setFillWidth(boolean bl) {
        this.fillWidth = bl;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public int getHalign() {
        return this.halign;
    }

    public void setHalign(int n) {
        this.halign = n;
    }

    public int getValign() {
        return this.valign;
    }

    public void setValign(int n) {
        this.valign = n;
    }

    public boolean isWrapEachComponent() {
        return this.wrapEachComponent;
    }

    public void setWrapEachComponent(boolean bl) {
        this.wrapEachComponent = bl;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public ArrayList<RowData> getRowsData() {
        return this.rowsData;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public void layoutContainer(Container container) {
        int n;
        if (container.getComponentCount() == 0) {
            return;
        }
        Insets insets = container.getInsets();
        int n2 = container.getWidth() - insets.left - insets.right;
        int n3 = 0;
        int n4 = 0;
        this.maxWidth = 0;
        this.maxHeight = 0;
        int n5 = 0;
        int n6 = 0;
        this.rowsData = new ArrayList();
        for (n = 0; n < container.getComponentCount(); ++n) {
            Component component = container.getComponent(n);
            Dimension dimension = component.getPreferredSize();
            if (n4 > 0 && (this.isWrapEachComponent() || n5 + this.hgap + dimension.width > n2)) {
                this.rowsData.get(n3).setWidth(n5);
                this.rowsData.get(n3).setHeight(n6);
                this.maxWidth = Math.max(this.maxWidth, n5);
                this.maxHeight += (n3 > 0 ? this.vgap : 0) + n6;
                n4 = 0;
                n5 = 0;
                n6 = 0;
                ++n3;
            }
            int n7 = this.fitWidth ? Math.min(dimension.width, n2) : dimension.width;
            n5 += (n4 > 0 ? this.hgap : 0) + n7;
            n6 = Math.max(n6, dimension.height);
            ++n4;
            if (n3 >= this.rowsData.size()) {
                this.rowsData.add(new RowData());
            }
            this.rowsData.get(n3).addComponent(component);
        }
        this.rowsData.get(n3).setWidth(n5);
        this.rowsData.get(n3).setHeight(n6);
        this.maxHeight += (n3 > 0 ? this.vgap : 0) + n6;
        this.maxHeight += insets.top + insets.bottom;
        int n8 = this.getStartY(container, insets);
        for (RowData rowData : this.rowsData) {
            n = this.getStartX(container, insets, rowData);
            int n9 = 0;
            for (Component component : rowData.getComponents()) {
                int n10;
                Dimension dimension = component.getPreferredSize();
                int n11 = n10 = this.fitWidth ? Math.min(dimension.width, n2) : dimension.width;
                if (this.fillWidth && n9 + 1 == rowData.getComponents().size() && this.halign == 2) {
                    n10 = insets.left + n2 - n;
                }
                component.setBounds(n, n8, n10, rowData.getHeight());
                n += n10 + this.hgap;
                ++n9;
            }
            n8 += rowData.getHeight() + this.vgap;
        }
    }

    private int getStartX(Container container, Insets insets, RowData rowData) {
        int n = this.fillWidth || this.halign == 2 ? insets.left : (this.halign == 4 ? container.getWidth() - insets.right - rowData.getWidth() : container.getWidth() / 2 - rowData.getWidth() / 2);
        return n;
    }

    private int getStartY(Container container, Insets insets) {
        int n = this.valign == 1 ? insets.top : (this.valign == 3 ? container.getHeight() - insets.bottom - this.maxHeight : insets.top + container.getHeight() / 2 - this.maxHeight / 2);
        return n;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        this.layoutContainer(container);
        return new Dimension(0, this.maxHeight);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        this.layoutContainer(container);
        return new Dimension(this.maxWidth, this.maxHeight);
    }
}

