/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.panel;

import com.alee.extended.icon.OrientedIcon;
import com.alee.extended.label.WebVerticalLabel;
import com.alee.extended.panel.CollapsiblePaneListener;
import com.alee.extended.panel.WebCollapsiblePaneStyle;
import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.DataProvider;
import com.alee.utils.swing.Timer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;

public class WebCollapsiblePane
extends WebPanel
implements SwingConstants {
    private boolean animate = WebCollapsiblePaneStyle.animate;
    private ImageIcon expandIcon = WebCollapsiblePaneStyle.expandIcon;
    private ImageIcon collapseIcon = WebCollapsiblePaneStyle.collapseIcon;
    private Insets stateIconMargin = WebCollapsiblePaneStyle.stateIconMargin;
    private boolean rotateStateIcon = WebCollapsiblePaneStyle.rotateStateIcon;
    private boolean showStateIcon = WebCollapsiblePaneStyle.showStateIcon;
    private int stateIconPostion = WebCollapsiblePaneStyle.stateIconPostion;
    private int titlePanePostion = WebCollapsiblePaneStyle.titlePanePostion;
    private Insets contentMargin = WebCollapsiblePaneStyle.contentMargin;
    private List<CollapsiblePaneListener> listeners = new ArrayList<CollapsiblePaneListener>();
    private ImageIcon cachedExpandIcon = null;
    private ImageIcon cachedDisabledExpandIcon = null;
    private ImageIcon cachedCollapseIcon = null;
    private ImageIcon cachedDisabledCollapseIcon = null;
    private DataProvider<Boolean> stateChangeHandler = null;
    private boolean expanded = true;
    private float transitionProgress = 1.0f;
    private float expandSpeed = 0.1f;
    private Timer animator = null;
    private boolean customTitle = false;
    private WebPanel headerPanel;
    private Component titleComponent;
    private WebButton expandButton;
    private WebPanel contentPanel;
    private Component content = null;

    public WebCollapsiblePane() {
        this("");
    }

    public WebCollapsiblePane(String string) {
        this(null, string);
    }

    public WebCollapsiblePane(ImageIcon imageIcon, String string) {
        this(imageIcon, string, null);
    }

    public WebCollapsiblePane(String string, Component component) {
        this(null, string, component);
    }

    public WebCollapsiblePane(Icon icon, String string, Component component) {
        this.content = component;
        this.setDrawFocus(true);
        this.setUndecorated(false);
        this.setWebColored(false);
        this.setRound(StyleConstants.smallRound);
        this.setLayout(new BorderLayout(0, 0));
        this.headerPanel = new WebPanel();
        this.headerPanel.setOpaque(true);
        this.headerPanel.setUndecorated(false);
        this.headerPanel.setShadeWidth(0);
        this.headerPanel.setLayout(new BorderLayout());
        this.headerPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (this.isAllowAction(mouseEvent)) {
                    WebCollapsiblePane.this.takeFocus();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (this.isAllowAction(mouseEvent)) {
                    WebCollapsiblePane.this.invertExpandState();
                }
            }

            private boolean isAllowAction(MouseEvent mouseEvent) {
                return SwingUtilities.isLeftMouseButton(mouseEvent) && SwingUtils.size(WebCollapsiblePane.this).contains(mouseEvent.getPoint());
            }
        });
        this.updateHeaderPosition();
        this.updateDefaultTitleComponent(icon, string);
        this.updateDefaultTitleBorder();
        this.expandButton = new WebButton(this.collapseIcon);
        this.expandButton.setUndecorated(true);
        this.expandButton.setDrawFocus(false);
        this.expandButton.setMoveIconOnPress(false);
        this.expandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebCollapsiblePane.this.invertExpandState();
                WebCollapsiblePane.this.takeFocus();
            }
        });
        this.setStateIcons();
        this.updateStateIconMargin();
        this.updateStateIconPosition();
        this.contentPanel = new WebPanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (WebCollapsiblePane.this.titlePanePostion == 1 || WebCollapsiblePane.this.titlePanePostion == 3) {
                    if (WebCollapsiblePane.this.content != null) {
                        Insets insets = this.getInsets();
                        dimension.width = insets.left + ((WebCollapsiblePane)WebCollapsiblePane.this).content.getPreferredSize().width + insets.right;
                    }
                    if (WebCollapsiblePane.this.transitionProgress < 1.0f) {
                        dimension.height = Math.round((float)dimension.height * WebCollapsiblePane.this.transitionProgress);
                    }
                } else {
                    if (WebCollapsiblePane.this.content != null) {
                        Insets insets = this.getInsets();
                        dimension.height = insets.top + ((WebCollapsiblePane)WebCollapsiblePane.this).content.getPreferredSize().height + insets.bottom;
                    }
                    if (WebCollapsiblePane.this.transitionProgress < 1.0f) {
                        dimension.width = Math.round((float)dimension.width * WebCollapsiblePane.this.transitionProgress);
                    }
                }
                return dimension;
            }
        };
        this.contentPanel.setOpaque(false);
        this.contentPanel.setLayout(new BorderLayout(0, 0));
        this.contentPanel.setMargin(this.contentMargin);
        this.add((Component)this.contentPanel, (Object)"Center");
        if (this.content != null) {
            this.contentPanel.add(this.content, (Object)"Center");
        }
        this.addPropertyChangeListener("componentOrientation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WebCollapsiblePane.this.updateStateIcons();
            }
        });
    }

    private void takeFocus() {
        if (this.isShowing() && this.isEnabled()) {
            this.expandButton.requestFocusInWindow();
        }
    }

    private void updateDefaultTitleComponent() {
        this.updateDefaultTitleComponent(this.getIcon(), this.getTitle());
    }

    private void updateDefaultTitleComponent(Icon icon, String string) {
        if (!this.customTitle) {
            if (this.titleComponent != null) {
                this.headerPanel.remove(this.titleComponent);
            }
            this.titleComponent = this.createDefaultTitleComponent(icon, string);
            this.headerPanel.add(this.titleComponent, (Object)"Center");
        }
    }

    private void updateDefaultTitleBorder() {
        if (this.titleComponent != null && !this.customTitle) {
            Insets insets;
            boolean bl = this.getComponentOrientation().isLeftToRight();
            Insets insets2 = insets = this.getIcon() != null || this.titlePanePostion != 2 || this.titlePanePostion == 4 ? new Insets(2, 2, 2, 2) : new Insets(2, 4, 2, 2);
            if (this.titlePanePostion == 2) {
                insets = new Insets(insets.right, insets.top, insets.left, insets.bottom);
            } else if (this.titlePanePostion == 4) {
                insets = new Insets(insets.left, insets.bottom, insets.right, insets.top);
            }
            ((WebLabel)this.titleComponent).setMargin(insets);
        }
    }

    private void updateHeaderPosition() {
        this.updateHeaderSides();
        if (this.titlePanePostion == 1) {
            this.add((Component)this.headerPanel, (Object)"North");
        } else if (this.titlePanePostion == 3) {
            this.add((Component)this.headerPanel, (Object)"South");
        } else if (this.titlePanePostion == 2) {
            this.add((Component)this.headerPanel, (Object)"Before");
        } else if (this.titlePanePostion == 4) {
            this.add((Component)this.headerPanel, (Object)"After");
        }
        this.revalidate();
    }

    private void updateHeaderSides() {
        this.headerPanel.setDrawSides(this.expanded && this.titlePanePostion == 3, this.expanded && this.titlePanePostion == 4, this.expanded && this.titlePanePostion == 1, this.expanded && this.titlePanePostion == 2);
    }

    private void updateStateIconPosition() {
        if (this.showStateIcon) {
            if (this.titlePanePostion == 1 || this.titlePanePostion == 3) {
                this.headerPanel.add((Component)this.expandButton, (Object)(this.stateIconPostion == 4 ? "After" : "Before"));
            } else if (this.titlePanePostion == 2) {
                this.headerPanel.add((Component)this.expandButton, (Object)(this.stateIconPostion == 4 ? "First" : "Last"));
            } else if (this.titlePanePostion == 4) {
                this.headerPanel.add((Component)this.expandButton, (Object)(this.stateIconPostion == 4 ? "Last" : "First"));
            }
        } else {
            this.headerPanel.remove(this.expandButton);
        }
        this.headerPanel.revalidate();
    }

    private void updateStateIconMargin() {
        this.expandButton.setMargin(this.stateIconMargin);
    }

    private JComponent createDefaultTitleComponent(Icon icon, String string) {
        WebLabel webLabel = this.titlePanePostion == 2 ? new WebVerticalLabel(string, icon, 10, false) : (this.titlePanePostion == 4 ? new WebVerticalLabel(string, icon, 10, true) : new WebLabel(string, icon, 10));
        webLabel.setDrawShade(true);
        return webLabel;
    }

    public DataProvider<Boolean> getStateChangeHandler() {
        return this.stateChangeHandler;
    }

    public void setStateChangeHandler(DataProvider<Boolean> dataProvider) {
        this.stateChangeHandler = dataProvider;
    }

    public boolean isStateChangeEnabled() {
        return this.stateChangeHandler == null || this.stateChangeHandler.provide() != false;
    }

    public boolean isAnimating() {
        return this.animator != null && this.animator.isRunning();
    }

    public boolean invertExpandState() {
        return this.invertExpandState(this.animate);
    }

    public boolean invertExpandState(boolean bl) {
        return this.setExpanded(!this.isExpanded(), bl);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean setExpanded(boolean bl) {
        return this.setExpanded(bl, this.isShowing() && this.animate);
    }

    public boolean setExpanded(boolean bl, boolean bl2) {
        if (this.isEnabled()) {
            if (bl) {
                return this.expand(bl2);
            }
            return this.collapse(bl2);
        }
        return false;
    }

    public boolean collapse() {
        return this.collapse(this.animate);
    }

    public boolean collapse(boolean bl) {
        if (!this.expanded || !this.isStateChangeEnabled()) {
            return false;
        }
        this.stopAnimation();
        this.expanded = false;
        this.setStateIcons();
        this.fireCollapsing();
        if (bl && this.isShowing()) {
            this.animator = new Timer("WebCollapsiblePane.collapseTimer", (long)StyleConstants.fastAnimationDelay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (WebCollapsiblePane.this.transitionProgress > 0.0f) {
                        WebCollapsiblePane.this.transitionProgress = Math.max(0.0f, WebCollapsiblePane.this.transitionProgress - WebCollapsiblePane.this.expandSpeed);
                        WebCollapsiblePane.this.revalidate();
                    } else {
                        WebCollapsiblePane.this.transitionProgress = 0.0f;
                        WebCollapsiblePane.this.finishCollapseAction();
                        WebCollapsiblePane.this.animator.stop();
                    }
                }
            });
            this.animator.start();
        } else {
            this.transitionProgress = 0.0f;
            this.finishCollapseAction();
        }
        return true;
    }

    private void finishCollapseAction() {
        this.updateHeaderSides();
        if (this.content != null) {
            this.content.setVisible(false);
        }
        this.revalidate();
        this.repaint();
        this.fireCollapsed();
    }

    public boolean expand() {
        return this.expand(this.animate);
    }

    public boolean expand(boolean bl) {
        if (this.expanded || !this.isStateChangeEnabled()) {
            return false;
        }
        this.stopAnimation();
        this.expanded = true;
        this.setStateIcons();
        if (this.content != null) {
            this.content.setVisible(true);
        }
        this.updateHeaderSides();
        this.fireExpanding();
        if (bl && this.isShowing()) {
            this.animator = new Timer("WebCollapsiblePane.expandTimer", (long)StyleConstants.fastAnimationDelay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (WebCollapsiblePane.this.transitionProgress < 1.0f) {
                        WebCollapsiblePane.this.transitionProgress = Math.min(1.0f, WebCollapsiblePane.this.transitionProgress + WebCollapsiblePane.this.expandSpeed);
                        WebCollapsiblePane.this.revalidate();
                    } else {
                        WebCollapsiblePane.this.transitionProgress = 1.0f;
                        WebCollapsiblePane.this.finishExpandAction();
                        WebCollapsiblePane.this.animator.stop();
                    }
                }
            });
            this.animator.start();
        } else {
            this.transitionProgress = 1.0f;
            this.finishExpandAction();
        }
        return true;
    }

    private void finishExpandAction() {
        this.revalidate();
        this.repaint();
        this.fireExpanded();
    }

    private void stopAnimation() {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.stop();
        }
    }

    public int getTitlePanePostion() {
        return this.titlePanePostion;
    }

    public void setTitlePanePostion(int n) {
        this.titlePanePostion = n;
        this.updateDefaultTitleComponent();
        this.updateDefaultTitleBorder();
        this.updateHeaderPosition();
        this.updateStateIcons();
        this.updateStateIconPosition();
    }

    public Insets getContentMargin() {
        return this.contentMargin;
    }

    public void setContentMargin(Insets insets) {
        this.contentMargin = insets;
        this.contentPanel.setMargin(insets);
        this.revalidate();
    }

    public void setContentMargin(int n, int n2, int n3, int n4) {
        this.setContentMargin(new Insets(n, n2, n3, n4));
    }

    public void setContentMargin(int n) {
        this.setContentMargin(n, n, n, n);
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean bl) {
        this.animate = bl;
    }

    public Icon getIcon() {
        return this.customTitle ? null : ((WebLabel)this.titleComponent).getIcon();
    }

    public void setIcon(Icon icon) {
        if (!this.customTitle) {
            ((WebLabel)this.titleComponent).setIcon(icon);
            this.updateDefaultTitleBorder();
        }
    }

    public String getTitle() {
        return this.customTitle ? null : ((WebLabel)this.titleComponent).getText();
    }

    public void setTitle(String string) {
        if (!this.customTitle) {
            ((WebLabel)this.titleComponent).setText(string);
        }
    }

    public ImageIcon getCollapseIcon() {
        return this.collapseIcon;
    }

    public void setCollapseIcon(ImageIcon imageIcon) {
        this.collapseIcon = imageIcon;
        this.clearCachedCollapseIcons();
        this.setStateIcons();
    }

    public ImageIcon getExpandIcon() {
        return this.expandIcon;
    }

    public void setExpandIcon(ImageIcon imageIcon) {
        this.expandIcon = imageIcon;
        this.clearCachedExpandIcons();
        this.setStateIcons();
    }

    public Insets getStateIconMargin() {
        return this.stateIconMargin;
    }

    public void setStateIconMargin(Insets insets) {
        this.stateIconMargin = insets;
        this.updateStateIconMargin();
    }

    public boolean isRotateStateIcon() {
        return this.rotateStateIcon;
    }

    public void setRotateStateIcon(boolean bl) {
        this.rotateStateIcon = bl;
        this.updateStateIcons();
    }

    public boolean isShowStateIcon() {
        return this.showStateIcon;
    }

    public void setShowStateIcon(boolean bl) {
        this.showStateIcon = bl;
        this.updateStateIconPosition();
    }

    public int getStateIconPostion() {
        return this.stateIconPostion;
    }

    public void setStateIconPostion(int n) {
        this.stateIconPostion = n;
        this.updateStateIconPosition();
    }

    private void updateStateIcons() {
        this.clearCachedCollapseIcons();
        this.clearCachedExpandIcons();
        this.setStateIcons();
    }

    private void setStateIcons() {
        if (this.expanded) {
            this.expandButton.setIcon(this.getCachedCollapseIcon());
            this.expandButton.setDisabledIcon(this.getCachedDisabledCollapseIcon());
        } else {
            this.expandButton.setIcon(this.getCachedExpandIcon());
            this.expandButton.setDisabledIcon(this.getCachedDisabledExpandIcon());
        }
    }

    private void clearCachedCollapseIcons() {
        this.cachedCollapseIcon = null;
        this.cachedDisabledCollapseIcon = null;
    }

    private ImageIcon getCachedCollapseIcon() {
        if (this.cachedCollapseIcon == null) {
            boolean bl = this.getComponentOrientation().isLeftToRight();
            if (!this.rotateStateIcon || this.titlePanePostion == 1 || this.titlePanePostion == 3) {
                this.cachedCollapseIcon = new OrientedIcon(this.collapseIcon);
            } else if (this.titlePanePostion == 2) {
                this.cachedCollapseIcon = ImageUtils.rotateImage90CCW(this.collapseIcon);
            } else if (this.titlePanePostion == 4) {
                this.cachedCollapseIcon = ImageUtils.rotateImage90CW(this.collapseIcon);
            }
        }
        return this.cachedCollapseIcon;
    }

    private ImageIcon getCachedDisabledCollapseIcon() {
        if (this.cachedDisabledCollapseIcon == null) {
            this.cachedDisabledCollapseIcon = ImageUtils.createDisabledCopy(this.getCachedCollapseIcon());
        }
        return this.cachedDisabledCollapseIcon;
    }

    private void clearCachedExpandIcons() {
        this.cachedExpandIcon = null;
        this.cachedDisabledExpandIcon = null;
    }

    private ImageIcon getCachedExpandIcon() {
        if (this.cachedExpandIcon == null) {
            boolean bl = this.getComponentOrientation().isLeftToRight();
            if (!this.rotateStateIcon || this.titlePanePostion == 1 || this.titlePanePostion == 3) {
                this.cachedExpandIcon = this.expandIcon;
            } else if (bl ? this.titlePanePostion == 2 : this.titlePanePostion == 4) {
                this.cachedExpandIcon = ImageUtils.rotateImage90CCW(this.expandIcon);
            } else if (bl ? this.titlePanePostion == 4 : this.titlePanePostion == 2) {
                this.cachedExpandIcon = ImageUtils.rotateImage90CW(this.expandIcon);
            }
        }
        return this.cachedExpandIcon;
    }

    private ImageIcon getCachedDisabledExpandIcon() {
        if (this.cachedDisabledExpandIcon == null) {
            this.cachedDisabledExpandIcon = ImageUtils.createDisabledCopy(this.getCachedExpandIcon());
        }
        return this.cachedDisabledExpandIcon;
    }

    public WebPanel getHeaderPanel() {
        return this.headerPanel;
    }

    public WebButton getExpandButton() {
        return this.expandButton;
    }

    public Component getTitleComponent() {
        return this.titleComponent;
    }

    public void setTitleComponent(Component component) {
        if (this.titleComponent != null) {
            this.headerPanel.remove(this.titleComponent);
        }
        if (component != null) {
            this.headerPanel.add(component, (Object)"Center");
        }
        this.titleComponent = component;
        this.customTitle = true;
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component component) {
        if (this.content != null) {
            this.contentPanel.remove(component);
        }
        this.content = component;
        component.setVisible(this.transitionProgress > 0.0f);
        this.contentPanel.add(component, (Object)"Center");
        this.revalidate();
    }

    public List<CollapsiblePaneListener> getListeners() {
        return CollectionUtils.copy(this.listeners);
    }

    public void setListeners(List<CollapsiblePaneListener> list) {
        this.listeners = list;
    }

    public void addCollapsiblePaneListener(CollapsiblePaneListener collapsiblePaneListener) {
        this.listeners.add(collapsiblePaneListener);
    }

    public void removeCollapsiblePaneListener(CollapsiblePaneListener collapsiblePaneListener) {
        this.listeners.remove(collapsiblePaneListener);
    }

    private void fireExpanding() {
        for (CollapsiblePaneListener collapsiblePaneListener : CollectionUtils.copy(this.listeners)) {
            collapsiblePaneListener.expanding(this);
        }
    }

    private void fireExpanded() {
        for (CollapsiblePaneListener collapsiblePaneListener : CollectionUtils.copy(this.listeners)) {
            collapsiblePaneListener.expanded(this);
        }
    }

    private void fireCollapsing() {
        for (CollapsiblePaneListener collapsiblePaneListener : CollectionUtils.copy(this.listeners)) {
            collapsiblePaneListener.collapsing(this);
        }
    }

    private void fireCollapsed() {
        for (CollapsiblePaneListener collapsiblePaneListener : CollectionUtils.copy(this.listeners)) {
            collapsiblePaneListener.collapsed(this);
        }
    }

    public float getTransitionProgress() {
        return this.transitionProgress;
    }

    public Dimension getBasePreferredSize() {
        Dimension dimension = this.getPreferredSize();
        if (this.content == null || this.transitionProgress <= 0.0f) {
            return dimension;
        }
        Dimension dimension2 = this.content.getPreferredSize();
        if (this.titlePanePostion == 1 || this.titlePanePostion == 3) {
            return new Dimension(dimension.width, dimension.height - Math.round((float)dimension2.height * this.transitionProgress));
        }
        return new Dimension(dimension.width - Math.round((float)dimension2.width * this.transitionProgress), dimension.height);
    }

    @Override
    public void setFocusable(boolean bl) {
        this.expandButton.setFocusable(bl);
    }

    @Override
    public boolean isFocusable() {
        return this.expandButton.isFocusable();
    }
}

