/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.panel;

import com.alee.extended.layout.OverlayData;
import com.alee.extended.layout.OverlayLayout;
import com.alee.laf.panel.WebPanel;
import com.alee.utils.swing.DataProvider;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingConstants;

public class WebOverlay
extends WebPanel
implements SwingConstants {
    private Component component;
    private Map<Component, OverlayData> overlayData;

    public WebOverlay() {
        super(new OverlayLayout());
        this.initialize();
    }

    public WebOverlay(Component component) {
        super(new OverlayLayout());
        this.initialize();
        this.setComponent(component);
    }

    public WebOverlay(Component component, Component component2) {
        super(new OverlayLayout());
        this.initialize();
        this.setComponent(component);
        this.addOverlay(component2);
    }

    public WebOverlay(Component component, Component component2, int n, int n2) {
        super(new OverlayLayout());
        this.initialize();
        this.setComponent(component);
        this.addOverlay(component2, n, n2);
    }

    public WebOverlay(Component component, Component component2, DataProvider<Rectangle> dataProvider) {
        super(new OverlayLayout());
        this.initialize();
        this.setComponent(component);
        this.addOverlay(component2, dataProvider);
    }

    private void initialize() {
        this.component = null;
        this.overlayData = new HashMap<Component, OverlayData>();
    }

    public Insets getComponentMargin() {
        return this.getActualLayout().getComponentMargin();
    }

    public void setComponentMargin(int n) {
        this.getActualLayout().setComponentMargin(n);
    }

    public void setComponentMargin(int n, int n2, int n3, int n4) {
        this.getActualLayout().setComponentMargin(n, n2, n3, n4);
    }

    public void setComponentMargin(Insets insets) {
        this.getActualLayout().setComponentMargin(insets);
    }

    public Insets getOverlayMargin() {
        return this.getActualLayout().getOverlayMargin();
    }

    public void setOverlayMargin(int n) {
        this.getActualLayout().setOverlayMargin(n);
    }

    public void setOverlayMargin(int n, int n2, int n3, int n4) {
        this.getActualLayout().setOverlayMargin(n, n2, n3, n4);
    }

    public void setOverlayMargin(Insets insets) {
        this.getActualLayout().setOverlayMargin(insets);
    }

    public OverlayLayout getActualLayout() {
        return (OverlayLayout)super.getLayout();
    }

    public void setComponent(Component component) {
        if (this.component != null) {
            this.remove(this.component);
        }
        this.component = component;
        this.add(component, (Object)"COMPONENT");
    }

    public Component getComponent() {
        return this.component;
    }

    public void addOverlay(Component component) {
        this.overlayData.put(component, new OverlayData());
        this.add(component, "OVERLAY", 0);
    }

    public void addOverlay(Component component, int n, int n2) {
        this.overlayData.put(component, new OverlayData(n, n2));
        this.add(component, "OVERLAY", 0);
    }

    public void addOverlay(Component component, DataProvider<Rectangle> dataProvider) {
        this.overlayData.put(component, new OverlayData(dataProvider));
        this.add(component, "OVERLAY", 0);
    }

    public void removeOverlay(Component component) {
        this.overlayData.remove(component);
        this.remove(component);
    }

    public OverlayData getOverlayData(Component component) {
        return this.overlayData.get(component);
    }
}

