/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.drag.FileDropHandler;
import com.alee.extended.tree.AsyncTreeAdapter;
import com.alee.extended.tree.AsyncTreeModel;
import com.alee.extended.tree.FileTreeDataProvider;
import com.alee.extended.tree.FileTreeNode;
import com.alee.extended.tree.FileTreeRootType;
import com.alee.extended.tree.WebAsyncTree;
import com.alee.extended.tree.WebFileTreeCellRenderer;
import com.alee.extended.tree.WebFileTreeStyle;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class WebFileTree
extends WebAsyncTree<FileTreeNode> {
    private boolean autoExpandSelectedNode = WebFileTreeStyle.autoExpandSelectedPath;
    private boolean filesDropSearchEnabled = WebFileTreeStyle.filesDropSearchEnabled;
    private FileDropHandler fileLookupDropHandler = null;

    public WebFileTree() {
        this(FileTreeRootType.drives);
    }

    public WebFileTree(FileTreeRootType fileTreeRootType) {
        this(fileTreeRootType.getRoots());
    }

    public WebFileTree(String string) {
        this(new File(string));
    }

    public WebFileTree(File ... fileArray) {
        this(CollectionUtils.copy(fileArray));
    }

    public WebFileTree(List<File> list) {
        super(new FileTreeDataProvider(list));
        this.setRootVisible(false);
        this.setCellRenderer(new WebFileTreeCellRenderer());
        this.setFilesDropSearchEnabled(WebFileTreeStyle.filesDropSearchEnabled);
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (WebFileTree.this.autoExpandSelectedNode && WebFileTree.this.getSelectionCount() > 0) {
                    WebFileTree.this.expandPath(WebFileTree.this.getSelectionPath());
                }
            }
        });
    }

    public FileTreeDataProvider getDataProvider() {
        return (FileTreeDataProvider)super.getDataProvider();
    }

    private FileDropHandler getFileLookupDropHandler() {
        if (this.fileLookupDropHandler == null) {
            this.fileLookupDropHandler = new FileDropHandler(){

                @Override
                protected boolean isDropEnabled() {
                    return WebFileTree.this.filesDropSearchEnabled;
                }

                @Override
                protected boolean filesImported(List<File> list) {
                    if (list.size() > 0) {
                        WebFileTree.this.setSelectedFile(list.get(0), true);
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.fileLookupDropHandler;
    }

    public boolean isAutoExpandSelectedNode() {
        return this.autoExpandSelectedNode;
    }

    public void setAutoExpandSelectedNode(boolean bl) {
        this.autoExpandSelectedNode = bl;
    }

    public boolean isFilesDropSearchEnabled() {
        return this.filesDropSearchEnabled;
    }

    public void setFilesDropSearchEnabled(boolean bl) {
        this.filesDropSearchEnabled = bl;
        FileDropHandler fileDropHandler = this.getFileLookupDropHandler();
        if (bl) {
            this.setTransferHandler(fileDropHandler);
        } else if (this.getTransferHandler() == fileDropHandler) {
            this.setTransferHandler(null);
        }
    }

    public FileFilter getFileFilter() {
        return this.getDataProvider().getFileFilter();
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.getDataProvider().setFileFilter(fileFilter);
    }

    public void setRootName(String string) {
        ((FileTreeNode)this.getModel().getRoot()).setName(string);
    }

    public void setSelectedFile(File file) {
        this.setSelectedFile(file, false);
    }

    public void setSelectedFile(File file, final boolean bl) {
        this.clearSelection();
        if (file != null) {
            FileFilter fileFilter = this.getFileFilter();
            ArrayList<File> arrayList = new ArrayList<File>();
            File file2 = new File(file.getAbsolutePath());
            arrayList.add(0, file2);
            while (file2.getParent() != null) {
                file2 = file2.getParentFile();
                arrayList.add(0, file2);
            }
            if (fileFilter != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (fileFilter.accept((File)arrayList.get(i))) continue;
                    for (int j = arrayList.size() - 1; j >= i; --j) {
                        arrayList.remove(j);
                    }
                    break;
                }
            }
            AsyncTreeModel asyncTreeModel = this.getAsyncModel();
            Object var7_9 = null;
            final FileTreeNode fileTreeNode = this.getClosestNode(file);
            if (fileTreeNode != null) {
                if (fileTreeNode.getFile().equals(file)) {
                    this.performFileSelection(fileTreeNode, bl);
                } else {
                    int n;
                    final List<File> list = FileUtils.getFilePath(file);
                    for (int i = n = list.indexOf(fileTreeNode.getFile()); i >= 0; --i) {
                        list.remove(i);
                    }
                    this.addAsyncTreeListener(new AsyncTreeAdapter<FileTreeNode>(){
                        private FileTreeNode lastNode;
                        {
                            this.lastNode = fileTreeNode;
                        }

                        @Override
                        public void childsLoadCompleted(FileTreeNode fileTreeNode3, List<FileTreeNode> list2) {
                            if (fileTreeNode3 == this.lastNode) {
                                boolean bl2 = false;
                                for (FileTreeNode fileTreeNode2 : list2) {
                                    if (!fileTreeNode2.getFile().equals(list.get(0))) continue;
                                    bl2 = true;
                                    if (list.size() == 1) {
                                        WebFileTree.this.removeAsyncTreeListener(this);
                                        WebFileTree.this.performFileSelection(fileTreeNode2, bl);
                                        break;
                                    }
                                    this.lastNode = fileTreeNode2;
                                    list.remove(0);
                                    WebFileTree.this.reloadNode(fileTreeNode2);
                                    break;
                                }
                                if (!bl2) {
                                    WebFileTree.this.removeAsyncTreeListener(this);
                                    WebFileTree.this.performFileSelection(fileTreeNode3, false);
                                }
                            }
                        }
                    });
                    this.reloadNode(fileTreeNode);
                }
            }
        }
    }

    private void performFileSelection(FileTreeNode fileTreeNode, boolean bl) {
        try {
            TreePath treePath = new TreePath(fileTreeNode.getPath());
            this.setSelectionPath(treePath);
            this.scrollPathToVisible(treePath);
            if (bl) {
                this.expandPath(treePath);
                Rectangle rectangle = this.getPathBounds(treePath);
                if (rectangle != null) {
                    Rectangle rectangle2 = this.getVisibleRect();
                    Rectangle rectangle3 = new Rectangle(rectangle2.x, rectangle.y, rectangle2.width, rectangle2.height);
                    this.scrollRectToVisible(rectangle3);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public File getSelectedFile() {
        FileTreeNode fileTreeNode = this.getSelectedNode();
        return fileTreeNode != null ? fileTreeNode.getFile() : null;
    }

    private FileTreeNode getSelectedNode() {
        return (FileTreeNode)this.getNodeForPath(this.getSelectionPath());
    }

    public List<File> getSelectedFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (this.getSelectionPaths() != null) {
            for (TreePath treePath : this.getSelectionPaths()) {
                arrayList.add(((FileTreeNode)this.getNodeForPath(treePath)).getFile());
            }
        }
        return arrayList;
    }

    @Override
    public List<FileTreeNode> getSelectedNodes() {
        ArrayList<FileTreeNode> arrayList = new ArrayList<FileTreeNode>();
        if (this.getSelectionPaths() != null) {
            for (TreePath treePath : this.getSelectionPaths()) {
                arrayList.add((FileTreeNode)this.getNodeForPath(treePath));
            }
        }
        return arrayList;
    }

    public boolean addFile(File file, File file2) {
        return this.addFiles(file, file2);
    }

    public boolean addFile(FileTreeNode fileTreeNode, File file) {
        return this.addFiles(fileTreeNode, file);
    }

    public boolean addFiles(File file, File ... fileArray) {
        return this.addFiles(file, CollectionUtils.copy(fileArray));
    }

    public boolean addFiles(FileTreeNode fileTreeNode, File ... fileArray) {
        return this.addFiles(fileTreeNode, CollectionUtils.copy(fileArray));
    }

    public boolean addFiles(File file, List<File> list) {
        FileTreeNode fileTreeNode = this.getNode(file);
        if (fileTreeNode == null) {
            return false;
        }
        return this.addFiles(fileTreeNode, list);
    }

    public boolean addFiles(FileTreeNode fileTreeNode, List<File> list) {
        final List<File> list2 = this.getFileChilds(fileTreeNode);
        list2.addAll(list);
        FileUtils.sortFiles(list2);
        Collections.sort(list, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return new Integer(list2.indexOf(file)).compareTo(list2.indexOf(file2));
            }
        });
        if (this.hasBeenExpanded(this.getPathForNode(fileTreeNode))) {
            AsyncTreeModel asyncTreeModel = this.getAsyncModel();
            for (File file : list) {
                asyncTreeModel.insertNodeInto(new FileTreeNode(file), fileTreeNode, list2.indexOf(file));
            }
            return true;
        }
        return false;
    }

    public boolean removeFile(File file) {
        return this.removeNode(this.getNode(file));
    }

    private boolean removeNode(FileTreeNode fileTreeNode) {
        boolean bl;
        boolean bl2 = bl = fileTreeNode != null;
        if (bl) {
            this.getAsyncModel().removeNodeFromParent(fileTreeNode);
        }
        return bl;
    }

    public boolean removeFiles(File ... fileArray) {
        boolean bl = false;
        for (File file : fileArray) {
            bl |= this.removeFile(file);
        }
        return bl;
    }

    public boolean removeFiles(List<File> list) {
        boolean bl = false;
        for (File file : list) {
            bl |= this.removeFile(file);
        }
        return bl;
    }

    public List<File> getFileChilds(FileTreeNode fileTreeNode) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < fileTreeNode.getChildCount(); ++i) {
            arrayList.add(((FileTreeNode)fileTreeNode.getChildAt(i)).getFile());
        }
        return arrayList;
    }

    public FileTreeNode getNode(File file) {
        FileTreeNode fileTreeNode = this.getClosestNode(file);
        if (FileUtils.equals(file, fileTreeNode.getFile())) {
            return fileTreeNode;
        }
        return null;
    }

    public FileTreeNode getClosestNode(File file) {
        return this.getClosestNode((FileTreeNode)this.getModel().getRoot(), FileUtils.getFilePath(file));
    }

    private FileTreeNode getClosestNode(FileTreeNode fileTreeNode, List<File> list) {
        File file = fileTreeNode.getFile();
        if (file != null && list.contains(file)) {
            int n;
            for (int i = n = list.indexOf(file); i >= 0; --i) {
                list.remove(i);
            }
            return this.getDeepestPathNode(fileTreeNode, list);
        }
        for (int i = 0; i < fileTreeNode.getChildCount(); ++i) {
            FileTreeNode fileTreeNode2 = this.getClosestNode((FileTreeNode)fileTreeNode.getChildAt(i), list);
            if (fileTreeNode2 == null) continue;
            return fileTreeNode2;
        }
        return null;
    }

    private FileTreeNode getDeepestPathNode(FileTreeNode fileTreeNode, List<File> list) {
        if (list.size() > 0) {
            for (int i = 0; i < fileTreeNode.getChildCount(); ++i) {
                FileTreeNode fileTreeNode2 = (FileTreeNode)fileTreeNode.getChildAt(i);
                if (!fileTreeNode2.getFile().equals(list.get(0))) continue;
                list.remove(0);
                return this.getDeepestPathNode(fileTreeNode2, list);
            }
        }
        return fileTreeNode;
    }
}

