/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.slider;

import com.alee.laf.StyleConstants;
import com.alee.laf.slider.WebSliderStyle;
import com.alee.utils.ColorUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.Timer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class WebSliderUI
extends BasicSliderUI {
    public static final int MAX_DARKNESS = 5;
    private Color trackBgTop = WebSliderStyle.trackBgTop;
    private Color trackBgBottom = WebSliderStyle.trackBgBottom;
    private int trackHeight = WebSliderStyle.trackHeight;
    private int trackRound = WebSliderStyle.trackRound;
    private int trackShadeWidth = WebSliderStyle.trackShadeWidth;
    private boolean drawProgress = WebSliderStyle.drawProgress;
    private int progressRound = WebSliderStyle.progressRound;
    private int progressShadeWidth = WebSliderStyle.progressShadeWidth;
    private boolean drawThumb = WebSliderStyle.drawThumb;
    private Color thumbBgTop = WebSliderStyle.thumbBgTop;
    private Color thumbBgBottom = WebSliderStyle.thumbBgBottom;
    private int thumbWidth = WebSliderStyle.thumbWidth;
    private int thumbHeight = WebSliderStyle.thumbHeight;
    private int thumbRound = WebSliderStyle.thumbRound;
    private int thumbShadeWidth = WebSliderStyle.thumbShadeWidth;
    private boolean angledThumb = WebSliderStyle.angledThumb;
    private boolean sharpThumbAngle = WebSliderStyle.sharpThumbAngle;
    private int thumbAngleLength = WebSliderStyle.thumbAngleLength;
    private boolean animated = WebSliderStyle.animated;
    private boolean rolloverDarkBorderOnly = WebSliderStyle.rolloverDarkBorderOnly;
    private MouseWheelListener mouseWheelListener;
    private ChangeListener changeListener;
    private MouseAdapter mouseAdapter;
    private boolean rollover = false;
    private int rolloverDarkness = 0;
    private Timer rolloverTimer;

    public WebSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebSliderUI((JSlider)jComponent);
    }

    @Override
    public void installUI(final JComponent jComponent) {
        super.installUI(jComponent);
        SwingUtils.setOrientation(this.slider);
        this.slider.setOpaque(false);
        this.mouseWheelListener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                WebSliderUI.this.slider.setValue(Math.min(Math.max(WebSliderUI.this.slider.getMinimum(), WebSliderUI.this.slider.getValue() + mouseWheelEvent.getWheelRotation()), WebSliderUI.this.slider.getMaximum()));
            }
        };
        this.slider.addMouseWheelListener(this.mouseWheelListener);
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                WebSliderUI.this.slider.repaint();
            }
        };
        this.slider.addChangeListener(this.changeListener);
        this.rolloverTimer = new Timer("WebProgressBarUI.animator", 40L, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WebSliderUI.this.rollover && WebSliderUI.this.rolloverDarkness < 5) {
                    WebSliderUI.this.rolloverDarkness++;
                    WebSliderUI.this.slider.repaint();
                } else if (!WebSliderUI.this.rollover && WebSliderUI.this.rolloverDarkness > 0) {
                    WebSliderUI.this.rolloverDarkness--;
                    WebSliderUI.this.slider.repaint();
                } else {
                    WebSliderUI.this.rolloverTimer.stop();
                }
            }
        });
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                WebSliderUI.this.slider.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                WebSliderUI.this.slider.repaint();
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                WebSliderUI.this.slider.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                WebSliderUI.this.rollover = true;
                if (WebSliderUI.this.isAnimated() && jComponent.isEnabled()) {
                    WebSliderUI.this.rolloverTimer.start();
                } else {
                    WebSliderUI.this.rolloverDarkness = 5;
                    WebSliderUI.this.slider.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                WebSliderUI.this.rollover = false;
                if (WebSliderUI.this.isAnimated() && jComponent.isEnabled()) {
                    WebSliderUI.this.rolloverTimer.start();
                } else {
                    WebSliderUI.this.rolloverDarkness = 0;
                    WebSliderUI.this.slider.repaint();
                }
            }
        };
        this.slider.addMouseListener(this.mouseAdapter);
        this.slider.addMouseMotionListener(this.mouseAdapter);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.slider.removeMouseWheelListener(this.mouseWheelListener);
        this.slider.removeChangeListener(this.changeListener);
        this.slider.removeMouseListener(this.mouseAdapter);
        this.slider.removeMouseMotionListener(this.mouseAdapter);
        super.uninstallUI(jComponent);
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean bl) {
        this.animated = bl;
    }

    public boolean isRolloverDarkBorderOnly() {
        return this.rolloverDarkBorderOnly;
    }

    public void setRolloverDarkBorderOnly(boolean bl) {
        this.rolloverDarkBorderOnly = bl;
    }

    public Color getTrackBgTop() {
        return this.trackBgTop;
    }

    public void setTrackBgTop(Color color) {
        this.trackBgTop = color;
    }

    public Color getTrackBgBottom() {
        return this.trackBgBottom;
    }

    public void setTrackBgBottom(Color color) {
        this.trackBgBottom = color;
    }

    public int getTrackHeight() {
        return this.trackHeight;
    }

    public void setTrackHeight(int n) {
        this.trackHeight = n;
    }

    public int getTrackRound() {
        return this.trackRound;
    }

    public void setTrackRound(int n) {
        this.trackRound = n;
    }

    public int getTrackShadeWidth() {
        return this.trackShadeWidth;
    }

    public void setTrackShadeWidth(int n) {
        this.trackShadeWidth = n;
    }

    public boolean isDrawProgress() {
        return this.drawProgress;
    }

    public void setDrawProgress(boolean bl) {
        this.drawProgress = bl;
    }

    public int getProgressRound() {
        return this.progressRound;
    }

    public void setProgressRound(int n) {
        this.progressRound = n;
    }

    public int getProgressShadeWidth() {
        return this.progressShadeWidth;
    }

    public void setProgressShadeWidth(int n) {
        this.progressShadeWidth = n;
    }

    public boolean isDrawThumb() {
        return this.drawThumb;
    }

    public void setDrawThumb(boolean bl) {
        this.drawThumb = bl;
    }

    public Color getThumbBgTop() {
        return this.thumbBgTop;
    }

    public void setThumbBgTop(Color color) {
        this.thumbBgTop = color;
    }

    public Color getThumbBgBottom() {
        return this.thumbBgBottom;
    }

    public void setThumbBgBottom(Color color) {
        this.thumbBgBottom = color;
    }

    public int getThumbWidth() {
        return this.thumbWidth;
    }

    public void setThumbWidth(int n) {
        this.thumbWidth = n;
    }

    public int getThumbHeight() {
        return this.thumbHeight;
    }

    public void setThumbHeight(int n) {
        this.thumbHeight = n;
    }

    public int getThumbRound() {
        return this.thumbRound;
    }

    public void setThumbRound(int n) {
        this.thumbRound = n;
    }

    public int getThumbShadeWidth() {
        return this.thumbShadeWidth;
    }

    public void setThumbShadeWidth(int n) {
        this.thumbShadeWidth = n;
    }

    public boolean isAngledThumb() {
        return this.angledThumb;
    }

    public void setAngledThumb(boolean bl) {
        this.angledThumb = bl;
    }

    public boolean isSharpThumbAngle() {
        return this.sharpThumbAngle;
    }

    public void setSharpThumbAngle(boolean bl) {
        this.sharpThumbAngle = bl;
    }

    public int getThumbAngleLength() {
        return this.thumbAngleLength;
    }

    public void setThumbAngleLength(int n) {
        this.thumbAngleLength = n;
    }

    @Override
    protected Dimension getThumbSize() {
        if (this.slider.getOrientation() == 0) {
            return new Dimension(this.thumbWidth, this.thumbHeight);
        }
        return new Dimension(this.thumbHeight, this.thumbWidth);
    }

    @Override
    public void paintFocus(Graphics graphics) {
    }

    @Override
    public void paintThumb(Graphics graphics) {
        if (this.drawThumb) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = LafUtils.setupAntialias(graphics2D);
            Shape shape = this.getThumbShape();
            if (this.slider.isEnabled()) {
                LafUtils.drawShade(graphics2D, shape, StyleConstants.shadeColor, this.thumbShadeWidth);
            }
            if (this.slider.getOrientation() == 0) {
                graphics2D.setPaint(new GradientPaint(0.0f, this.thumbRect.y, this.thumbBgTop, 0.0f, this.thumbRect.y + this.thumbRect.height, this.thumbBgBottom));
            } else {
                graphics2D.setPaint(new GradientPaint(this.thumbRect.x, 0.0f, this.thumbBgTop, this.thumbRect.x + this.thumbRect.width, 0.0f, this.thumbBgBottom));
            }
            graphics2D.fill(shape);
            graphics2D.setPaint(this.slider.isEnabled() ? StyleConstants.darkBorderColor : StyleConstants.disabledBorderColor);
            graphics2D.draw(shape);
            LafUtils.restoreAntialias(graphics2D, object);
        }
    }

    private Color getBorderColor() {
        return ColorUtils.getIntermediateColor(StyleConstants.borderColor, StyleConstants.darkBorderColor, this.getProgress());
    }

    private float getProgress() {
        return (float)this.rolloverDarkness / 5.0f;
    }

    private Shape getThumbShape() {
        if (this.angledThumb && (this.slider.getPaintLabels() || this.slider.getPaintTicks())) {
            if (this.slider.getOrientation() == 0) {
                GeneralPath generalPath = new GeneralPath(0);
                generalPath.moveTo(this.thumbRect.x, this.thumbRect.y + this.thumbRound);
                generalPath.quadTo(this.thumbRect.x, this.thumbRect.y, this.thumbRect.x + this.thumbRound, this.thumbRect.y);
                generalPath.lineTo(this.thumbRect.x + this.thumbRect.width - this.thumbRound, this.thumbRect.y);
                generalPath.quadTo(this.thumbRect.x + this.thumbRect.width, this.thumbRect.y, this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRound);
                generalPath.lineTo(this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRect.height - this.thumbAngleLength);
                if (this.sharpThumbAngle) {
                    generalPath.lineTo(this.thumbRect.x + this.thumbRect.width / 2, this.thumbRect.y + this.thumbRect.height);
                    generalPath.lineTo(this.thumbRect.x, this.thumbRect.y + this.thumbRect.height - this.thumbAngleLength);
                } else {
                    generalPath.quadTo(this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRect.height - this.thumbAngleLength / 2, this.thumbRect.x + this.thumbRect.width / 2, this.thumbRect.y + this.thumbRect.height);
                    generalPath.quadTo(this.thumbRect.x, this.thumbRect.y + this.thumbRect.height - this.thumbAngleLength / 2, this.thumbRect.x, this.thumbRect.y + this.thumbRect.height - this.thumbAngleLength);
                }
                generalPath.closePath();
                return generalPath;
            }
            GeneralPath generalPath = new GeneralPath(0);
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                generalPath.moveTo(this.thumbRect.x, this.thumbRect.y + this.thumbRound);
                generalPath.quadTo(this.thumbRect.x, this.thumbRect.y, this.thumbRect.x + this.thumbRound, this.thumbRect.y);
                generalPath.lineTo(this.thumbRect.x + this.thumbRect.width - this.thumbAngleLength, this.thumbRect.y);
                if (this.sharpThumbAngle) {
                    generalPath.lineTo(this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRect.height / 2);
                    generalPath.lineTo(this.thumbRect.x + this.thumbRect.width - this.thumbAngleLength, this.thumbRect.y + this.thumbRect.height);
                } else {
                    generalPath.quadTo(this.thumbRect.x + this.thumbRect.width - this.thumbAngleLength / 2, this.thumbRect.y, this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRect.height / 2);
                    generalPath.quadTo(this.thumbRect.x + this.thumbRect.width - this.thumbAngleLength / 2, this.thumbRect.y + this.thumbRect.height, this.thumbRect.x + this.thumbRect.width - this.thumbAngleLength, this.thumbRect.y + this.thumbRect.height);
                }
                generalPath.lineTo(this.thumbRect.x + this.thumbRound, this.thumbRect.y + this.thumbRect.height);
                generalPath.quadTo(this.thumbRect.x, this.thumbRect.y + this.thumbRect.height, this.thumbRect.x, this.thumbRect.y + this.thumbRect.height - this.thumbRound);
            } else {
                generalPath.moveTo(this.thumbRect.x + this.thumbRect.width - this.thumbRound, this.thumbRect.y);
                generalPath.quadTo(this.thumbRect.x + this.thumbRect.width, this.thumbRect.y, this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRound);
                generalPath.lineTo(this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRect.height - this.thumbRound);
                generalPath.quadTo(this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRect.height, this.thumbRect.x + this.thumbRect.width - this.thumbRound, this.thumbRect.y + this.thumbRect.height);
                generalPath.lineTo(this.thumbRect.x + this.thumbAngleLength, this.thumbRect.y + this.thumbRect.height);
                if (this.sharpThumbAngle) {
                    generalPath.lineTo(this.thumbRect.x, this.thumbRect.y + this.thumbRect.height / 2);
                    generalPath.lineTo(this.thumbRect.x + this.thumbAngleLength, this.thumbRect.y);
                } else {
                    generalPath.quadTo(this.thumbRect.x + this.thumbAngleLength / 2, this.thumbRect.y + this.thumbRect.height, this.thumbRect.x, this.thumbRect.y + this.thumbRect.height / 2);
                    generalPath.quadTo(this.thumbRect.x + this.thumbAngleLength / 2, this.thumbRect.y, this.thumbRect.x + this.thumbAngleLength, this.thumbRect.y);
                }
            }
            generalPath.closePath();
            return generalPath;
        }
        return new RoundRectangle2D.Double(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height, this.thumbRound * 2, this.thumbRound * 2);
    }

    @Override
    public void paintTrack(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = LafUtils.setupAntialias(graphics2D);
        Shape shape = this.getTrackShape();
        if (this.slider.isEnabled()) {
            LafUtils.drawShade(graphics2D, shape, this.slider.isFocusOwner() ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor, this.trackShadeWidth);
        }
        if (this.slider.getOrientation() == 0) {
            graphics2D.setPaint(new GradientPaint(0.0f, this.trackRect.y, this.trackBgTop, 0.0f, this.trackRect.y + this.trackRect.height, this.trackBgBottom));
        } else {
            graphics2D.setPaint(new GradientPaint(this.trackRect.x, 0.0f, this.trackBgTop, this.trackRect.x + this.trackRect.width, 0.0f, this.trackBgBottom));
        }
        graphics2D.fill(shape);
        if (this.drawProgress) {
            Shape shape2 = this.getProgressShape();
            if (this.slider.isEnabled()) {
                LafUtils.drawShade(graphics2D, shape2, StyleConstants.shadeColor, this.progressShadeWidth);
            }
            Rectangle rectangle = shape.getBounds();
            if (this.slider.getOrientation() == 0) {
                graphics2D.setPaint(new GradientPaint(0.0f, rectangle.y + this.progressShadeWidth, Color.WHITE, 0.0f, rectangle.y + rectangle.height - this.progressShadeWidth, new Color(223, 223, 223)));
            } else {
                graphics2D.setPaint(new GradientPaint(rectangle.x + this.progressShadeWidth, 0.0f, Color.WHITE, rectangle.x + rectangle.width - this.progressShadeWidth, 0.0f, new Color(223, 223, 223)));
            }
            graphics2D.fill(shape2);
            graphics2D.setPaint(this.slider.isEnabled() ? StyleConstants.darkBorderColor : StyleConstants.disabledBorderColor);
            graphics2D.draw(shape2);
        }
        graphics2D.setPaint(this.slider.isEnabled() ? (this.rolloverDarkBorderOnly && !this.isDragging() ? this.getBorderColor() : StyleConstants.darkBorderColor) : StyleConstants.disabledBorderColor);
        graphics2D.draw(shape);
        LafUtils.restoreAntialias(graphics2D, object);
    }

    private Shape getTrackShape() {
        if (this.trackRound > 0) {
            if (this.slider.getOrientation() == 0) {
                return new RoundRectangle2D.Double(this.trackRect.x - this.trackRound, this.trackRect.y + this.trackRect.height / 2 - this.trackHeight / 2, this.trackRect.width + this.trackRound * 2 - 1, this.trackHeight, this.trackRound * 2, this.trackRound * 2);
            }
            return new RoundRectangle2D.Double(this.trackRect.x + this.trackRect.width / 2 - this.trackHeight / 2, this.trackRect.y - this.trackRound, this.trackHeight, this.trackRect.height + this.trackRound * 2 - 1, this.trackRound * 2, this.trackRound * 2);
        }
        if (this.slider.getOrientation() == 0) {
            return new Rectangle2D.Double(this.trackRect.x, this.trackRect.y + this.trackRect.height / 2 - this.trackHeight / 2, this.trackRect.width - 1, this.trackHeight);
        }
        return new Rectangle2D.Double(this.trackRect.x + this.trackRect.width / 2 - this.trackHeight / 2, this.trackRect.y, this.trackHeight, this.trackRect.height - 1);
    }

    private Shape getProgressShape() {
        if (this.trackRound > 0) {
            if (this.slider.getOrientation() == 0) {
                int n;
                int n2;
                if (this.slider.getComponentOrientation().isLeftToRight()) {
                    n2 = this.trackRect.x - this.trackRound + this.progressShadeWidth;
                    n = this.thumbRect.x + this.thumbRect.width / 2 + this.progressRound - n2;
                } else {
                    n2 = this.thumbRect.x + this.thumbRect.width / 2 - this.progressRound;
                    n = this.trackRect.x + this.trackRect.width + this.trackRound - this.progressShadeWidth - 1 - n2;
                }
                return new RoundRectangle2D.Double(n2, this.trackRect.y + this.trackRect.height / 2 - this.trackHeight / 2 + this.progressShadeWidth, n, this.trackHeight - this.progressShadeWidth * 2, this.progressRound * 2, this.progressRound * 2);
            }
            int n = this.thumbRect.y + this.thumbRect.height / 2;
            int n3 = this.trackRect.y + this.trackRect.height + this.trackRound - this.progressShadeWidth - n - 1;
            return new RoundRectangle2D.Double(this.trackRect.x + this.progressShadeWidth + this.trackRect.width / 2 - this.trackHeight / 2, n, this.trackHeight - this.progressShadeWidth * 2, n3, this.progressRound * 2, this.progressRound * 2);
        }
        if (this.slider.getOrientation() == 0) {
            int n;
            int n4;
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                n4 = this.trackRect.x + this.progressShadeWidth;
                n = this.thumbRect.x + this.thumbRect.width / 2 - n4;
            } else {
                n4 = this.thumbRect.x + this.thumbRect.width / 2;
                n = this.trackRect.x + this.trackRect.width - this.progressShadeWidth - 1 - n4;
            }
            return new Rectangle2D.Double(n4, this.trackRect.y + this.trackRect.height / 2 - this.trackHeight / 2 + this.progressShadeWidth, n, this.trackHeight - this.progressShadeWidth * 2);
        }
        int n = this.trackRect.y + this.progressShadeWidth;
        int n5 = this.thumbRect.y + this.thumbRect.height / 2 - n;
        return new Rectangle2D.Double(this.trackRect.x + this.progressShadeWidth + this.trackRect.width / 2 - this.trackHeight / 2, n, this.trackHeight - this.progressShadeWidth * 2, n5);
    }
}

