/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.laf.tree.TreeState;
import com.alee.laf.tree.UniqueNode;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class TreeUtils {
    public static TreeState getTreeState(JTree jTree) {
        TreeState treeState = new TreeState();
        ArrayList<UniqueNode> arrayList = new ArrayList<UniqueNode>();
        arrayList.add((UniqueNode)jTree.getModel().getRoot());
        while (arrayList.size() > 0) {
            UniqueNode uniqueNode = (UniqueNode)arrayList.get(0);
            TreePath treePath = new TreePath(uniqueNode.getPath());
            treeState.addExpandState(uniqueNode.getId(), jTree.isExpanded(treePath));
            treeState.addSelectState(uniqueNode.getId(), jTree.isPathSelected(treePath));
            for (int i = 0; i < uniqueNode.getChildCount(); ++i) {
                arrayList.add((UniqueNode)uniqueNode.getChildAt(i));
            }
            arrayList.remove(uniqueNode);
        }
        return treeState;
    }

    public static void setTreeState(JTree jTree, TreeState treeState) {
        jTree.clearSelection();
        ArrayList<UniqueNode> arrayList = new ArrayList<UniqueNode>();
        arrayList.add((UniqueNode)jTree.getModel().getRoot());
        while (arrayList.size() > 0) {
            UniqueNode uniqueNode = (UniqueNode)arrayList.get(0);
            TreePath treePath = new TreePath(uniqueNode.getPath());
            if (treeState.getExpandStates().containsKey(uniqueNode.getId()) && treeState.getExpandStates().get(uniqueNode.getId()).booleanValue()) {
                jTree.expandPath(treePath);
                for (int i = 0; i < uniqueNode.getChildCount(); ++i) {
                    arrayList.add((UniqueNode)jTree.getModel().getChild(uniqueNode, i));
                }
            } else {
                jTree.collapsePath(treePath);
            }
            if (treeState.getSelectionStates().containsKey(uniqueNode.getId()) && treeState.getSelectionStates().get(uniqueNode.getId()).booleanValue()) {
                jTree.addSelectionPath(treePath);
            } else {
                jTree.removeSelectionPath(treePath);
            }
            arrayList.remove(uniqueNode);
        }
    }
}

