/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.hotkey;

import com.alee.laf.label.WebLabel;
import com.alee.managers.hotkey.ButtonHotkeyRunnable;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyCondition;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.hotkey.HotkeyInfo;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.tooltip.TooltipWay;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.XmlUtils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;

public class HotkeyManager {
    private static final Object sync = new Object();
    private static boolean hotkeysEnabled = true;
    private static boolean transferFocus = false;
    private static Map<Component, List<HotkeyInfo>> hotkeys = new WeakHashMap<Component, List<HotkeyInfo>>();
    private static Map<Container, List<HotkeyCondition>> topComponentConditions = new WeakHashMap<Container, List<HotkeyCondition>>();
    private static boolean initialized = false;

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            XmlUtils.processAnnotations(HotkeyData.class);
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent aWTEvent) {
                    if (hotkeysEnabled && aWTEvent instanceof KeyEvent) {
                        KeyEvent keyEvent = (KeyEvent)aWTEvent;
                        if (keyEvent.isConsumed() || keyEvent.getID() != 401) {
                            return;
                        }
                        if (!HotkeyManager.hotkeyForEventExists(keyEvent)) {
                            return;
                        }
                        HotkeyManager.processHotkeys(keyEvent);
                    }
                }
            }, 8L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hotkeyForEventExists(KeyEvent keyEvent) {
        Object object = sync;
        synchronized (object) {
            int n = SwingUtils.hotkeyToString(keyEvent).hashCode();
            for (Map.Entry<Component, List<HotkeyInfo>> entry : hotkeys.entrySet()) {
                for (HotkeyInfo hotkeyInfo : entry.getValue()) {
                    if (hotkeyInfo.getHotkeyData().hashCode() != n) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processHotkeys(KeyEvent keyEvent) {
        Object object = sync;
        synchronized (object) {
            for (Map.Entry<Component, List<HotkeyInfo>> entry : hotkeys.entrySet()) {
                for (HotkeyInfo hotkeyInfo : entry.getValue()) {
                    Component component = hotkeyInfo.getTopComponent();
                    Component component2 = hotkeyInfo.getForComponent();
                    if (component2 == null) {
                        if (!hotkeyInfo.getHotkeyData().isTriggered(keyEvent) || hotkeyInfo.getAction() == null) continue;
                        SwingUtils.invokeLater(hotkeyInfo.getAction(), keyEvent);
                        continue;
                    }
                    if (!SwingUtils.hasFocusOwner(component = component != null ? component : SwingUtils.getWindowAncestor(component2)) || !hotkeyInfo.getHotkeyData().isTriggered(keyEvent) || hotkeyInfo.getAction() == null || !HotkeyManager.meetsParentConditions(component2)) continue;
                    if (transferFocus) {
                        component2.requestFocusInWindow();
                    }
                    SwingUtils.invokeLater(hotkeyInfo.getAction(), keyEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean meetsParentConditions(Component component) {
        Object object = sync;
        synchronized (object) {
            for (Map.Entry<Container, List<HotkeyCondition>> entry : topComponentConditions.entrySet()) {
                if (!entry.getKey().isAncestorOf(component)) continue;
                for (HotkeyCondition hotkeyCondition : entry.getValue()) {
                    if (hotkeyCondition.checkCondition(component)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static HotkeyInfo registerHotkey(HotkeyData hotkeyData, HotkeyRunnable hotkeyRunnable) {
        HotkeyInfo hotkeyInfo = new HotkeyInfo();
        hotkeyInfo.setHidden(true);
        hotkeyInfo.setHotkeyData(hotkeyData);
        hotkeyInfo.setAction(hotkeyRunnable);
        HotkeyManager.cacheHotkey(hotkeyInfo);
        return hotkeyInfo;
    }

    public static HotkeyInfo registerHotkey(Component component, HotkeyData hotkeyData, HotkeyRunnable hotkeyRunnable) {
        return HotkeyManager.registerHotkey(null, component, hotkeyData, hotkeyRunnable);
    }

    public static HotkeyInfo registerHotkey(Component component, HotkeyData hotkeyData, HotkeyRunnable hotkeyRunnable, boolean bl) {
        return HotkeyManager.registerHotkey(null, component, hotkeyData, hotkeyRunnable, bl);
    }

    public static HotkeyInfo registerHotkey(Component component, Component component2, HotkeyData hotkeyData, HotkeyRunnable hotkeyRunnable) {
        return HotkeyManager.registerHotkey(component, component2, hotkeyData, hotkeyRunnable, false);
    }

    public static HotkeyInfo registerHotkey(Component component, Component component2, HotkeyData hotkeyData, HotkeyRunnable hotkeyRunnable, TooltipWay tooltipWay) {
        return HotkeyManager.registerHotkey(component, component2, hotkeyData, hotkeyRunnable, false, tooltipWay);
    }

    public static HotkeyInfo registerHotkey(Component component, Component component2, HotkeyData hotkeyData, HotkeyRunnable hotkeyRunnable, boolean bl) {
        return HotkeyManager.registerHotkey(component, component2, hotkeyData, hotkeyRunnable, bl, null);
    }

    public static HotkeyInfo registerHotkey(Component component, Component component2, HotkeyData hotkeyData, HotkeyRunnable hotkeyRunnable, boolean bl, TooltipWay tooltipWay) {
        HotkeyInfo hotkeyInfo = new HotkeyInfo();
        hotkeyInfo.setHidden(bl);
        hotkeyInfo.setTopComponent(component);
        hotkeyInfo.setForComponent(component2);
        hotkeyInfo.setHotkeyData(hotkeyData);
        hotkeyInfo.setHotkeyDisplayWay(tooltipWay);
        hotkeyInfo.setAction(hotkeyRunnable);
        HotkeyManager.cacheHotkey(hotkeyInfo);
        return hotkeyInfo;
    }

    public static HotkeyInfo registerHotkey(AbstractButton abstractButton, HotkeyData hotkeyData) {
        return HotkeyManager.registerHotkey(null, abstractButton, hotkeyData);
    }

    public static HotkeyInfo registerHotkey(AbstractButton abstractButton, HotkeyData hotkeyData, boolean bl) {
        return HotkeyManager.registerHotkey(null, abstractButton, hotkeyData, bl);
    }

    public static HotkeyInfo registerHotkey(AbstractButton abstractButton, HotkeyData hotkeyData, TooltipWay tooltipWay) {
        return HotkeyManager.registerHotkey(null, abstractButton, hotkeyData, tooltipWay);
    }

    public static HotkeyInfo registerHotkey(Component component, AbstractButton abstractButton, HotkeyData hotkeyData) {
        return HotkeyManager.registerHotkey(component, abstractButton, hotkeyData, false);
    }

    public static HotkeyInfo registerHotkey(Component component, AbstractButton abstractButton, HotkeyData hotkeyData, TooltipWay tooltipWay) {
        return HotkeyManager.registerHotkey(component, abstractButton, hotkeyData, HotkeyManager.createAction(abstractButton), false, tooltipWay);
    }

    public static HotkeyInfo registerHotkey(Component component, AbstractButton abstractButton, HotkeyData hotkeyData, boolean bl) {
        return HotkeyManager.registerHotkey(component, abstractButton, hotkeyData, HotkeyManager.createAction(abstractButton), bl, null);
    }

    private static HotkeyRunnable createAction(AbstractButton abstractButton) {
        return new ButtonHotkeyRunnable(abstractButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setComponentHotkeyDisplayWay(Component component, TooltipWay tooltipWay) {
        Object object = sync;
        synchronized (object) {
            for (HotkeyInfo hotkeyInfo : HotkeyManager.getComponentHotkeysCache(component)) {
                hotkeyInfo.setHotkeyDisplayWay(tooltipWay);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addContainerHotkeyCondition(Container container, HotkeyCondition hotkeyCondition) {
        Object object = sync;
        synchronized (object) {
            List<HotkeyCondition> list = HotkeyManager.getContainerHotkeyConditionsCache(container);
            list.add(hotkeyCondition);
            topComponentConditions.put(container, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeContainerHotkeyCondition(Container container, HotkeyCondition hotkeyCondition) {
        Object object = sync;
        synchronized (object) {
            List<HotkeyCondition> list = HotkeyManager.getContainerHotkeyConditionsCache(container);
            list.remove(hotkeyCondition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeContainerHotkeyConditions(Container container) {
        Object object = sync;
        synchronized (object) {
            topComponentConditions.remove(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HotkeyCondition> getContainerHotkeyConditions(Container container) {
        Object object = sync;
        synchronized (object) {
            List<HotkeyCondition> list = topComponentConditions.get(container);
            return list != null ? CollectionUtils.copy(list) : new ArrayList<HotkeyCondition>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<HotkeyCondition> getContainerHotkeyConditionsCache(Container container) {
        Object object = sync;
        synchronized (object) {
            ArrayList<HotkeyCondition> arrayList = topComponentConditions.get(container);
            return arrayList != null ? arrayList : new ArrayList<HotkeyCondition>();
        }
    }

    public static void unregisterHotkey(HotkeyInfo hotkeyInfo) {
        HotkeyManager.clearHotkeyCache(hotkeyInfo);
    }

    public static void unregisterHotkeys(Component component) {
        HotkeyManager.clearHotkeysCache(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HotkeyInfo> getComponentHotkeys(Component component) {
        Object object = sync;
        synchronized (object) {
            List<HotkeyInfo> list = hotkeys.get(component);
            return list != null ? CollectionUtils.copy(list) : new ArrayList<HotkeyInfo>();
        }
    }

    public static Map<Component, List<HotkeyInfo>> getAllHotkeys() {
        return hotkeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheHotkey(HotkeyInfo hotkeyInfo) {
        Object object = sync;
        synchronized (object) {
            List<HotkeyInfo> list = HotkeyManager.getComponentHotkeysCache(hotkeyInfo.getForComponent());
            list.add(hotkeyInfo);
            hotkeys.put(hotkeyInfo.getForComponent(), list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearHotkeyCache(HotkeyInfo hotkeyInfo) {
        Object object = sync;
        synchronized (object) {
            List<HotkeyInfo> list = HotkeyManager.getComponentHotkeysCache(hotkeyInfo.getForComponent());
            list.remove(hotkeyInfo);
        }
    }

    private static void clearHotkeysCache(List<HotkeyInfo> list) {
        for (HotkeyInfo hotkeyInfo : list) {
            HotkeyManager.clearHotkeyCache(hotkeyInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearHotkeysCache(Component component) {
        Object object = sync;
        synchronized (object) {
            hotkeys.remove(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<HotkeyInfo> getComponentHotkeysCache(Component component) {
        Object object = sync;
        synchronized (object) {
            ArrayList<HotkeyInfo> arrayList = hotkeys.get(component);
            return arrayList != null ? arrayList : new ArrayList<HotkeyInfo>();
        }
    }

    public static void showComponentHotkeys() {
        TooltipManager.hideAllTooltips();
        for (Window window : Window.getWindows()) {
            HotkeyManager.showComponentHotkeys(window);
        }
    }

    public static void showComponentHotkeys(Component component) {
        TooltipManager.hideAllTooltips();
        HotkeyManager.showComponentHotkeys(SwingUtils.getWindowAncestor(component));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showComponentHotkeys(Window window) {
        Object object = sync;
        synchronized (object) {
            LinkedHashSet<Component> linkedHashSet = new LinkedHashSet<Component>();
            for (Map.Entry<Component, List<HotkeyInfo>> entry : hotkeys.entrySet()) {
                for (HotkeyInfo hotkeyInfo : entry.getValue()) {
                    Component component;
                    if (hotkeyInfo.isHidden() || (component = hotkeyInfo.getForComponent()) == null || linkedHashSet.contains(component) || !component.isVisible() || !component.isShowing() || SwingUtils.getWindowAncestor(component) != window) continue;
                    WebLabel webLabel = new WebLabel(HotkeyManager.getComponentHotkeysString(component));
                    SwingUtils.setBoldFont(webLabel);
                    TooltipManager.showOneTimeTooltip(component, null, webLabel, hotkeyInfo.getHotkeyDisplayWay());
                    linkedHashSet.add(component);
                }
            }
        }
    }

    public static void installShowAllHotkeysAction(Component component) {
        HotkeyManager.installShowAllHotkeysAction(component, Hotkey.F1);
    }

    public static void installShowAllHotkeysAction(final Component component, HotkeyData hotkeyData) {
        HotkeyManager.registerHotkey(component, component, hotkeyData, new HotkeyRunnable(){

            @Override
            public void run(KeyEvent keyEvent) {
                HotkeyManager.showComponentHotkeys(component);
            }
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getComponentHotkeysString(Component component) {
        Object object = sync;
        synchronized (object) {
            return HotkeyManager.getComponentHotkeysString(HotkeyManager.getComponentHotkeysCache(component));
        }
    }

    private static String getComponentHotkeysString(List<HotkeyInfo> list) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (list != null) {
            for (HotkeyInfo hotkeyInfo : list) {
                if (hotkeyInfo.isHidden()) continue;
                stringBuilder.append(hotkeyInfo.getHotkeyData().toString());
                if (list.indexOf(hotkeyInfo) >= list.size() - 1) continue;
                stringBuilder.append(", ");
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableHotkeys() {
        Object object = sync;
        synchronized (object) {
            hotkeysEnabled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableHotkeys() {
        Object object = sync;
        synchronized (object) {
            hotkeysEnabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTransferFocus() {
        Object object = sync;
        synchronized (object) {
            return transferFocus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTransferFocus(boolean bl) {
        Object object = sync;
        synchronized (object) {
            transferFocus = bl;
        }
    }
}

