/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class DragUtils {
    private static final String URI_LIST_MIME_TYPE = "text/uri-list;class=java.lang.String";
    private static DataFlavor uriListFlavor = null;

    public static Image getImportedImage(Transferable transferable) {
        if (transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            try {
                Object object = transferable.getTransferData(DataFlavor.imageFlavor);
                if (object instanceof Image) {
                    return (Image)object;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<File> getImportedFiles(Transferable transferable) {
        try {
            if (DragUtils.hasURIListFlavor(transferable.getTransferDataFlavors())) {
                String string = (String)transferable.getTransferData(DragUtils.getUriListDataFlavor());
                File file = new File(new URL(string).getPath());
                return Arrays.asList(file);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (DragUtils.hasURIListFlavor(transferable.getTransferDataFlavors())) {
                return DragUtils.textURIListToFileList((String)transferable.getTransferData(DragUtils.getUriListDataFlavor()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            return (AbstractList)transferable.getTransferData(DataFlavor.javaFileListFlavor);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static List<File> textURIListToFileList(String string) {
        ArrayList<File> arrayList = new ArrayList<File>(1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("#")) continue;
            try {
                arrayList.add(new File(new URI(string2)));
            }
            catch (Throwable throwable) {}
        }
        return arrayList;
    }

    public static boolean hasURIListFlavor(DataFlavor[] dataFlavorArray) {
        for (DataFlavor dataFlavor : dataFlavorArray) {
            if (!DragUtils.getUriListDataFlavor().equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public static DataFlavor getUriListDataFlavor() {
        if (uriListFlavor == null) {
            try {
                uriListFlavor = new DataFlavor(URI_LIST_MIME_TYPE);
                return uriListFlavor;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return uriListFlavor;
    }
}

