/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.extended.colorchooser.GradientColorData;
import com.alee.extended.colorchooser.GradientData;
import com.alee.extended.painter.NinePatchIconPainter;
import com.alee.extended.painter.NinePatchStatePainter;
import com.alee.extended.painter.TexturePainter;
import com.alee.laf.colorchooser.HSBColor;
import com.alee.utils.FileUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.collection.ValuesTable;
import com.alee.utils.ninepatch.NinePatchIcon;
import com.alee.utils.xml.AliasProvider;
import com.alee.utils.xml.ColorConverter;
import com.alee.utils.xml.PasswordConverter;
import com.alee.utils.xml.ResourceFile;
import com.alee.utils.xml.ResourceList;
import com.alee.utils.xml.ResourceLocation;
import com.alee.utils.xml.ResourceMap;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class XmlUtils {
    public static final ColorConverter colorConverter = new ColorConverter();
    public static final PasswordConverter passwordConverter = new PasswordConverter();
    private static XStream xStream = null;

    public static XStream getXStream() {
        if (xStream == null) {
            XmlUtils.initializeXStream();
        }
        return xStream;
    }

    private static void initializeXStream() {
        try {
            xStream = new XStream();
            xStream.alias("Point", Point.class);
            xStream.useAttributeFor(Point.class, "x");
            xStream.useAttributeFor(Point.class, "y");
            xStream.alias("Dimension", Dimension.class);
            xStream.useAttributeFor(Dimension.class, "width");
            xStream.useAttributeFor(Dimension.class, "height");
            xStream.alias("Rectangle", Rectangle.class);
            xStream.useAttributeFor(Rectangle.class, "x");
            xStream.useAttributeFor(Rectangle.class, "y");
            xStream.useAttributeFor(Rectangle.class, "width");
            xStream.useAttributeFor(Rectangle.class, "height");
            xStream.alias("Insets", Insets.class);
            xStream.useAttributeFor(Insets.class, "top");
            xStream.useAttributeFor(Insets.class, "left");
            xStream.useAttributeFor(Insets.class, "bottom");
            xStream.useAttributeFor(Insets.class, "right");
            xStream.alias("Font", Font.class);
            xStream.alias("Color", Color.class);
            xStream.registerConverter(colorConverter);
            xStream.processAnnotations(ResourceLocation.class);
            xStream.processAnnotations(ResourceFile.class);
            xStream.processAnnotations(ResourceList.class);
            xStream.processAnnotations(ResourceMap.class);
            xStream.processAnnotations(ValuesTable.class);
            xStream.processAnnotations(GradientData.class);
            xStream.processAnnotations(GradientColorData.class);
            xStream.processAnnotations(HSBColor.class);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void processAnnotations(Class clazz) {
        XmlUtils.getXStream().processAnnotations(clazz);
    }

    public static void processAnnotations(Class[] classArray) {
        XmlUtils.getXStream().processAnnotations(classArray);
    }

    public static void alias(String string, Class clazz) {
        XmlUtils.getXStream().alias(string, clazz);
    }

    public static void useAttributeFor(Class clazz, String string) {
        XmlUtils.getXStream().useAttributeFor(clazz, string);
    }

    public static void addImplicitArray(Class clazz, String string) {
        XmlUtils.getXStream().addImplicitArray(clazz, string);
    }

    public static void addImplicitArray(Class clazz, String string, String string2) {
        XmlUtils.getXStream().addImplicitArray(clazz, string, string2);
    }

    public static void registerConverter(Converter converter) {
        XmlUtils.getXStream().registerConverter(converter);
    }

    public static void registerConverter(SingleValueConverter singleValueConverter) {
        XmlUtils.getXStream().registerConverter(singleValueConverter);
    }

    public static <T extends AliasProvider> void alias(Class<T> clazz) {
        ReflectUtils.callStaticMethodSafely(clazz, "provideAliases", XmlUtils.getXStream());
    }

    public static void toXML(Object object, String string) {
        XmlUtils.toXML(object, new File(string));
    }

    public static void toXML(Object object, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            XmlUtils.toXML(object, outputStreamWriter);
            outputStreamWriter.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String toXML(Object object) {
        return XmlUtils.getXStream().toXML(object);
    }

    public static void toXML(Object object, Writer writer) {
        XmlUtils.getXStream().toXML(object, writer);
    }

    public static void toXML(Object object, OutputStream outputStream) {
        XmlUtils.getXStream().toXML(object, outputStream);
    }

    public static Object fromXML(Reader reader) {
        return XmlUtils.getXStream().fromXML(reader);
    }

    public static Object fromXML(InputStream inputStream) {
        return XmlUtils.getXStream().fromXML(inputStream);
    }

    public static Object fromXML(URL uRL) {
        return XmlUtils.getXStream().fromXML(uRL);
    }

    public static Object fromXML(File file) {
        return XmlUtils.getXStream().fromXML(file);
    }

    public static Object fromXML(String string) {
        return XmlUtils.getXStream().fromXML(string);
    }

    public static Object fromXML(Object object) {
        if (object instanceof URL) {
            return XmlUtils.fromXML((URL)object);
        }
        if (object instanceof String) {
            return XmlUtils.fromXML(new File((String)object));
        }
        if (object instanceof File) {
            return XmlUtils.fromXML((File)object);
        }
        if (object instanceof Reader) {
            return XmlUtils.fromXML((Reader)object);
        }
        if (object instanceof InputStream) {
            return XmlUtils.fromXML((InputStream)object);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fromXML(ResourceFile resourceFile) {
        switch (resourceFile.getLocation()) {
            case url: {
                try {
                    return XmlUtils.fromXML(new URL(resourceFile.getSource()));
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    return null;
                }
            }
            case filePath: {
                return XmlUtils.fromXML(new File(resourceFile.getSource()));
            }
            case nearClass: {
                InputStream inputStream = null;
                try {
                    inputStream = Class.forName(resourceFile.getClassName()).getResourceAsStream(resourceFile.getSource());
                    Object object = XmlUtils.fromXML(inputStream);
                    return object;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    Object var3_6 = null;
                    return var3_6;
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    public static String loadString(Object object) {
        return XmlUtils.loadString(XmlUtils.loadResourceFile(object));
    }

    public static String loadString(ResourceFile resourceFile) {
        if (resourceFile.getLocation().equals(ResourceLocation.url)) {
            try {
                return FileUtils.readToString(new BufferedReader(new InputStreamReader(new URL(resourceFile.getSource()).openStream())));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        if (resourceFile.getLocation().equals(ResourceLocation.filePath)) {
            return FileUtils.readToString(new File(resourceFile.getSource()));
        }
        if (resourceFile.getLocation().equals(ResourceLocation.nearClass)) {
            try {
                return FileUtils.readToString(Class.forName(resourceFile.getClassName()), resourceFile.getSource());
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static ImageIcon loadImageIcon(Object object) {
        return XmlUtils.loadImageIcon(XmlUtils.loadResourceFile(object));
    }

    public static ImageIcon loadImageIcon(ResourceFile resourceFile) {
        if (resourceFile.getLocation().equals(ResourceLocation.url)) {
            try {
                return new ImageIcon(new URL(resourceFile.getSource()));
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                return null;
            }
        }
        if (resourceFile.getLocation().equals(ResourceLocation.filePath)) {
            try {
                return new ImageIcon(new File(resourceFile.getSource()).getCanonicalPath());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        if (resourceFile.getLocation().equals(ResourceLocation.nearClass)) {
            try {
                return new ImageIcon(Class.forName(resourceFile.getClassName()).getResource(resourceFile.getSource()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static List<ImageIcon> loadImagesList(Object object) {
        return XmlUtils.loadImagesList(XmlUtils.loadResourceList(object));
    }

    public static List<ImageIcon> loadImagesList(ResourceList resourceList) {
        ArrayList<ImageIcon> arrayList = new ArrayList<ImageIcon>();
        for (ResourceFile resourceFile : resourceList.getResources()) {
            ImageIcon imageIcon = XmlUtils.loadImageIcon(resourceFile);
            if (imageIcon == null) continue;
            arrayList.add(imageIcon);
        }
        return arrayList;
    }

    public static NinePatchIcon loadNinePatchIcon(Object object) {
        return XmlUtils.loadNinePatchIcon(XmlUtils.loadResourceFile(object));
    }

    public static NinePatchIcon loadNinePatchIcon(ResourceFile resourceFile) {
        return new NinePatchIcon(XmlUtils.loadImageIcon(resourceFile));
    }

    public static NinePatchStatePainter loadNinePatchStatePainter(Object object) {
        return XmlUtils.loadNinePatchStatePainter(XmlUtils.loadResourceMap(object));
    }

    public static NinePatchStatePainter loadNinePatchStatePainter(ResourceMap resourceMap) {
        NinePatchStatePainter ninePatchStatePainter = new NinePatchStatePainter();
        for (String string : resourceMap.getStates().keySet()) {
            ninePatchStatePainter.addStateIcon(string, XmlUtils.loadNinePatchIcon(resourceMap.getState(string)));
        }
        return ninePatchStatePainter;
    }

    public static NinePatchIconPainter loadNinePatchIconPainter(Object object) {
        return XmlUtils.loadNinePatchIconPainter(XmlUtils.loadResourceFile(object));
    }

    public static NinePatchIconPainter loadNinePatchIconPainter(ResourceFile resourceFile) {
        return new NinePatchIconPainter(XmlUtils.loadNinePatchIcon(resourceFile));
    }

    public static TexturePainter loadTexturePainter(Object object) {
        return XmlUtils.loadTexturePainter(XmlUtils.loadResourceFile(object));
    }

    public static TexturePainter loadTexturePainter(ResourceFile resourceFile) {
        return new TexturePainter(XmlUtils.loadImageIcon(resourceFile));
    }

    public static ResourceMap loadResourceMap(Object object) {
        return (ResourceMap)XmlUtils.fromXML(object);
    }

    public static ResourceList loadResourceList(Object object) {
        return (ResourceList)XmlUtils.fromXML(object);
    }

    public static ResourceFile loadResourceFile(Object object) {
        return (ResourceFile)XmlUtils.fromXML(object);
    }
}

