/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.reflection;

import com.alee.utils.FileUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.compare.Filter;
import com.alee.utils.reflection.JarEntry;
import com.alee.utils.reflection.JarEntryComparator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;

public class JarStructure {
    public static final JarEntryComparator COMPARATOR = new JarEntryComparator();
    private String jarLocation;
    private JarEntry root;

    public JarStructure(JarEntry jarEntry) {
        this.setRoot(jarEntry);
    }

    public String getJarLocation() {
        return this.jarLocation;
    }

    public void setJarLocation(String string) {
        this.jarLocation = string;
    }

    public JarEntry getRoot() {
        return this.root;
    }

    public void setRoot(JarEntry jarEntry) {
        this.root = jarEntry;
    }

    public List<JarEntry> getChildEntries(JarEntry jarEntry) {
        List<JarEntry> list = jarEntry != null ? jarEntry.getChilds() : this.getRoot().getChilds();
        Collections.sort(list, COMPARATOR);
        return list;
    }

    public JarEntry findEntryByName(String string) {
        return this.findEntryByName(string, this.getRoot());
    }

    private JarEntry findEntryByName(String string, JarEntry jarEntry) {
        for (JarEntry jarEntry2 : jarEntry.getChilds()) {
            if (FileUtils.getFileNamePart(jarEntry2.getName()).equals(string)) {
                return jarEntry2;
            }
            JarEntry jarEntry3 = this.findEntryByName(string, jarEntry2);
            if (jarEntry3 == null) continue;
            return jarEntry3;
        }
        return null;
    }

    public List<JarEntry> findSimilarEntries(String string) {
        return this.findSimilarEntries(string.toLowerCase(), null);
    }

    public List<JarEntry> findSimilarEntries(String string, Filter<JarEntry> filter) {
        return this.findSimilarEntries(string.toLowerCase(), this.getRoot(), filter, new ArrayList<JarEntry>());
    }

    private List<JarEntry> findSimilarEntries(String string, JarEntry jarEntry, Filter<JarEntry> filter, List<JarEntry> list) {
        if (jarEntry.getName().toLowerCase().contains(string) && (filter == null || filter.accept(jarEntry))) {
            list.add(jarEntry);
        }
        for (JarEntry jarEntry2 : jarEntry.getChilds()) {
            this.findSimilarEntries(string, jarEntry2, filter, list);
        }
        return list;
    }

    public JarEntry getClassEntry(Class clazz) {
        String[] stringArray = ReflectUtils.getClassPackages(clazz);
        String string = ReflectUtils.getJavaClassName(clazz);
        int n = 0;
        JarEntry jarEntry = this.getRoot();
        while (jarEntry != null) {
            if (n >= stringArray.length) {
                jarEntry = jarEntry.getChildByName(string);
                break;
            }
            jarEntry = jarEntry.getChildByName(stringArray[n]);
            ++n;
        }
        return jarEntry;
    }

    public void setPackageIcon(Package package_, ImageIcon imageIcon) {
        this.setPackageIcon(package_.getName(), imageIcon);
    }

    public void setPackageIcon(String string, ImageIcon imageIcon) {
        String[] stringArray = ReflectUtils.getPackages(string);
        JarEntry jarEntry = this.getRoot();
        for (String string2 : stringArray) {
            if (jarEntry == null) {
                return;
            }
            jarEntry = jarEntry.getChildByName(string2);
        }
        jarEntry.setIcon(imageIcon);
    }

    public void setClassIcon(Class clazz, ImageIcon imageIcon) {
        JarEntry jarEntry = this.getClassEntry(clazz);
        if (jarEntry != null) {
            jarEntry.setIcon(imageIcon);
        }
    }

    public InputStream getEntryInputStream(JarEntry jarEntry) throws IOException {
        return new ZipFile(this.getJarLocation()).getInputStream(jarEntry.getZipEntry());
    }
}

