/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.system;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaVersion {
    private static Pattern versionPattern = Pattern.compile("(\\d+\\.\\d+)(\\.(\\d+))?(_([^-]+))?(.*)");
    private static Pattern simpleVersionPattern = Pattern.compile("(\\d+\\.\\d+)(\\.(\\d+))?(.*)");
    private double majorVersion;
    private int minorVersion;
    private int updateNumber;
    private String patch;

    public JavaVersion(double d, int n) {
        this.majorVersion = d;
        this.minorVersion = 0;
        this.updateNumber = n;
    }

    public JavaVersion(double d, int n, int n2) {
        this.majorVersion = d;
        this.minorVersion = n;
        this.updateNumber = n2;
    }

    public JavaVersion(String string) {
        this.applyJavaVersion(string);
    }

    public void applyJavaVersion(String string) {
        block11: {
            try {
                String string2;
                Matcher matcher = versionPattern.matcher(string);
                if (!matcher.matches()) break block11;
                int n = matcher.groupCount();
                this.majorVersion = Double.parseDouble(matcher.group(1));
                if (n >= 3 && matcher.group(3) != null) {
                    this.minorVersion = Integer.parseInt(matcher.group(3));
                }
                if (n >= 5 && matcher.group(5) != null) {
                    try {
                        this.updateNumber = Integer.parseInt(matcher.group(5));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.patch = matcher.group(5);
                    }
                }
                if (n >= 6 && matcher.group(6) != null && (string2 = matcher.group(6)) != null && string2.trim().length() > 0) {
                    this.patch = string2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Matcher matcher = simpleVersionPattern.matcher(string);
                    if (matcher.matches()) {
                        int n = matcher.groupCount();
                        this.majorVersion = Double.parseDouble(matcher.group(1));
                        if (n >= 3 && matcher.group(3) != null) {
                            this.minorVersion = Integer.parseInt(matcher.group(3));
                        }
                    }
                }
                catch (NumberFormatException numberFormatException2) {
                    this.majorVersion = 1.4;
                    this.minorVersion = 0;
                    this.updateNumber = 0;
                }
            }
        }
    }

    public int compareVersion(double d, int n, int n2) {
        double d2 = this.majorVersion - d;
        if (d2 != 0.0) {
            return d2 < 0.0 ? -1 : 1;
        }
        int n3 = this.minorVersion - n;
        if (n3 != 0) {
            return n3;
        }
        return this.updateNumber - n2;
    }

    public double getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getUpdateNumber() {
        return this.updateNumber;
    }

    public String getPatch() {
        return this.patch;
    }
}

