/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Messages;
import com.sun.xml.internal.ws.handler.HandlerProcessor;
import com.sun.xml.internal.ws.handler.HandlerTube;
import com.sun.xml.internal.ws.handler.MessageUpdatableContext;
import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.handler.Handler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SOAPHandlerProcessor<C extends MessageUpdatableContext>
extends HandlerProcessor<C> {
    public SOAPHandlerProcessor(boolean bl, HandlerTube handlerTube, WSBinding wSBinding, List<? extends Handler> list) {
        super(handlerTube, wSBinding, list);
        this.isClient = bl;
    }

    @Override
    final void insertFaultMessage(C c, ProtocolException protocolException) {
        try {
            if (!((MessageUpdatableContext)c).getPacketMessage().isFault()) {
                Message message = Messages.create(this.binding.getSOAPVersion(), protocolException, this.determineFaultCode(this.binding.getSOAPVersion()));
                ((MessageUpdatableContext)c).setPacketMessage(message);
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "exception while creating fault message in handler chain", exception);
            throw new RuntimeException(exception);
        }
    }

    private QName determineFaultCode(SOAPVersion sOAPVersion) {
        return this.isClient ? sOAPVersion.faultCodeClient : sOAPVersion.faultCodeServer;
    }
}

