/*
 * Decompiled with CFR 0.152.
 */
package com.miui.desktop.convertUpsideToFreeStyle;

import android.content.ComponentName;
import android.content.Context;
import android.os.FileUtils;
import android.text.TextUtils;
import com.android.internal.util.FastXmlSerializer;
import com.miui.home.launcher.upsidescene.data.Appearance;
import com.miui.home.launcher.upsidescene.data.DataSerializerV1;
import com.miui.home.launcher.upsidescene.data.FreeButtonInfo;
import com.miui.home.launcher.upsidescene.data.FreeStyle;
import com.miui.home.launcher.upsidescene.data.Function;
import com.miui.home.launcher.upsidescene.data.SceneData;
import com.miui.home.launcher.upsidescene.data.Screen;
import com.miui.home.launcher.upsidescene.data.Sprite;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import libcore.io.IoUtils;
import miui.os.ExtraFileUtils;

public class Converter {
    public static void main(String[] args) {
        String src = "/home/zc/temp/for_scene_convert/com.miui.home.upside";
        String dst = null;
        if (args != null && args.length > 0) {
            src = args[0];
        }
        if (args != null && args.length > 1) {
            dst = args[1];
        } else if (src.endsWith(".upside")) {
            dst = String.valueOf(src.substring(0, src.length() - ".upside".length())) + ".freestyle";
        }
        System.out.println("convert upside to free style begin..." + new Date());
        Converter.convert(src, dst);
        System.out.println("convert upside to free style end...");
    }

    public static void convert(String srcPath, String dstFile) {
        Converter.convert(srcPath, dstFile, true);
    }

    public static void convert(String srcPath, String dstFile, boolean deleteTempDir) {
        try {
            String dstPath = String.valueOf(dstFile) + "__dir/";
            SceneData sceneData = Converter.loadSceneData(srcPath);
            FreeStyle freeStyle = Converter.convertToFreeStyle(sceneData);
            if (!new File(dstPath).exists()) {
                new File(dstPath).mkdirs();
            }
            Converter.saveFreeStyle(freeStyle, dstPath);
            ZipOutputStream newZip = new ZipOutputStream(new FileOutputStream(dstFile));
            Converter.zip(newZip, new File(dstPath), "");
            newZip.flush();
            newZip.close();
            if (deleteTempDir) {
                Converter.deleteFile(new File(dstPath));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static void deleteFile(File file) {
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                Converter.deleteFile(f);
                ++n2;
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    private static SceneData loadSceneData(String path) {
        DataSerializerV1 serializer = new DataSerializerV1(new Context(null));
        DataSerializerV1.DATA_LOCATION = path;
        return serializer.load();
    }

    private static FreeStyle convertToFreeStyle(SceneData sceneData) throws IOException {
        FreeStyle freeStyle = new FreeStyle();
        freeStyle.mName = sceneData.mName;
        freeStyle.mRawWidth = sceneData.mRawWidth;
        freeStyle.mRawHeight = sceneData.mRawHeight;
        for (SceneData.MtzGadgetInfo mtzInfo : sceneData.mMtzGadgets) {
            FreeStyle.MtzGadgetInfo freeMtzInfo = new FreeStyle.MtzGadgetInfo();
            freeMtzInfo.path = mtzInfo.path;
            freeStyle.mMtzGadgets.add(freeMtzInfo);
        }
        for (FreeButtonInfo freeButton : sceneData.mFreeButtons) {
            freeStyle.mFreeButtonInfos.add(freeButton);
        }
        for (SceneData.Screen sceneScreen : sceneData.mScreens) {
            Screen freeScreen = new Screen();
            freeStyle.mScreens.add(freeScreen);
            freeScreen.mType = sceneScreen.getType();
            freeScreen.mWidth = sceneScreen.getWidth();
            freeScreen.mHeight = sceneScreen.getHeight();
            freeScreen.mHome = sceneScreen.getHome();
            block15: for (SceneData.Sprite sceneSprite : sceneScreen.getSprites()) {
                Sprite freeSprite = new Sprite();
                freeScreen.mSprites.add(freeSprite);
                freeSprite.mOldSprite = sceneSprite;
                freeSprite.mLeft = sceneSprite.getLeft();
                freeSprite.mTop = sceneSprite.getTop();
                freeSprite.setEditName(sceneSprite.getEditName());
                switch (sceneSprite.getType()) {
                    case 1: {
                        SceneData.SpritePicture pic = (SceneData.SpritePicture)sceneSprite;
                        Appearance.StageImageAppearance appearance = new Appearance.StageImageAppearance("stage_images/" + pic.mPictureName, 1.0f);
                        freeSprite.mAppearance = appearance;
                        break;
                    }
                    case 3: {
                        SceneData.SpriteCell cell = (SceneData.SpriteCell)sceneSprite;
                        freeSprite.mRotation = cell.getRotation();
                        freeSprite.mScaleX = freeSprite.mScaleY = cell.getScale();
                        switch (cell.getContentType()) {
                            case 5: {
                                Function.AppFunction appFunc = (Function.AppFunction)Function.createFunction(1);
                                freeSprite.setFunction(appFunc);
                                appFunc.setShowIcon(cell.mShowIcon);
                                appFunc.setShowTitle(cell.mShowTitle);
                                if (cell.getShortcuts().getComponentNames().length < 1) break;
                                appFunc.setComponentName(cell.getShortcuts().getComponentNames()[0]);
                                break;
                            }
                            case 6: {
                                System.out.println("may be can not go to here.");
                                Function.FolderFunction folderFunc = (Function.FolderFunction)Function.createFunction(1);
                                freeSprite.setFunction(folderFunc);
                                ArrayList<ComponentName> list = new ArrayList<ComponentName>();
                                ComponentName[] componentNameArray = cell.getShortcuts().getComponentNames();
                                int n = componentNameArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    ComponentName cn = componentNameArray[n2];
                                    list.add(cn);
                                    ++n2;
                                }
                                folderFunc.setComponentNames(list);
                                break;
                            }
                            case 2: {
                                System.out.println("may be can not go to here.");
                                break;
                            }
                            case 3: {
                                System.out.println("may be can not go to here.");
                                break;
                            }
                            case 4: {
                                Function.MtzGadgetFunction mtzFunc = (Function.MtzGadgetFunction)Function.createFunction(6);
                                freeSprite.setFunction(mtzFunc);
                                int width = cell.getSpanX() * 90 * 2;
                                int height = cell.getSpanY() * 121 * 2;
                                freeSprite.mRawWidth = width;
                                freeSprite.mRawHeight = height;
                                mtzFunc.setMtzRelativePath("tools/" + cell.mWidget.mDefaultLocation.substring(0, cell.mWidget.mDefaultLocation.length() - 4));
                            }
                        }
                        continue block15;
                    }
                    case 2: {
                        SceneData.SpriteButton btn = (SceneData.SpriteButton)sceneSprite;
                        String path = btn.mResourcesPackageName;
                        if (TextUtils.isEmpty(path)) {
                            int dotIndex;
                            path = !TextUtils.isEmpty(btn.mPressedName) ? ((dotIndex = btn.mNormalName.indexOf(46)) >= 0 ? btn.mNormalName.substring(0, dotIndex) : btn.mNormalName) : btn.mNormalName;
                        }
                        Appearance.FreeButtonAppearance freeAppear = new Appearance.FreeButtonAppearance(path, 1.0f);
                        freeSprite.mAppearance = freeAppear;
                        if (btn.mIntent == null || btn.mIntent.packageName == null || btn.mIntent.clsName == null) continue block15;
                        Function.AppFunction appFunc = (Function.AppFunction)Function.createFunction(1);
                        freeSprite.setFunction(appFunc);
                        appFunc.setComponentName(new ComponentName(btn.mIntent.packageName, btn.mIntent.clsName));
                    }
                }
            }
        }
        return freeStyle;
    }

    private static void saveFreeStyle(FreeStyle freeStyle, String savePath) throws IOException {
        FileOutputStream os = null;
        ZipFile srcZip = new ZipFile(DataSerializerV1.DATA_LOCATION);
        try {
            try {
                os = new FileOutputStream(String.valueOf(savePath) + "description.xml");
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(os, "utf-8");
                out.startDocument(null, true);
                out.startTag(null, "scene");
                out.attribute(null, "width", Integer.toString(freeStyle.mRawWidth));
                out.attribute(null, "name", freeStyle.mName);
                out.attribute(null, "height", Integer.toString(freeStyle.mRawHeight));
                for (Screen screen : freeStyle.mScreens) {
                    String type;
                    out.startTag(null, "screen");
                    switch (screen.getType()) {
                        case 1: {
                            type = "drift";
                            break;
                        }
                        case 2: {
                            type = "background";
                            break;
                        }
                        case 3: {
                            type = "foreground";
                            break;
                        }
                        case 4: {
                            type = "dock";
                            break;
                        }
                        default: {
                            throw new RuntimeException("unknown screen type:" + screen.getType());
                        }
                    }
                    out.attribute(null, "type", type);
                    out.attribute(null, "width", Integer.toString(screen.getWidth()));
                    if (screen.getHome() > 0) {
                        out.attribute(null, "home", Integer.toString(screen.getHome()));
                    }
                    int size = screen.getSprites().size();
                    int i = 0;
                    while (i < size) {
                        String func;
                        String appearance;
                        Sprite sprite = screen.getSprites().get(i);
                        out.startTag(null, "sprite");
                        out.attribute(null, "left", Integer.toString(sprite.getLeft()));
                        out.attribute(null, "top", Integer.toString(sprite.getTop()));
                        if (sprite.getRotation() != 0.0f) {
                            out.attribute(null, "rotation", Float.toString(sprite.getRotation()));
                        }
                        if (sprite.getScaleX() != 0.0f && sprite.getScaleX() != 1.0f) {
                            out.attribute(null, "scale_x", Float.toString(sprite.getScaleX()));
                        }
                        if (sprite.getScaleY() != 0.0f && sprite.getScaleY() != 1.0f) {
                            out.attribute(null, "scale_y", Float.toString(sprite.getScaleY()));
                        }
                        if (sprite.mRawWidth > 0 && sprite.mRawHeight > 0) {
                            out.attribute(null, "width", Integer.toString(sprite.mRawWidth));
                            out.attribute(null, "height", Integer.toString(sprite.mRawHeight));
                        }
                        if (sprite.getEditName() != null && !sprite.getEditName().isEmpty()) {
                            out.attribute(null, "_name", sprite.getEditName());
                        }
                        if (!TextUtils.isEmpty(appearance = sprite.getAppearance().toString())) {
                            out.attribute(null, "appearance", appearance);
                        }
                        if (!TextUtils.isEmpty(func = sprite.getFunction().toString())) {
                            out.attribute(null, "function", func);
                        }
                        out.endTag(null, "sprite");
                        switch (sprite.mOldSprite.getType()) {
                            case 1: {
                                SceneData.SpritePicture pic = (SceneData.SpritePicture)sprite.mOldSprite;
                                Converter.fetchFile(srcZip, pic.mPictureName, String.valueOf(savePath) + "stage_images" + "/" + pic.mPictureName);
                                break;
                            }
                            case 2: {
                                SceneData.SpriteButton btn = (SceneData.SpriteButton)sprite.mOldSprite;
                                if (TextUtils.isEmpty(btn.mPressedName)) {
                                    Converter.fetchFile(srcZip, btn.mNormalName, String.valueOf(savePath) + "skins" + "/" + btn.mNormalName);
                                    break;
                                }
                                String extName = btn.mNormalName.substring(btn.mNormalName.lastIndexOf(46));
                                String name = btn.mNormalName.substring(0, btn.mNormalName.length() - extName.length());
                                String normalDstName = String.valueOf(name) + "_normal" + extName;
                                String pressedDstName = String.valueOf(name) + "_normal_pressed" + extName;
                                Converter.fetchFile(srcZip, btn.mNormalName, String.valueOf(savePath) + "skins" + "/" + name + "/" + normalDstName);
                                Converter.fetchFile(srcZip, btn.mPressedName, String.valueOf(savePath) + "skins" + "/" + name + "/" + pressedDstName);
                                break;
                            }
                            case 3: {
                                SceneData.SpriteCell cell = (SceneData.SpriteCell)sprite.mOldSprite;
                                if (cell.getContentType() != 4) break;
                                String dstMtz = String.valueOf(savePath) + "tools/" + cell.mWidget.mDefaultLocation;
                                Converter.fetchFile(srcZip, cell.mWidget.mDefaultLocation, dstMtz);
                                Converter.unzip(dstMtz, String.valueOf(dstMtz.substring(0, dstMtz.length() - 4)) + "/");
                                new File(dstMtz).delete();
                            }
                        }
                        ++i;
                    }
                    out.endTag(null, "screen");
                }
                out.endTag(null, "scene");
                out.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException("save FreeStyle failed.", ex);
            }
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(os);
            try {
                srcZip.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        IoUtils.closeQuietly(os);
        try {
            srcZip.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void fetchFile(ZipFile srcZip, String pictureName, String path) throws IOException {
        ZipEntry entry = srcZip.getEntry(pictureName);
        if (entry == null) {
            return;
        }
        InputStream is = srcZip.getInputStream(entry);
        new File(path).getParentFile().mkdirs();
        DataSerializerV1.copyStreamToFileIfNotExist(is, path);
        is.close();
    }

    public static void unzip(String zipPath, String targetFolder) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zipPath);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            File root = new File(targetFolder);
            root.mkdirs();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String path = String.valueOf(targetFolder) + entry.getName();
                if (entry.isDirectory()) {
                    new File(path).mkdirs();
                    continue;
                }
                Converter.writeTo(zipFile.getInputStream(entry), path);
            }
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    public static String writeTo(InputStream is, String filename) {
        block20: {
            OutputStream os = null;
            try {
                try {
                    File file = new File(filename);
                    file.getParentFile().mkdirs();
                    is = new BufferedInputStream(is);
                    FileUtils.copyToFile(is, file);
                    file.setLastModified(System.currentTimeMillis());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (os == null) break block20;
                    try {
                        os.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean zip(ZipOutputStream out, File sourceFolder, String targetFile) {
        boolean result = true;
        if (sourceFolder.isDirectory()) {
            File[] files = sourceFolder.listFiles();
            if (files == null) return result;
            if (targetFile.length() > 0) {
                targetFile = ExtraFileUtils.standardizeFolderPath(targetFile);
            }
            int i = 0;
            while (i < files.length) {
                result = Converter.zip(out, files[i], String.valueOf(targetFile) + files[i].getName()) && result;
                ++i;
            }
            return result;
        }
        FilterInputStream ch = null;
        BufferedInputStream in = null;
        try {
            try {
                byte[] buffer = new byte[4096];
                int count = -1;
                CRC32 crc32 = new CRC32();
                ch = new CheckedInputStream(new BufferedInputStream(new FileInputStream(sourceFolder)), crc32);
                while ((count = ch.read(buffer)) != -1) {
                }
                ZipEntry entry = new ZipEntry(targetFile);
                entry.setMethod(0);
                entry.setSize(sourceFolder.length());
                entry.setCrc(crc32.getValue());
                out.putNextEntry(entry);
                in = new BufferedInputStream(new FileInputStream(sourceFolder));
                while ((count = in.read(buffer)) != -1) {
                    out.write(buffer, 0, count);
                }
                return result;
            }
            catch (Exception e) {
                e.printStackTrace();
                result = false;
                if (ch != null) {
                    try {
                        ch.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (in == null) return result;
                try {
                    in.close();
                    return result;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            return result;
        }
        finally {
            if (ch != null) {
                try {
                    ch.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

