/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.compress;

import com.miui.theme.tool.ninepatch.NinePatchUtils;
import com.miui.theme.tool.util.ThemeHelper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class ZipCompressor {
    static Logger logger = Logger.getLogger(ZipCompressor.class.getName());
    static final int BUFFER = 8192;
    private File mZipFile;
    private boolean mIsEncode9Patch = true;
    private HashSet<String> mNinePatchWrongs = new HashSet();

    public ZipCompressor(String pathName) {
        this.mZipFile = new File(pathName);
    }

    public ZipCompressor(String dstPathName, boolean isEncode9Patch) {
        this.mZipFile = new File(dstPathName);
        this.mIsEncode9Patch = isEncode9Patch;
    }

    public HashSet<String> compressContent(String srcPathName) {
        File file = new File(srcPathName);
        if (!file.exists()) {
            throw new RuntimeException(String.valueOf(srcPathName) + " not exists");
        }
        ZipOutputStream zos = null;
        FileOutputStream fos = null;
        FilterOutputStream cos = null;
        try {
            fos = new FileOutputStream(this.mZipFile);
            cos = new CheckedOutputStream(fos, new CRC32());
            zos = new ZipOutputStream(cos);
            if (srcPathName.endsWith("bootanimation")) {
                zos.setMethod(0);
            }
            String basedir = "";
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File eachFile = fileArray[n2];
                this.compress(eachFile, zos, basedir);
                ++n2;
            }
            HashSet<String> hashSet = this.mNinePatchWrongs;
            return hashSet;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
                if (cos != null) {
                    cos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void compress(File file, ZipOutputStream out, String basedir) {
        if (file.isDirectory()) {
            this.compressDirectory(file, out, basedir);
        } else {
            this.compressFile(file, out, basedir);
        }
    }

    private void compressDirectory(File dir, ZipOutputStream out, String basedir) {
        if (!dir.exists()) {
            return;
        }
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.compress(file, out, String.valueOf(basedir) + dir.getName() + "/");
            ++n2;
        }
    }

    private void compressFile(File file, ZipOutputStream out, String basedir) {
        if (!file.exists()) {
            return;
        }
        BufferedInputStream bis = null;
        FileInputStream fis = null;
        try {
            try {
                int count;
                if (this.mIsEncode9Patch && ThemeHelper.isNinePatchName(file.getName())) {
                    ByteArrayInputStream byteIn = null;
                    byteIn = NinePatchUtils.compileSinglePng(new FileInputStream(file));
                    if (byteIn != null) {
                        bis = new BufferedInputStream(byteIn);
                        byteIn.close();
                    } else {
                        bis = new BufferedInputStream(new FileInputStream(file));
                    }
                    if (byteIn == null) {
                        logger.debug(String.valueOf(file.getAbsolutePath()) + " not valid .9.png ");
                    }
                } else {
                    bis = new BufferedInputStream(new FileInputStream(file));
                }
                ZipEntry entry = new ZipEntry(String.valueOf(basedir) + file.getName());
                if (basedir.indexOf("bootanimation") != -1 || file.getAbsolutePath().indexOf("bootanimation") != -1) {
                    entry.setMethod(0);
                    entry.setSize(file.length());
                    entry.setCompressedSize(file.length());
                    CRC32 crc32 = new CRC32();
                    fis = new FileInputStream(file);
                    crc32.update(IOUtils.toByteArray(fis));
                    entry.setCrc(crc32.getValue());
                }
                entry.setTime(file.lastModified());
                entry.setUnixMode(644);
                out.putNextEntry(entry);
                out.setEncoding(ThemeHelper.CHARSET);
                byte[] data = new byte[8192];
                while ((count = bis.read(data, 0, 8192)) != -1) {
                    out.write(data, 0, count);
                }
            }
            catch (Exception e) {
                String sourceFile = file.getAbsolutePath();
                e.printStackTrace();
                this.mNinePatchWrongs.add(String.valueOf(e.getMessage()) + sourceFile.substring(new File(ThemeHelper.sThemeFolderPath).getParent().length() + 1));
                try {
                    if (bis != null) {
                        bis.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

