/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.extract;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class Extractor {
    private final int zipSuffix = 4;
    private String mSrcFilePath;
    private String mDestDir;
    private final String[] SUFFIXES = new String[]{".png", ".jpg", ".mp3", ".ogg", ".mp3", ".jpeg", ".bmp", ".ivt"};
    public final int TYPE_THEME = 1;
    public final int TYPE_APK = 2;

    public Extractor(String absoluteFileName) {
        this.mSrcFilePath = absoluteFileName;
    }

    public Extractor(String srcPath, String destPath) {
        this.mSrcFilePath = srcPath;
        this.mDestDir = destPath;
    }

    public void unzipTheme() {
        String str = this.extract(this.mSrcFilePath, 1);
        if (str == null) {
            return;
        }
        File f = new File(str);
        if (!f.exists() || f.isFile()) {
            return;
        }
        this.mDestDir = null;
        this.renameToZip(f);
        this.extractInner(f);
    }

    public boolean isResFile(java.util.zip.ZipEntry entry) {
        String s = entry.getName().toLowerCase();
        if (entry.isDirectory() && (s.endsWith("res") || s.endsWith("raw") || s.indexOf("drawable") != -1)) {
            return true;
        }
        int i = 0;
        while (i < this.SUFFIXES.length) {
            if (s.endsWith(this.SUFFIXES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void unzipApkRes() {
        if (this.mDestDir == null || this.mSrcFilePath == null) {
            return;
        }
        if (!new File(this.mSrcFilePath).exists()) {
            return;
        }
        this.extractAPK(this.mSrcFilePath, 2);
    }

    private boolean suffixNotUnzipable(String fileName) {
        return !fileName.toLowerCase().endsWith(".zip") && !fileName.toLowerCase().endsWith(".mtz") && !fileName.toLowerCase().endsWith(".apk");
    }

    private String extract(String fileName, int type) {
        if (this.suffixNotUnzipable(fileName)) {
            return null;
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(fileName);
            File fileRoot = null;
            String filePath = "";
            if (type == 2) {
                fileRoot = new File(this.mDestDir);
            } else {
                String des = this.mDestDir;
                if (des == null || "".equals(des)) {
                    des = fileName.substring(0, fileName.length() - 4);
                }
                fileRoot = new File(des);
            }
            fileRoot.mkdir();
            filePath = fileRoot.getAbsolutePath();
            filePath = String.valueOf(filePath) + File.separator;
            Enumeration emu = zipFile.getEntries();
            while (emu.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)emu.nextElement();
                if (type == 2 && !this.isResFile(entry)) continue;
                if (entry.isDirectory()) {
                    File fp = new File(String.valueOf(filePath) + entry.getName()).getParentFile();
                    if (fp != null && !fp.exists()) {
                        fp.mkdirs();
                    }
                    new File(String.valueOf(filePath) + entry.getName()).mkdirs();
                    continue;
                }
                File file = new File(String.valueOf(filePath) + entry.getName());
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(file);
                IOUtils.copy(zipFile.getInputStream(entry), (OutputStream)fos);
                fos.close();
            }
            zipFile.close();
            return filePath;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String extractAPK(String fileName, int type) {
        if (this.suffixNotUnzipable(fileName)) {
            return null;
        }
        java.util.zip.ZipFile zipFile = null;
        try {
            zipFile = new java.util.zip.ZipFile(fileName);
            File fileRoot = null;
            String filePath = "";
            if (type == 2) {
                fileRoot = new File(this.mDestDir);
            } else {
                String des = this.mDestDir;
                if (des == null || "".equals(des)) {
                    des = fileName.substring(0, fileName.length() - 4);
                }
                fileRoot = new File(des);
            }
            fileRoot.mkdir();
            filePath = fileRoot.getAbsolutePath();
            filePath = String.valueOf(filePath) + File.separator;
            Enumeration<? extends java.util.zip.ZipEntry> emu = zipFile.entries();
            while (emu.hasMoreElements()) {
                java.util.zip.ZipEntry entry = emu.nextElement();
                if (type == 2 && !this.isResFile(entry)) continue;
                if (entry.isDirectory()) {
                    File fp = new File(String.valueOf(filePath) + entry.getName()).getParentFile();
                    if (fp != null && !fp.exists()) {
                        fp.mkdirs();
                    }
                    new File(String.valueOf(filePath) + entry.getName()).mkdirs();
                    continue;
                }
                File file = new File(String.valueOf(filePath) + entry.getName());
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(file);
                IOUtils.copy(zipFile.getInputStream(entry), (OutputStream)fos);
                fos.close();
            }
            zipFile.close();
            return filePath;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void renameToZip(File file) {
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File eachFile = fileArray[n2];
            if (!(eachFile.isDirectory() || eachFile.getName().toLowerCase().endsWith(".xml") || eachFile.getName().toLowerCase().endsWith(".zip"))) {
                File zipF = new File(String.valueOf(eachFile.getAbsolutePath()) + ".zip");
                eachFile.renameTo(zipF);
                System.out.println(String.valueOf(eachFile.getAbsolutePath()) + ".zip");
                try {
                    new ZipFile(zipF).close();
                }
                catch (Exception e) {
                    zipF.renameTo(eachFile);
                }
            }
            ++n2;
        }
    }

    private void extractInner(File file) {
        File[] fileArr;
        File[] fileArray = fileArr = file.listFiles();
        int n = fileArr.length;
        int n2 = 0;
        while (n2 < n) {
            File eachFile = fileArray[n2];
            if (eachFile.isDirectory() && eachFile.getName().equals("boots")) {
                File[] listFile;
                File[] fileArray2 = listFile = eachFile.listFiles();
                int n3 = listFile.length;
                int n4 = 0;
                while (n4 < n3) {
                    File bootFile = fileArray2[n4];
                    if (bootFile.getName().equals("bootanimation.zip")) {
                        this.extract(bootFile.getAbsolutePath(), 1);
                    }
                    bootFile.delete();
                    ++n4;
                }
            }
            if (eachFile.getName().endsWith(".zip")) {
                this.extract(eachFile.getAbsolutePath(), 1);
                eachFile.delete();
            }
            ++n2;
        }
    }
}

