/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.tagTreeBuilder;

import com.miui.theme.tool.tagTreeBuilder.ElementFactory;
import com.miui.theme.tool.tagTreeBuilder.TagElement;
import com.miui.theme.tool.xmlparser.Attributes;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;

public class BaseElement {
    private String TAG_NAME = null;
    protected int mStartRow = 0;
    protected int mEndRow = 0;
    protected int mStartPos = 0;
    protected int mEndPos = 0;
    protected int mChildStartPos = 0;
    protected int mChildEndPos = 0;
    protected String content;
    protected ArrayList<BaseElement> mChildTags = new ArrayList();
    protected Attributes mAttributes = new Attributes();
    protected ElementFactory mFactory = new ElementFactory();
    protected BaseElement mFatherNode = null;
    protected int mLength = 0;
    protected boolean isWrong = false;
    DefaultMutableTreeNode r;

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public BaseElement() {
    }

    public BaseElement(TagElement tag) {
        this.TAG_NAME = tag.getTagName();
        this.mAttributes.setAttributeList(tag.getAttributes());
    }

    public BaseElement addChild(TagElement tag) {
        BaseElement child = this.mFactory.createInstance(tag);
        if (child == null) {
            return null;
        }
        child.setmLength(this.getmLength() + 1);
        this.mChildTags.add(child);
        return child;
    }

    public void addChild(BaseElement child) {
        if (child == null) {
            return;
        }
        this.mChildTags.add(child);
    }

    public void deleteChildNodes() {
        this.mChildTags.clear();
    }

    public BaseElement getFatherNode() {
        return this.mFatherNode;
    }

    public void setFatherNode(BaseElement mFatherNode) {
        this.mFatherNode = mFatherNode;
    }

    public int getStartRow() {
        return this.mStartRow;
    }

    public void setStartRow(int mStartRow) {
        this.mStartRow = mStartRow;
    }

    public int getEndRow() {
        return this.mEndRow;
    }

    public void setEndRow(int mEndRow) {
        this.mEndRow = mEndRow;
    }

    public int getStartPos() {
        return this.mStartPos;
    }

    public void setStartPos(int mStartPos) {
        this.mStartPos = mStartPos;
    }

    public int getEndPos() {
        return this.mEndPos;
    }

    public void setEndPos(int mEndPos) {
        this.mEndPos = mEndPos;
    }

    public int getChildStartPos() {
        return this.mChildStartPos;
    }

    public void setChildStartPos(int mChildStartPos) {
        this.mChildStartPos = mChildStartPos;
    }

    public int getChildEndPos() {
        return this.mChildEndPos;
    }

    public void setChildEndPos(int mChildEndPos) {
        this.mChildEndPos = mChildEndPos;
    }

    public ArrayList<BaseElement> getChildTags() {
        return this.mChildTags;
    }

    public void setChildTags(ArrayList<BaseElement> mChildTags) {
        this.mChildTags = mChildTags;
    }

    public ElementFactory getFactory() {
        return this.mFactory;
    }

    public void setFactory(ElementFactory mFactory) {
        this.mFactory = mFactory;
    }

    public String getTAG_NAME() {
        return this.TAG_NAME;
    }

    public void setTAG_NAME(String tAG_NAME) {
        this.TAG_NAME = tAG_NAME;
    }

    public Attributes getAttributes() {
        return this.mAttributes;
    }

    public void setAttributes(Attributes mAttributes) {
        this.mAttributes = mAttributes;
    }

    public int getmLength() {
        return this.mLength;
    }

    public void setmLength(int mLength) {
        this.mLength = mLength;
    }

    public boolean isWrong() {
        return this.isWrong;
    }

    public void setWrong(boolean isWrong) {
        this.isWrong = isWrong;
        BaseElement ele = this.getFatherNode();
        while (ele != null) {
            ele.isWrong = isWrong;
            ele = ele.getFatherNode();
        }
    }

    public BaseElement fetch(int pos) {
        BaseElement ele = null;
        if (pos >= this.getStartPos() && pos <= this.getEndPos()) {
            int i = 0;
            while (i < this.mChildTags.size() && ele == null) {
                ele = this.mChildTags.get(i).fetch(pos);
                ++i;
            }
            if (ele == null) {
                return this;
            }
            return ele;
        }
        return null;
    }

    public int childCount(String name) {
        int count = 0;
        for (BaseElement ele : this.mChildTags) {
            if (!ele.getTAG_NAME().equals(name)) continue;
            ++count;
        }
        return count;
    }

    public int fetchChildPos(int childPos) {
        int resultPos = this.getChildStartPos();
        if (this.mChildTags.size() == 0) {
            return resultPos;
        }
        for (BaseElement current : this.mChildTags) {
            int pos = current.getEndPos();
            if (pos >= childPos) continue;
            resultPos = current.getEndPos();
        }
        return resultPos;
    }

    public BaseElement fetchBrotherAbove() {
        BaseElement brother = null;
        for (BaseElement ele : this.getFatherNode().getChildTags()) {
            if (ele.equals(this)) break;
            brother = ele;
        }
        return brother;
    }

    public BaseElement fetchBrotherBelow() {
        BaseElement brother = null;
        boolean flag = false;
        for (BaseElement ele : this.getFatherNode().getChildTags()) {
            if (ele.equals(this)) {
                flag = true;
                continue;
            }
            if (!flag) continue;
            brother = ele;
            break;
        }
        return brother;
    }

    public void childToBrother() {
        if (this.mChildTags.size() == 0) {
            return;
        }
        for (BaseElement child : this.mChildTags) {
            this.getFatherNode().addChild(child);
        }
        this.mChildTags.clear();
    }

    public void Print(int a) {
        ++a;
        int i = 0;
        while (i < a) {
            System.out.print("      ");
            ++i;
        }
        System.out.print(String.valueOf(this.getTAG_NAME()) + "     mStartPos:" + this.getStartPos() + "  mEndPos" + this.getEndPos() + "          ");
        i = 0;
        while (i < this.mAttributes.getLength()) {
            System.out.print("   attribute : " + this.getAttributes().getName(i) + "   value: " + this.getAttributes().getValue(i) + "    length:" + this.getmLength());
            ++i;
        }
        System.out.println();
        i = 0;
        while (i < this.mChildTags.size()) {
            this.mChildTags.get(i).Print(a);
            ++i;
        }
        --a;
    }

    public DefaultMutableTreeNode load() {
        return this.r;
    }
}

