/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.xmlparser;

import com.miui.theme.tool.xmlparser.Attributes;
import com.miui.theme.tool.xmlparser.ContentHandler;
import com.miui.theme.tool.xmlparser.ElementInfo;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMPullParser
extends KXmlParser {
    private ContentHandler mHandler;
    private int mLastPosition;
    private int mLastRow;
    private Vector<Integer> lines;
    private String mText;

    public ContentHandler getHandler() {
        return this.mHandler;
    }

    public void setHandler(ContentHandler mHandler) {
        this.mHandler = mHandler;
    }

    public void parser(String s) throws XmlPullParserException {
        this.mText = s;
        this.lines = new Vector();
        int pos = 1;
        this.lines.add(0);
        int i = 0;
        while (i < s.length()) {
            ++pos;
            if (s.charAt(i) == '\n') {
                this.lines.add(pos);
            }
            ++i;
        }
        this.setInput(new StringReader(s));
        try {
            int eventType = this.getEventType();
            do {
                if (eventType == 0) {
                    this.mLastPosition = this.lines.get(1) + 1;
                    eventType = this.next();
                    continue;
                }
                if (eventType == 1) {
                    this.mHandler.endDocument(this.getElement());
                } else if (eventType == 2) {
                    this.mHandler.startElement(this.getName(), this.getAttributes(), this.getElement());
                } else if (eventType == 3) {
                    this.mHandler.endElement(this.getName(), this.getElement());
                } else if (eventType == 4 && this.getText().trim().length() > 0) {
                    this.mHandler.text(this.getText().trim());
                }
                this.mLastPosition = this.getPosition(this.getLineNumber(), this.getColumnNumber());
                eventType = this.next();
            } while (eventType != 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int getPosition(int row, int col) {
        return this.lines.get(row - 1) + col;
    }

    private ElementInfo getElement() {
        return new ElementInfo(this.getLineNumber(), this.mLastPosition + 1, this.getPosition(this.getLineNumber(), this.getColumnNumber()) - 1);
    }

    private Attributes getAttributes() {
        Attributes attrs = new Attributes();
        int i = 0;
        while (i < this.getAttributeCount()) {
            attrs.addAttribute(this.getAttributeName(i), this.getAttributeValue(i));
            ++i;
        }
        return attrs;
    }
}

