/*
 * Decompiled with CFR 0.152.
 */
package miui.imagefilters;

import miui.imagefilters.HslFilter;
import miui.imagefilters.IImageFilter;
import miui.imagefilters.ImageData;

public class HslWrapFilter
implements IImageFilter {
    private HslFilter mHsl;
    private HslFilter mHsv;

    private void ensureHsl() {
        if (this.mHsl == null) {
            this.mHsl = new HslFilter();
            this.mHsl.useHsv = false;
        }
    }

    private void ensureHsv() {
        if (this.mHsv == null) {
            this.mHsv = new HslFilter();
            this.mHsv.useHsv = true;
        }
    }

    public void setHueModify(float hue) {
        this.ensureHsl();
        this.mHsl.setHueModify(hue);
    }

    public void setSaturationModify(float saturation) {
        this.ensureHsl();
        this.mHsl.setSaturationModify(saturation);
    }

    public void setLightnessModify(float lightness) {
        if (lightness > 0.0f) {
            this.ensureHsl();
            this.mHsl.setLightnessModify(lightness);
        } else {
            this.ensureHsv();
            this.mHsv.setLightnessModify(lightness);
        }
    }

    public void setHueAdjust(float hue) {
        this.ensureHsl();
        this.mHsl.setHueAdjust(hue);
    }

    public void setSaturationAdjust(float saturation) {
        this.ensureHsl();
        this.mHsl.setSaturationAdjust(saturation);
    }

    public void setLightnessAdjust(float lightness) {
        if (lightness > 0.0f) {
            this.ensureHsl();
            this.mHsl.setLightnessAdjust(lightness);
        } else {
            this.ensureHsv();
            this.mHsv.setLightnessAdjust(lightness);
        }
    }

    @Override
    public void process(ImageData imgData) {
        if (this.mHsl != null) {
            this.mHsl.process(imgData);
        }
        if (this.mHsv != null) {
            this.mHsv.process(imgData);
        }
    }
}

