/*
 * Decompiled with CFR 0.152.
 */
package miui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public interface FileAccessable {
    public FileAccessable createBySubpath(String var1);

    public FileAccessable createByExtension(String var1);

    public boolean exists();

    public boolean isFile();

    public boolean isDirectory();

    public String getName();

    public List<FileAccessable> list();

    public List<FileAccessable> list(FileAccessableFilter var1);

    public InputStream getInputStream();

    public static abstract class AbstractFileAccessable
    implements FileAccessable {
        @Override
        public boolean isDirectory() {
            if (!this.exists()) {
                return false;
            }
            return !this.isFile();
        }

        @Override
        public List<FileAccessable> list(FileAccessableFilter filter) {
            if (filter == null) {
                return this.list();
            }
            List<FileAccessable> allFiles = this.list();
            if (allFiles == null) {
                return null;
            }
            ArrayList<FileAccessable> returnFiles = new ArrayList<FileAccessable>();
            for (FileAccessable fileAccessable : allFiles) {
                if (!filter.accept(fileAccessable)) continue;
                returnFiles.add(fileAccessable);
            }
            return returnFiles;
        }
    }

    public static class DeskFile
    extends AbstractFileAccessable {
        File mFile;

        public DeskFile(File root, String subpath) {
            this.mFile = new File(root, subpath);
        }

        public DeskFile(String root, String subpath) {
            this.mFile = new File(root, subpath);
        }

        public DeskFile(String filePath) {
            this.mFile = new File(filePath);
        }

        public File getFile() {
            return this.mFile;
        }

        @Override
        public boolean exists() {
            return this.mFile.exists();
        }

        @Override
        public boolean isFile() {
            return this.mFile.isFile();
        }

        @Override
        public List<FileAccessable> list() {
            String[] files = this.mFile.list();
            ArrayList<FileAccessable> returnList = new ArrayList<FileAccessable>();
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                returnList.add(new DeskFile(this.mFile, file));
                ++n2;
            }
            return returnList;
        }

        @Override
        public InputStream getInputStream() {
            try {
                return new FileInputStream(this.mFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public String getName() {
            return this.mFile.getName();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof DeskFile)) {
                return false;
            }
            DeskFile target = (DeskFile)o;
            return this.mFile.equals(target.mFile);
        }

        public int hashCode() {
            return this.mFile.hashCode();
        }

        @Override
        public FileAccessable createBySubpath(String subpath) {
            return new DeskFile(this.mFile.getAbsolutePath(), subpath);
        }

        @Override
        public FileAccessable createByExtension(String extensionName) {
            return new DeskFile(String.valueOf(this.mFile.getAbsolutePath()) + extensionName);
        }
    }

    public static class Factory {
        private static HashMap<String, WeakReference<ZipFile>> sZipFiles = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static FileAccessable create(String root, String subpath) throws IOException {
            ZipFile zipFile;
            if (new File(root).isDirectory()) {
                return new DeskFile(root, subpath);
            }
            HashMap<String, WeakReference<ZipFile>> hashMap = sZipFiles;
            synchronized (hashMap) {
                WeakReference<ZipFile> zipFileRef = sZipFiles.get(root);
                ZipFile zipFile2 = zipFile = zipFileRef == null ? null : (ZipFile)zipFileRef.get();
                if (zipFile == null) {
                    try {
                        zipFile = new ZipFile(root);
                        sZipFiles.put(root, new WeakReference<ZipFile>(zipFile));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return new ZipInnerFile(zipFile, subpath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void clearCache() {
            HashMap<String, WeakReference<ZipFile>> hashMap = sZipFiles;
            synchronized (hashMap) {
                sZipFiles.clear();
            }
        }
    }

    public static interface FileAccessableFilter {
        public boolean accept(FileAccessable var1);
    }

    public static class ZipInnerFile
    extends AbstractFileAccessable {
        ZipFile mZipFile;
        String mEntryName;
        boolean mIsFolder;
        boolean mExists;

        public ZipInnerFile(ZipFile zipFile, String entryName) {
            this.init(zipFile, entryName);
        }

        private void init(ZipFile zipFile, String entryName) {
            this.mZipFile = zipFile;
            String string = this.mEntryName = entryName.endsWith("/") ? entryName.substring(0, entryName.length() - 1) : entryName;
            if (this.mZipFile == null) {
                return;
            }
            ZipEntry zipEntry = zipFile.getEntry(entryName);
            if (zipEntry == null) {
                String folder = entryName;
                if (!folder.endsWith("/")) {
                    folder = String.valueOf(folder) + "/";
                }
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().startsWith(folder)) continue;
                    this.mExists = true;
                    this.mIsFolder = true;
                    break;
                }
            } else {
                this.mExists = true;
                this.mIsFolder = zipEntry.isDirectory();
            }
        }

        @Override
        public boolean exists() {
            return this.mExists;
        }

        @Override
        public boolean isFile() {
            return !this.mIsFolder;
        }

        @Override
        public List<FileAccessable> list() {
            if (!this.mExists || !this.mIsFolder) {
                return null;
            }
            Enumeration<? extends ZipEntry> entries = this.mZipFile.entries();
            ArrayList<FileAccessable> returnList = new ArrayList<FileAccessable>();
            HashSet<String> setForQuickCheck = new HashSet<String>();
            while (entries.hasMoreElements()) {
                String currEntryFolder = String.valueOf(this.mEntryName) + '/';
                ZipEntry entry = entries.nextElement();
                if (entry.getName().length() <= currEntryFolder.length() || !entry.getName().startsWith(currEntryFolder)) continue;
                String subpath = entry.getName().substring(currEntryFolder.length());
                String name = entry.getName();
                int index = subpath.indexOf(47);
                if (index != -1) {
                    String folderName = subpath.substring(0, index);
                    name = String.valueOf(currEntryFolder) + folderName;
                }
                if (setForQuickCheck.contains(name)) continue;
                returnList.add(new ZipInnerFile(this.mZipFile, name));
                setForQuickCheck.add(name);
            }
            return returnList;
        }

        @Override
        public InputStream getInputStream() {
            if (!this.mExists || this.mIsFolder) {
                return null;
            }
            ZipEntry zipEntry = this.mZipFile.getEntry(this.mEntryName);
            try {
                return this.mZipFile.getInputStream(zipEntry);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public String getName() {
            int separatorIndex = this.mEntryName.lastIndexOf(47);
            return separatorIndex < 0 ? this.mEntryName : this.mEntryName.substring(separatorIndex + 1, this.mEntryName.length());
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ZipInnerFile)) {
                return false;
            }
            ZipInnerFile target = (ZipInnerFile)o;
            if (!ZipInnerFile.objectEquals(this.mZipFile, target.mZipFile)) {
                return false;
            }
            return ZipInnerFile.objectEquals(this.mEntryName, target.mEntryName);
        }

        public int hashCode() {
            if (this.mZipFile == null) {
                return this.mEntryName.hashCode();
            }
            return this.mZipFile.hashCode() ^ this.mEntryName.hashCode();
        }

        private static boolean objectEquals(Object obj1, Object obj2) {
            if (obj1 == obj2) {
                return true;
            }
            if (obj1 == null) {
                return false;
            }
            return obj1.equals(obj2);
        }

        @Override
        public FileAccessable createBySubpath(String subpath) {
            return new ZipInnerFile(this.mZipFile, String.valueOf(this.mEntryName) + "/" + subpath);
        }

        @Override
        public FileAccessable createByExtension(String extensionName) {
            return new ZipInnerFile(this.mZipFile, String.valueOf(this.mEntryName) + extensionName);
        }
    }
}

