/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.extended.drag.FileDropHandler;
import com.alee.extended.filechooser.PathFieldListener;
import com.alee.extended.filefilter.DefaultFileFilter;
import com.alee.extended.filefilter.GroupType;
import com.alee.extended.filefilter.GroupedFileFilter;
import com.alee.extended.layout.HorizontalFlowLayout;
import com.alee.laf.GlobalConstants;
import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.button.WebToggleButton;
import com.alee.laf.list.WebList;
import com.alee.laf.list.WebListCellRenderer;
import com.alee.laf.menu.WebMenuItem;
import com.alee.laf.menu.WebPopupMenu;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.text.WebTextField;
import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class WebPathField
extends WebPanel {
    private static final ImageIcon down = new ImageIcon(WebPathField.class.getResource("icons/down.png"));
    private static final ImageIcon left = new ImageIcon(WebPathField.class.getResource("icons/left.png"));
    private static final ImageIcon right = new ImageIcon(WebPathField.class.getResource("icons/right.png"));
    private static final ImageIcon COMPUTER_ICON = new ImageIcon(WebPathField.class.getResource("icons/computer.png"));
    private static final String FILE_ICON = "fileIcon";
    private List<PathFieldListener> listeners = new ArrayList<PathFieldListener>();
    private boolean focusOwner = false;
    private static FileSystemView fsv = FileSystemView.getFileSystemView();
    private boolean showHiddenFiles = StyleConstants.showHiddenFiles;
    private DefaultFileFilter fileFilter = GlobalConstants.DIRECTORIES_FILTER;
    private DefaultFileFilter nonHiddenFileFilter = new GroupedFileFilter(GroupType.AND, GlobalConstants.DIRECTORIES_FILTER, GlobalConstants.NON_HIDDEN_ONLY_FILTER);
    private int preferredWidth = -1;
    private boolean filesDropEnabled = true;
    private File selectedPath;
    private boolean autocompleteEnabled = true;
    private JWindow autocompleteDialog = null;
    private WebPanel contentPanel;
    private WebTextField pathField;
    private FocusAdapter pathFocusListener;
    private WebButton myComputer = null;
    private int rootsMenuItemsCount = 0;
    private WebPopupMenu rootsMenu = null;
    private WebToggleButton rootsArrowButton = null;

    public WebPathField() {
        this(FileUtils.getDiskRoots()[0]);
    }

    public WebPathField(String string) {
        this(new File(string));
    }

    public WebPathField(File file) {
        super(true);
        this.setMargin(-1);
        this.setOpaque(false);
        this.setWebColored(false);
        this.setDrawFocus(true);
        this.setBackground(Color.WHITE);
        this.setTransferHandler(new FileDropHandler(){

            @Override
            protected boolean isDropEnabled() {
                return WebPathField.this.filesDropEnabled;
            }

            @Override
            protected boolean filesImported(List<File> list) {
                DefaultFileFilter defaultFileFilter = WebPathField.this.getFileFilter();
                for (File file : list) {
                    File file2;
                    File file3 = file2 = file.isDirectory() ? file : file.getParentFile();
                    if (defaultFileFilter != null && !defaultFileFilter.accept(file2)) continue;
                    WebPathField.this.folderSelected(file2);
                    return true;
                }
                return false;
            }
        });
        this.contentPanel = new WebPanel();
        this.contentPanel.setOpaque(false);
        this.contentPanel.setLayout(new HorizontalFlowLayout(0, true));
        this.add((Component)this.contentPanel, (Object)"Center");
        this.pathField = WebTextField.createWebTextField(false);
        this.pathField.setMargin(2);
        this.pathField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WebPathField.this.autocompleteDialog == null || !WebPathField.this.autocompleteDialog.isVisible()) {
                    if (WebPathField.this.pathField.getText().trim().equals("")) {
                        WebPathField.this.folderSelected(null);
                    } else {
                        File file = new File(WebPathField.this.pathField.getText());
                        if (file.exists() && file.isDirectory()) {
                            WebPathField.this.folderSelected(file);
                        } else {
                            WebPathField.this.updatePath(WebPathField.this.selectedPath);
                        }
                    }
                    WebPathField.this.transferFocus();
                }
            }
        });
        this.pathField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if ((WebPathField.this.autocompleteDialog == null || !WebPathField.this.autocompleteDialog.isVisible()) && Hotkey.ESCAPE.isTriggered(keyEvent)) {
                    if (WebPathField.this.selectedPath == null && WebPathField.this.pathField.getText().trim().equals("") || WebPathField.this.selectedPath != null && WebPathField.this.selectedPath.getAbsolutePath().equals(WebPathField.this.pathField.getText())) {
                        WebPathField.this.updatePath(WebPathField.this.selectedPath);
                        WebPathField.this.transferFocus();
                    } else {
                        WebPathField.this.pathField.setText(WebPathField.this.selectedPath.getAbsolutePath());
                    }
                }
            }
        });
        this.pathFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (WebPathField.this.selectedPath == null && WebPathField.this.pathField.getText().trim().equals("") || WebPathField.this.selectedPath != null && WebPathField.this.selectedPath.getAbsolutePath().equals(WebPathField.this.pathField.getText())) {
                    WebPathField.this.updatePath(WebPathField.this.selectedPath);
                }
            }
        };
        this.pathField.addCaretListener(new CaretListener(){
            private WebList list = null;
            private WebScrollPane listScroll;

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                String string;
                int n;
                if (!(WebPathField.this.autocompleteEnabled && WebPathField.this.pathField.isVisible() && WebPathField.this.pathField.isShowing())) {
                    if (WebPathField.this.autocompleteDialog != null && WebPathField.this.autocompleteDialog.isVisible()) {
                        this.hideDialog();
                    }
                    return;
                }
                if (WebPathField.this.autocompleteDialog == null) {
                    WebPathField.this.autocompleteDialog = new JWindow(SwingUtils.getWindowAncestor(WebPathField.this));
                    WebPathField.this.autocompleteDialog.getContentPane().setLayout(new BorderLayout());
                    WebPathField.this.autocompleteDialog.setFocusable(false);
                    SwingUtils.getWindowAncestor(WebPathField.this).addComponentListener(new ComponentAdapter(){

                        @Override
                        public void componentMoved(ComponentEvent componentEvent) {
                            this.hideDialog();
                        }

                        @Override
                        public void componentResized(ComponentEvent componentEvent) {
                            this.hideDialog();
                        }
                    });
                    this.list = new WebList();
                    this.list.setFocusable(false);
                    this.list.setSelectionMode(0);
                    this.list.setRolloverSelectionEnabled(true);
                    this.list.setCellRenderer(new WebListCellRenderer(){

                        @Override
                        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                            JLabel jLabel = (JLabel)super.getListCellRendererComponent(jList, object, n, bl, bl2);
                            jLabel.setIcon(FileUtils.getFileIcon((File)object));
                            jLabel.setText(FileUtils.getDisplayFileName((File)object));
                            return jLabel;
                        }
                    });
                    this.list.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent mouseEvent) {
                            int n = list.getUI().locationToIndex(list, mouseEvent.getPoint());
                            if (SwingUtilities.isLeftMouseButton(mouseEvent) && n != -1) {
                                this.setSelectedPath((File)list.getModel().getElementAt(n));
                            }
                        }
                    });
                    this.list.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyPressed(KeyEvent keyEvent) {
                            if (Hotkey.ENTER.isTriggered(keyEvent)) {
                                this.setSelectedPath((File)list.getSelectedValue());
                            }
                        }
                    });
                    this.listScroll = new WebScrollPane(this.list);
                    this.listScroll.setShadeWidth(0);
                    WebPathField.this.autocompleteDialog.getContentPane().add((Component)this.listScroll, "Center");
                    WebPathField.this.pathField.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyPressed(KeyEvent keyEvent) {
                            if (WebPathField.this.autocompleteDialog.isShowing() && list.getModel().getSize() > 0) {
                                if (list.getSelectedIndex() != -1) {
                                    if (Hotkey.ESCAPE.isTriggered(keyEvent) || Hotkey.F2.isTriggered(keyEvent) || Hotkey.CTRL_ENTER.isTriggered(keyEvent)) {
                                        this.hideDialog();
                                    } else if (Hotkey.ENTER.isTriggered(keyEvent)) {
                                        this.setSelectedPath((File)list.getSelectedValue());
                                    } else if (Hotkey.UP.isTriggered(keyEvent)) {
                                        if (list.getSelectedIndex() == 0) {
                                            list.setSelectedIndex(list.getModel().getSize() - 1);
                                            this.scrollToSelected();
                                        } else {
                                            list.setSelectedIndex(list.getSelectedIndex() - 1);
                                            this.scrollToSelected();
                                        }
                                    } else if (Hotkey.DOWN.isTriggered(keyEvent)) {
                                        if (list.getSelectedIndex() == list.getModel().getSize() - 1) {
                                            list.setSelectedIndex(0);
                                            this.scrollToSelected();
                                        } else {
                                            list.setSelectedIndex(list.getSelectedIndex() + 1);
                                            this.scrollToSelected();
                                        }
                                    }
                                } else {
                                    list.setSelectedIndex(0);
                                    this.scrollToSelected();
                                }
                            }
                        }

                        private void scrollToSelected() {
                            list.scrollRectToVisible(list.getUI().getCellBounds(list, list.getSelectedIndex(), list.getSelectedIndex()));
                        }
                    });
                    WebPathField.this.pathField.addFocusListener(new FocusAdapter(){

                        @Override
                        public void focusLost(FocusEvent focusEvent) {
                            this.hideDialog();
                        }
                    });
                }
                n = (n = (string = WebPathField.this.pathField.getText().substring(0, WebPathField.this.pathField.getCaretPosition())).lastIndexOf(File.separator)) != -1 ? n + 1 : 0;
                String string2 = string.substring(0, n);
                File file = string2.trim().equals("") ? null : new File(string2);
                try {
                    List list = WebPathField.this.getSimilarFileChilds(file, string.substring(n));
                    if (list != null && list.size() > 0) {
                        this.updateList(list, ((WebPathField)WebPathField.this).pathField.getUI().modelToView((JTextComponent)((WebPathField)WebPathField.this).pathField, (int)n).x);
                    } else {
                        this.hideDialog();
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }

            private void updateList(final List<File> list, int n) {
                SwingUtils.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        list.setModel(new AbstractListModel(){

                            @Override
                            public int getSize() {
                                return list.size();
                            }

                            @Override
                            public Object getElementAt(int n) {
                                return list.get(n);
                            }
                        });
                        list.setVisibleRowCount(Math.min(list.size(), 6));
                        list.updateUI();
                        if (list.size() > 0) {
                            list.setSelectedIndex(0);
                        }
                        Point point = WebPathField.this.pathField.getLocationOnScreen();
                        WebPathField.this.autocompleteDialog.setSize(WebPathField.this.pathField.getWidth(), (this).listScroll.getPreferredSize().height);
                        WebPathField.this.autocompleteDialog.setLocation(WebPathField.this.pathField.getComponentOrientation().isLeftToRight() ? point.x : point.x + WebPathField.this.pathField.getWidth() - WebPathField.this.autocompleteDialog.getWidth(), point.y + WebPathField.this.pathField.getHeight());
                        if (!WebPathField.this.autocompleteDialog.isShowing()) {
                            WebPathField.this.autocompleteDialog.setVisible(true);
                            WebPathField.this.transferFocus();
                        }
                    }
                });
            }

            private void hideDialog() {
                SwingUtils.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WebPathField.this.autocompleteDialog.setVisible(false);
                    }
                });
            }

            private void setSelectedPath(File file) {
                String string = file.getAbsolutePath();
                string = string.endsWith(File.separator) ? string : string + File.separator;
                WebPathField.this.pathField.setText(string);
                WebPathField.this.pathField.setCaretPosition(string.length());
            }
        });
        this.contentPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    WebPathField.this.startEditing();
                }
            }
        });
        HotkeyManager.registerHotkey((Component)this, (Component)this, Hotkey.F2, new HotkeyRunnable(){

            @Override
            public void run(KeyEvent keyEvent) {
                WebPathField.this.startEditing();
            }
        }, true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (!WebPathField.this.pathField.isShowing()) {
                    WebPathField.this.updatePath(WebPathField.this.selectedPath);
                }
            }
        });
        FocusManager.registerFocusTracker(new DefaultFocusTracker(this){

            @Override
            public void focusChanged(boolean bl) {
                WebPathField.this.focusOwner = bl;
                WebPathField.this.repaint();
            }
        });
        this.updatePath(file);
    }

    private void startEditing() {
        if (!this.pathField.isFocusOwner()) {
            this.pathField.setPreferredSize(new Dimension(1, this.contentPanel.getHeight()));
            this.contentPanel.removeAll();
            if (this.selectedPath != null) {
                String string = this.selectedPath.getAbsolutePath();
                string = string.endsWith(File.separator) ? string : string + File.separator;
                this.pathField.setText(string);
            } else {
                this.pathField.setText("");
            }
            this.pathField.selectAll();
            this.contentPanel.add((Component)this.pathField);
            this.contentPanel.revalidate();
            this.contentPanel.repaint();
            this.transferFocus();
        }
    }

    public boolean isEditing() {
        return this.pathField.isFocusOwner();
    }

    public boolean isAutocompleteEnabled() {
        return this.autocompleteEnabled;
    }

    public void setAutocompleteEnabled(boolean bl) {
        this.autocompleteEnabled = bl;
    }

    public DefaultFileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(DefaultFileFilter defaultFileFilter) {
        this.setFileFilter(defaultFileFilter, true);
    }

    public void setFileFilter(DefaultFileFilter defaultFileFilter, boolean bl) {
        this.fileFilter = defaultFileFilter;
        DefaultFileFilter defaultFileFilter2 = this.nonHiddenFileFilter = defaultFileFilter != null ? new GroupedFileFilter(GroupType.AND, defaultFileFilter, GlobalConstants.NON_HIDDEN_ONLY_FILTER) : GlobalConstants.NON_HIDDEN_ONLY_FILTER;
        if (bl) {
            this.updatePath(this.getSelectedPath());
        }
    }

    public boolean isShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    public void setShowHiddenFiles(boolean bl) {
        this.showHiddenFiles = bl;
    }

    public boolean isFilesDropEnabled() {
        return this.filesDropEnabled;
    }

    public void setFilesDropEnabled(boolean bl) {
        this.filesDropEnabled = bl;
    }

    public File getSelectedPath() {
        return this.selectedPath;
    }

    public void setSelectedPath(File file) {
        this.updatePath(file);
    }

    public WebTextField getPathField() {
        return this.pathField;
    }

    private void updatePath(File file) {
        Serializable serializable;
        Serializable serializable2;
        boolean bl = this.focusOwner;
        this.selectedPath = file;
        this.pathField.removeFocusListener(this.pathFocusListener);
        this.contentPanel.removeAll();
        boolean bl2 = this.getComponentOrientation().isLeftToRight();
        if (SystemUtils.isWindows()) {
            serializable2 = this.getMyComputer();
            this.contentPanel.add((Component)serializable2);
            this.contentPanel.add((Component)this.getRootsArrowButton(bl2));
        }
        if (this.selectedPath != null) {
            serializable2 = new File(this.selectedPath.getAbsolutePath());
            serializable = new ArrayList<Serializable>();
            serializable.add(0, serializable2);
            while (((File)serializable2).getParent() != null) {
                serializable2 = ((File)serializable2).getParentFile();
                serializable.add(0, serializable2);
            }
            boolean bl3 = true;
            Iterator iterator = serializable.iterator();
            while (iterator.hasNext()) {
                File file2;
                final File file3 = file2 = (File)iterator.next();
                WebButton webButton = new WebButton();
                webButton.setRound(!SystemUtils.isWindows() && bl3 ? StyleConstants.smallRound : 0);
                webButton.setShadeWidth(0);
                webButton.setLeftRightSpacing(0);
                webButton.setRolloverDecoratedOnly(true);
                webButton.setRolloverDarkBorderOnly(false);
                webButton.setFocusable(false);
                if (!SystemUtils.isWindows() && bl3) {
                    webButton.setIcon(COMPUTER_ICON);
                    webButton.putClientProperty(FILE_ICON, COMPUTER_ICON);
                } else {
                    webButton.setText(fsv.getSystemDisplayName(file3));
                    webButton.putClientProperty(FILE_ICON, FileUtils.getFileIcon(file3, false));
                }
                webButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        WebPathField.this.folderSelected(file3);
                    }
                });
                this.contentPanel.add((Component)webButton);
                int n = 0;
                final WebPopupMenu webPopupMenu = new WebPopupMenu();
                File[] fileArray = FileUtils.sortFiles(this.getFileChilds(file3));
                if (fileArray != null) {
                    for (final File file4 : fileArray) {
                        if (!file4.isDirectory()) continue;
                        WebMenuItem webMenuItem = new WebMenuItem(FileUtils.getDisplayFileName(file4));
                        webMenuItem.setIcon(FileUtils.getFileIcon(file4, false));
                        webMenuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                WebPathField.this.folderSelected(file4);
                            }
                        });
                        webPopupMenu.add(webMenuItem);
                        ++n;
                    }
                }
                if (!SystemUtils.isWindows() && bl3) {
                    this.setRootsMenu(webPopupMenu, n);
                }
                final WebToggleButton webToggleButton = new WebToggleButton();
                webToggleButton.setIcon(bl2 ? right : left);
                webToggleButton.setSelectedIcon(down);
                webToggleButton.setShadeToggleIcon(false);
                webToggleButton.setRound(0);
                webToggleButton.setShadeWidth(0);
                webToggleButton.setRolloverDecoratedOnly(true);
                webToggleButton.setRolloverDarkBorderOnly(false);
                webToggleButton.setFocusable(false);
                webToggleButton.setComponentPopupMenu(webPopupMenu);
                webToggleButton.setMargin(0);
                webToggleButton.setLeftRightSpacing(0);
                webToggleButton.setEnabled(n > 0);
                webToggleButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        WebPathField.this.transferFocus();
                        SwingUtils.applyOrientation(webPopupMenu);
                        webPopupMenu.show(webToggleButton, webToggleButton.getComponentOrientation().isLeftToRight() ? 0 : webToggleButton.getWidth() - webPopupMenu.getPreferredSize().width, webToggleButton.getHeight());
                    }
                });
                this.contentPanel.add((Component)webToggleButton);
                webPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                        webToggleButton.setSelected(false);
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                        webToggleButton.setSelected(false);
                    }
                });
                bl3 = false;
            }
        }
        this.contentPanel.add((Component)new JLabel());
        if (!SystemUtils.isWindows()) {
            while (this.getRootsMenu().getComponentCount() > this.getRootsMenuItemsCount()) {
                this.getRootsMenu().remove(0);
            }
        }
        if (this.canShortenPath()) {
            this.getRootsMenu().add((Component)new JPopupMenu.Separator(), 0);
        }
        while (this.canShortenPath()) {
            serializable2 = (WebButton)this.contentPanel.getComponent(2);
            serializable = new WebMenuItem();
            ((AbstractButton)serializable).setIcon((Icon)((JComponent)serializable2).getClientProperty(FILE_ICON));
            ((AbstractButton)serializable).setText(((AbstractButton)serializable2).getText());
            ((AbstractButton)serializable).addActionListener(((AbstractButton)serializable2).getActionListeners()[0]);
            this.getRootsMenu().add((Component)serializable, 0);
            this.contentPanel.remove(2);
            this.contentPanel.remove(2);
        }
        this.revalidate();
        this.repaint();
        this.transferFocus();
    }

    private List<File> getSimilarFileChilds(File file, String string) {
        String string2 = string.toLowerCase();
        File[] fileArray = this.getFileChilds(file);
        ArrayList<File> arrayList = new ArrayList<File>();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (!file2.getName().toLowerCase().contains(string2)) continue;
                arrayList.add(file2);
            }
        }
        return arrayList;
    }

    private File[] getFileChilds(File file) {
        return file != null ? file.listFiles(this.showHiddenFiles ? this.fileFilter : this.nonHiddenFileFilter) : FileUtils.getDiskRoots();
    }

    private boolean canShortenPath() {
        return this.contentPanel.getPreferredSize().width > this.contentPanel.getWidth() && this.contentPanel.getComponentCount() > 5;
    }

    private WebButton getMyComputer() {
        if (this.myComputer == null) {
            this.myComputer = WebButton.createIconWebButton(COMPUTER_ICON);
            this.myComputer.setRound(this.getRound());
            this.myComputer.setShadeWidth(0);
            this.myComputer.setLeftRightSpacing(0);
            this.myComputer.setRolloverDecoratedOnly(true);
            this.myComputer.setRolloverDarkBorderOnly(false);
            this.myComputer.setDrawFocus(false);
            this.myComputer.setDrawRight(false);
            this.myComputer.setDrawRightLine(true);
            this.myComputer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WebPathField.this.folderSelected(null);
                }
            });
        }
        return this.myComputer;
    }

    public WebPopupMenu getRootsMenu() {
        return this.rootsMenu;
    }

    public int getRootsMenuItemsCount() {
        return this.rootsMenuItemsCount;
    }

    public void setRootsMenu(WebPopupMenu webPopupMenu, int n) {
        this.rootsMenu = webPopupMenu;
        this.rootsMenuItemsCount = n;
    }

    private WebToggleButton getRootsArrowButton(boolean bl) {
        if (this.rootsArrowButton == null) {
            this.rootsMenu = new WebPopupMenu();
            File[] fileArray = FileUtils.getDiskRoots();
            for (final File file : FileUtils.sortFiles(fileArray)) {
                WebMenuItem webMenuItem = new WebMenuItem(FileUtils.getDisplayFileName(file));
                webMenuItem.setIcon(FileUtils.getFileIcon(file, false));
                webMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        WebPathField.this.folderSelected(file);
                    }
                });
                this.rootsMenu.add(webMenuItem);
                ++this.rootsMenuItemsCount;
            }
            this.rootsArrowButton = new WebToggleButton();
            this.rootsArrowButton.setIcon(bl ? right : left);
            this.rootsArrowButton.setSelectedIcon(down);
            this.rootsArrowButton.setShadeToggleIcon(false);
            this.rootsArrowButton.setRound(0);
            this.rootsArrowButton.setShadeWidth(0);
            this.rootsArrowButton.setRolloverDecoratedOnly(true);
            this.rootsArrowButton.setRolloverDarkBorderOnly(false);
            this.rootsArrowButton.setFocusable(false);
            this.rootsArrowButton.setMargin(0);
            this.rootsArrowButton.setLeftRightSpacing(0);
            this.rootsArrowButton.setComponentPopupMenu(this.rootsMenu);
            this.rootsArrowButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WebPathField.this.transferFocus();
                    SwingUtils.applyOrientation(WebPathField.this.rootsMenu);
                    WebPathField.this.rootsMenu.show(WebPathField.this.rootsArrowButton, WebPathField.this.rootsArrowButton.getComponentOrientation().isLeftToRight() ? 0 : WebPathField.this.rootsArrowButton.getWidth() - ((WebPathField)WebPathField.this).rootsMenu.getPreferredSize().width, WebPathField.this.rootsArrowButton.getHeight());
                }
            });
            this.rootsMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    WebPathField.this.rootsArrowButton.setSelected(false);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    WebPathField.this.rootsArrowButton.setSelected(false);
                }
            });
        } else {
            this.rootsArrowButton.setIcon(bl ? right : left);
        }
        while (this.rootsMenu.getComponentCount() > this.rootsMenuItemsCount) {
            this.rootsMenu.remove(0);
        }
        return this.rootsArrowButton;
    }

    private void folderSelected(File file) {
        file = FileUtils.normalize(file);
        this.updatePath(file);
        this.fireDirectoryChanged(file);
    }

    public void addWebPathFieldListener(PathFieldListener pathFieldListener) {
        this.listeners.add(pathFieldListener);
    }

    public void removeWebPathFieldListener(PathFieldListener pathFieldListener) {
        this.listeners.remove(pathFieldListener);
    }

    private void fireDirectoryChanged(File file) {
        for (PathFieldListener pathFieldListener : CollectionUtils.copy(this.listeners)) {
            pathFieldListener.directoryChanged(file);
        }
    }

    @Override
    public void setPreferredWidth(int n) {
        this.preferredWidth = n;
    }

    @Override
    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        super.applyComponentOrientation(componentOrientation);
        this.updatePath(this.selectedPath);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.preferredWidth != -1) {
            dimension.width = this.preferredWidth;
        }
        return dimension;
    }
}

