/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class BreadcrumbLayout
implements LayoutManager {
    private int overlap;

    public BreadcrumbLayout() {
        this(0);
    }

    public BreadcrumbLayout(int n) {
        this.overlap = n;
    }

    public int getOverlap() {
        return this.overlap;
    }

    public void setOverlap(int n) {
        this.overlap = n;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Dimension dimension2 = container.getComponent(i).getPreferredSize();
            dimension.width = dimension.width + (dimension2.width - (i < container.getComponentCount() - 1 ? this.overlap : 0));
            dimension.height = Math.max(dimension.height, insets.top + dimension2.height + insets.bottom);
        }
        return dimension;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        if (container.getComponentOrientation().isLeftToRight()) {
            int n = insets.left;
            for (Component component : container.getComponents()) {
                Dimension dimension = component.getPreferredSize();
                component.setBounds(n, insets.top, dimension.width, container.getHeight() - insets.top - insets.bottom);
                n += dimension.width - this.overlap;
            }
        } else {
            int n = container.getWidth() - insets.right;
            for (Component component : container.getComponents()) {
                Dimension dimension = component.getPreferredSize();
                component.setBounds(n - dimension.width, insets.top, dimension.width, container.getHeight() - insets.top - insets.bottom);
                n += this.overlap - dimension.width;
            }
        }
    }
}

