/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.painter;

import com.alee.extended.painter.BorderPainterStyle;
import com.alee.extended.painter.DefaultPainter;
import com.alee.utils.LafUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;

public class BorderPainter<E extends JComponent>
extends DefaultPainter<E> {
    protected int width = BorderPainterStyle.width;
    protected int round = BorderPainterStyle.round;
    protected Color color = BorderPainterStyle.color;
    protected Stroke stroke = null;

    public BorderPainter() {
        this.updateStroke();
    }

    public BorderPainter(int n) {
        this.setWidth(n);
    }

    public BorderPainter(Color color) {
        this.setColor(color);
        this.updateStroke();
    }

    public BorderPainter(int n, Color color) {
        this.setWidth(n);
        this.setColor(color);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
        this.updateStroke();
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int n) {
        this.round = n;
        this.updateStroke();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    protected void updateStroke() {
        this.stroke = new BasicStroke(this.getWidth(), 1, 1);
    }

    @Override
    public Dimension getPreferredSize(E e) {
        return new Dimension(Math.max(this.width * 2, this.round * 2), Math.max(this.width * 2, this.round * 2));
    }

    @Override
    public Insets getMargin(E e) {
        Insets insets = super.getMargin(e);
        return new Insets(insets.top + this.width, insets.left + this.width, insets.bottom + this.width, insets.right + this.width);
    }

    @Override
    public void paint(Graphics2D graphics2D, Rectangle rectangle, E e) {
        Object object = LafUtils.setupAntialias(graphics2D);
        Stroke stroke = LafUtils.setupStroke(graphics2D, this.stroke, this.stroke != null);
        graphics2D.setPaint(this.color);
        graphics2D.draw(this.getBorderShape(rectangle));
        LafUtils.restoreStroke(graphics2D, stroke, this.stroke != null);
        LafUtils.restoreAntialias(graphics2D, object);
    }

    protected RectangularShape getBorderShape(Rectangle rectangle) {
        double d;
        double d2 = d = this.width == 1 ? 0.0 : (double)this.width / 2.0;
        if (this.round > 0) {
            return new RoundRectangle2D.Double((double)rectangle.x + d, (double)rectangle.y + d, (double)rectangle.width - d * 2.0 - 1.0, (double)rectangle.height - d * 2.0 - 1.0, this.round * 2, this.round * 2);
        }
        return new Rectangle2D.Double((double)rectangle.x + d, (double)rectangle.y + d, (double)rectangle.width - d * 2.0 - 1.0, (double)rectangle.height - d * 2.0 - 1.0);
    }
}

