/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.statusbar;

import com.alee.extended.statusbar.WebMemoryBarStyle;
import com.alee.laf.StyleConstants;
import com.alee.laf.label.WebLabel;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.tooltip.TooltipWay;
import com.alee.managers.tooltip.WebCustomTooltip;
import com.alee.utils.FileUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.ComponentUpdater;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class WebMemoryBar
extends WebLabel
implements ShapeProvider {
    public static final String THREAD_NAME = "WebMemoryBar.updater";
    private ImageIcon memoryIcon = WebMemoryBarStyle.memoryIcon;
    private Color allocatedBorderColor = WebMemoryBarStyle.allocatedBorderColor;
    private Color allocatedDisabledBorderColor = WebMemoryBarStyle.allocatedDisabledBorderColor;
    private Color usedBorderColor = WebMemoryBarStyle.usedBorderColor;
    private Color usedFillColor = WebMemoryBarStyle.usedFillColor;
    public boolean drawBorder = WebMemoryBarStyle.drawBorder;
    public boolean fillBackground = WebMemoryBarStyle.fillBackground;
    private int leftRightSpacing = WebMemoryBarStyle.leftRightSpacing;
    private int shadeWidth = WebMemoryBarStyle.shadeWidth;
    private int round = WebMemoryBarStyle.round;
    private boolean allowGcAction = WebMemoryBarStyle.allowGcAction;
    private boolean showTooltip = WebMemoryBarStyle.showTooltip;
    private int tooltipDelay = WebMemoryBarStyle.tooltipDelay;
    private boolean showMaximumMemory = WebMemoryBarStyle.showMaximum;
    private int preferredWidth = -1;
    private long usedMemory = 0L;
    private long allocatedMemory = 0L;
    private long maxMemory = 0L;
    private int refreshRate = 1000;
    private ComponentUpdater updater = null;
    private boolean pressed = false;
    private WebCustomTooltip tooltip;
    private WebLabel tooltipLabel;

    public WebMemoryBar() {
        this.setOpaque(false);
        this.setFocusable(true);
        this.setHorizontalAlignment(0);
        this.updateBorder();
        this.tooltipLabel = new WebLabel(this.memoryIcon);
        this.updateTooltip();
        this.updateMemory();
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (WebMemoryBar.this.isEnabled() && (Hotkey.SPACE.isTriggered(keyEvent) || Hotkey.ENTER.isTriggered(keyEvent))) {
                    WebMemoryBar.this.pressed = true;
                    WebMemoryBar.this.repaint();
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (Hotkey.SPACE.isTriggered(keyEvent) || Hotkey.ENTER.isTriggered(keyEvent)) {
                    WebMemoryBar.this.pressed = false;
                    if (WebMemoryBar.this.isEnabled()) {
                        WebMemoryBar.this.doGC();
                    } else {
                        WebMemoryBar.this.repaint();
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (WebMemoryBar.this.allowGcAction && WebMemoryBar.this.isEnabled() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    WebMemoryBar.this.pressed = true;
                    WebMemoryBar.this.requestFocusInWindow();
                    WebMemoryBar.this.doGC();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (WebMemoryBar.this.pressed && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    WebMemoryBar.this.pressed = false;
                    WebMemoryBar.this.repaint();
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                WebMemoryBar.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                WebMemoryBar.this.repaint();
            }
        });
        this.updater = ComponentUpdater.install((JComponent)this, THREAD_NAME, (long)this.refreshRate, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebMemoryBar.this.updateMemory();
            }
        });
    }

    public void doGC() {
        System.gc();
        this.updateMemory();
    }

    private void updateBorder() {
        if (this.drawBorder) {
            this.setMargin(this.shadeWidth + 2, this.shadeWidth + 2 + this.leftRightSpacing, this.shadeWidth + 2, this.shadeWidth + 2 + this.leftRightSpacing);
        } else {
            this.setMargin(2, 2 + this.leftRightSpacing, 2, 2 + this.leftRightSpacing);
        }
    }

    protected void updateMemory() {
        MemoryUsage memoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        this.usedMemory = memoryUsage.getUsed();
        this.allocatedMemory = memoryUsage.getCommitted();
        this.maxMemory = memoryUsage.getMax();
        this.setText(this.getMemoryBarText());
        if (this.showTooltip) {
            this.tooltipLabel.setText(this.getMemoryBarTooltipText());
            this.tooltip.updateLocation();
        }
        this.repaint();
    }

    protected String getMemoryBarText() {
        long l = this.showMaximumMemory ? this.maxMemory : this.allocatedMemory;
        return FileUtils.getFileSizeString(this.usedMemory, this.getDigits(this.usedMemory)) + " " + LanguageManager.get("weblaf.ex.memorybar.of") + " " + FileUtils.getFileSizeString(l, this.getDigits(l));
    }

    protected String getMemoryBarTooltipText() {
        return "<html>" + LanguageManager.get("weblaf.ex.memorybar.alloc") + " <b>" + FileUtils.getFileSizeString(this.allocatedMemory, this.getDigits(this.allocatedMemory)) + "</b> " + LanguageManager.get("weblaf.ex.memorybar.used") + " <b>" + FileUtils.getFileSizeString(this.usedMemory, this.getDigits(this.usedMemory)) + this.getMaximumText() + "</b></html>";
    }

    private String getMaximumText() {
        if (this.showMaximumMemory) {
            return "</b> " + LanguageManager.get("weblaf.ex.memorybar.max") + " <b>" + FileUtils.getFileSizeString(this.maxMemory, this.getDigits(this.maxMemory));
        }
        return "";
    }

    private int getDigits(long l) {
        return l < 0x40000000L ? 0 : 2;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int n) {
        this.refreshRate = n;
        this.updater.setDelay(n);
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int n) {
        this.round = n;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int n) {
        this.shadeWidth = n;
        this.updateBorder();
    }

    public Color getAllocatedBorderColor() {
        return this.allocatedBorderColor;
    }

    public void setAllocatedBorderColor(Color color) {
        this.allocatedBorderColor = color;
    }

    public Color getAllocatedDisabledBorderColor() {
        return this.allocatedDisabledBorderColor;
    }

    public void setAllocatedDisabledBorderColor(Color color) {
        this.allocatedDisabledBorderColor = color;
    }

    public Color getUsedBorderColor() {
        return this.usedBorderColor;
    }

    public void setUsedBorderColor(Color color) {
        this.usedBorderColor = color;
    }

    public Color getUsedFillColor() {
        return this.usedFillColor;
    }

    public void setUsedFillColor(Color color) {
        this.usedFillColor = color;
    }

    public int getLeftRightSpacing() {
        return this.leftRightSpacing;
    }

    public void setLeftRightSpacing(int n) {
        this.leftRightSpacing = n;
        this.updateBorder();
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
        this.updateBorder();
    }

    public boolean isFillBackground() {
        return this.fillBackground;
    }

    public void setFillBackground(boolean bl) {
        this.fillBackground = bl;
    }

    public boolean isAllowGcAction() {
        return this.allowGcAction;
    }

    public void setAllowGcAction(boolean bl) {
        this.allowGcAction = bl;
        if (!bl && this.pressed) {
            this.pressed = false;
            this.repaint();
        }
    }

    public boolean isShowTooltip() {
        return this.showTooltip;
    }

    public void setShowTooltip(boolean bl) {
        this.showTooltip = bl;
        this.updateTooltip();
    }

    private void updateTooltip() {
        if (this.showTooltip) {
            this.tooltip = TooltipManager.setTooltip((Component)this, this.tooltipLabel, TooltipWay.up, this.tooltipDelay);
        } else {
            TooltipManager.removeTooltips(this.tooltipLabel);
        }
    }

    public long getAllocatedMemory() {
        return this.allocatedMemory;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public ImageIcon getMemoryIcon() {
        return this.memoryIcon;
    }

    public void setMemoryIcon(ImageIcon imageIcon) {
        this.memoryIcon = imageIcon;
    }

    public int getTooltipDelay() {
        return this.tooltipDelay;
    }

    public void setTooltipDelay(int n) {
        this.tooltipDelay = n;
    }

    public boolean isShowMaximumMemory() {
        return this.showMaximumMemory;
    }

    public void setShowMaximumMemory(boolean bl) {
        this.showMaximumMemory = bl;
    }

    @Override
    public Shape provideShape() {
        return LafUtils.getWebBorderShape(this, this.getShadeWidth(), this.getRound());
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = LafUtils.setupAntialias(graphics2D);
        boolean bl = this.isEnabled();
        if (this.drawBorder) {
            LafUtils.drawWebStyle(graphics2D, this, this.isFocusOwner() ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor, this.shadeWidth, this.round, this.fillBackground, !this.pressed);
        } else if (this.fillBackground) {
            graphics2D.setPaint(!this.pressed ? LafUtils.getWebGradientPaint(0, 0, 0, this.getHeight()) : this.getBackground());
            graphics2D.fill(this.getVisibleRect());
        }
        if (this.showMaximumMemory) {
            graphics2D.setPaint(bl ? this.allocatedBorderColor : this.allocatedDisabledBorderColor);
            int n = this.getProgressWidth(this.allocatedMemory, false);
            graphics2D.drawLine(this.shadeWidth + n, this.shadeWidth + 2, this.shadeWidth + n, this.getHeight() - this.shadeWidth - 3);
        }
        Composite composite = LafUtils.setupAlphaComposite(graphics2D, 0.5f, !bl);
        graphics2D.setPaint(this.usedFillColor);
        graphics2D.fill(this.getProgressShape(this.usedMemory, true));
        graphics2D.setPaint(this.usedBorderColor);
        graphics2D.draw(this.getProgressShape(this.usedMemory, false));
        LafUtils.restoreComposite(graphics2D, composite, !bl);
        LafUtils.restoreAntialias(graphics2D, object);
        super.paintComponent(graphics2D);
    }

    private Shape getProgressShape(long l, boolean bl) {
        int n = Math.max(0, this.round - 1) * 2;
        if (this.drawBorder) {
            return new RoundRectangle2D.Double(this.shadeWidth + 2, this.shadeWidth + 2, this.getProgressWidth(l, bl), this.getHeight() - 4 - this.shadeWidth * 2 - (bl ? 0 : 1), n, n);
        }
        return new RoundRectangle2D.Double(1.0, 1.0, this.getProgressWidth(l, bl), this.getHeight() - 2 - (bl ? 0 : 1), n, n);
    }

    private int getProgressWidth(long l, boolean bl) {
        return Math.round((float)(this.getWidth() - (this.drawBorder ? 4 + this.shadeWidth * 2 : 2) - (bl ? 0 : 1)) * (float)l / (float)(this.showMaximumMemory ? this.maxMemory : this.allocatedMemory));
    }

    public void setPreferredWidth(int n) {
        this.preferredWidth = n;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.preferredWidth != -1) {
            dimension.width = this.preferredWidth;
        }
        return dimension;
    }
}

