/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.transition.effects.blocks;

import com.alee.extended.transition.ImageTransition;
import com.alee.extended.transition.TransitionUtils;
import com.alee.extended.transition.effects.DefaultTransitionEffect;
import com.alee.extended.transition.effects.Direction;
import com.alee.extended.transition.effects.blocks.BlockType;
import com.alee.utils.LafUtils;
import com.alee.utils.MathUtils;
import com.alee.utils.swing.Timer;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;

public class BlocksTransitionEffect
extends DefaultTransitionEffect {
    private static final String BLOCK_TYPE = "BLOCK_TYPE";
    private static final String BLOCK_FADE = "BLOCK_FADE";
    private static final String BLOCK_SIZE = "BLOCK_SIZE";
    private static final String BLOCK_SPEED = "BLOCK_SPEED";
    private static final String BLOCK_AMOUNT = "BLOCK_AMOUNT";
    private int size;
    private int speed;
    private int blocksAmount;
    private boolean fade;
    private BlockType type;
    private Direction direction;
    private int[][] progress;
    private Shape clip;
    private List<Point> allPoints;
    private Timer randomizer;

    public BlockType getType() {
        return this.get(BLOCK_TYPE, BlockType.random);
    }

    public void setType(BlockType blockType) {
        this.put(BLOCK_TYPE, (Object)blockType);
    }

    public boolean isFade() {
        return this.get(BLOCK_FADE, true);
    }

    public void setFade(boolean bl) {
        this.put(BLOCK_FADE, bl);
    }

    public int getSize() {
        return this.get(BLOCK_SIZE, 80);
    }

    public void setSize(int n) {
        this.put(BLOCK_SIZE, n);
    }

    public int getSpeed() {
        return this.get(BLOCK_SPEED, 4);
    }

    public void setSpeed(int n) {
        this.put(BLOCK_SPEED, n);
    }

    public int getBlocksAmount() {
        return this.get(BLOCK_AMOUNT, 5);
    }

    public void setBlocksAmount(int n) {
        this.put(BLOCK_AMOUNT, n);
    }

    @Override
    public void prepareAnimation(final ImageTransition imageTransition) {
        int n;
        int n2;
        this.size = this.getSize();
        this.speed = this.getSpeed();
        this.blocksAmount = this.getBlocksAmount();
        this.fade = this.isFade();
        this.direction = TransitionUtils.getActualValue(this.getDirection());
        this.type = TransitionUtils.getActualValue(this.getType());
        int n3 = imageTransition.getHeight();
        n3 = n3 % this.size == 0 ? n3 : n3 / this.size * this.size + this.size;
        int n4 = imageTransition.getWidth();
        n4 = n4 % this.size == 0 ? n4 : n4 / this.size * this.size + this.size;
        int n5 = n4 / this.size;
        int n6 = n3 / this.size;
        this.progress = new int[n5][n6];
        for (n2 = 0; n2 < n5; ++n2) {
            for (n = 0; n < n6; ++n) {
                this.progress[n2][n] = 0;
            }
        }
        if (this.direction.equals((Object)Direction.right) || this.direction.equals((Object)Direction.down)) {
            this.progress[0][0] = this.speed;
        } else {
            this.progress[n5 - 1][n6 - 1] = this.speed;
        }
        if (!this.fade) {
            this.clip = this.getBlocksProgressShape(this.progress);
        }
        if (this.type.equals((Object)BlockType.randomize)) {
            this.allPoints = new ArrayList<Point>();
            for (n2 = 0; n2 < n5; ++n2) {
                for (n = 0; n < n6; ++n) {
                    this.allPoints.add(new Point(n2, n));
                }
            }
            if (this.randomizer != null) {
                this.randomizer.stop();
            }
            this.randomizer = new Timer("BlocksTransitionEffect.randomizer", 50L);
            this.randomizer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < BlocksTransitionEffect.this.blocksAmount; ++i) {
                        if (BlocksTransitionEffect.this.allPoints.size() > 0) {
                            int n = MathUtils.random(BlocksTransitionEffect.this.allPoints.size());
                            Point point = (Point)BlocksTransitionEffect.this.allPoints.remove(n);
                            int[] nArray = BlocksTransitionEffect.this.progress[point.x];
                            int n2 = point.y;
                            nArray[n2] = nArray[n2] + BlocksTransitionEffect.this.speed;
                            imageTransition.repaint();
                            continue;
                        }
                        BlocksTransitionEffect.this.randomizer.stop();
                    }
                }
            });
            this.randomizer.start();
        }
        imageTransition.repaint();
    }

    @Override
    public boolean performAnimation(ImageTransition imageTransition) {
        boolean bl = true;
        int n = this.progress.length;
        int n2 = this.progress[0].length;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (this.progress[i][j] >= this.size) continue;
                if (this.progress[i][j] > 0) {
                    int[] nArray = this.progress[i];
                    int n4 = j;
                    nArray[n4] = nArray[n4] + this.speed;
                    ++n3;
                } else if (this.type.equals((Object)BlockType.cascade) && this.canStartGrow(i, j, this.progress)) {
                    int[] nArray = this.progress[i];
                    int n5 = j;
                    nArray[n5] = nArray[n5] + this.speed;
                }
                if (!bl || this.progress[i][j] >= this.size) continue;
                bl = false;
            }
        }
        if (!this.fade) {
            this.clip = this.getBlocksProgressShape(this.progress);
        }
        if (!bl) {
            imageTransition.repaint();
            return false;
        }
        this.clip = null;
        if (this.randomizer != null) {
            this.randomizer.stop();
        }
        return true;
    }

    private Shape getBlocksProgressShape(int[][] nArray) {
        GeneralPath generalPath = new GeneralPath(0);
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length; ++j) {
                generalPath.append(new Rectangle(i * this.size, j * this.size, nArray[i][j], nArray[i][j]), false);
            }
        }
        return generalPath;
    }

    private boolean canStartGrow(int n, int n2, int[][] nArray) {
        if (this.direction.equals((Object)Direction.right) || this.direction.equals((Object)Direction.down)) {
            return n > 0 && (float)nArray[n - 1][n2] > (float)this.size / 6.0f || n2 > 0 && (float)nArray[n][n2 - 1] > (float)this.size / 6.0f || n > 1 && (float)nArray[n - 2][n2] > (float)this.size * 2.0f / 6.0f || n2 > 1 && (float)nArray[n][n2 - 2] > (float)this.size * 2.0f / 6.0f || n > 2 && (float)nArray[n - 3][n2] > (float)this.size * 3.0f / 6.0f || n2 > 2 && (float)nArray[n][n2 - 3] > (float)this.size * 3.0f / 6.0f || n > 3 && (float)nArray[n - 4][n2] > (float)this.size * 4.0f / 6.0f || n2 > 3 && (float)nArray[n][n2 - 4] > (float)this.size * 4.0f / 6.0f || n > 4 && (float)nArray[n - 5][n2] > (float)this.size * 5.0f / 6.0f || n2 > 4 && (float)nArray[n][n2 - 5] > (float)this.size * 5.0f / 6.0f;
        }
        return n < nArray.length - 1 && (float)nArray[n + 1][n2] > (float)this.size / 6.0f || n2 < nArray[0].length - 1 && (float)nArray[n][n2 + 1] > (float)this.size / 6.0f || n < nArray.length - 2 && (float)nArray[n + 2][n2] > (float)this.size * 2.0f / 6.0f || n2 < nArray[0].length - 2 && (float)nArray[n][n2 + 2] > (float)this.size * 2.0f / 6.0f || n < nArray.length - 3 && (float)nArray[n + 3][n2] > (float)this.size * 3.0f / 6.0f || n2 < nArray[0].length - 3 && (float)nArray[n][n2 + 3] > (float)this.size * 3.0f / 6.0f || n < nArray.length - 4 && (float)nArray[n + 4][n2] > (float)this.size * 4.0f / 6.0f || n2 < nArray[0].length - 4 && (float)nArray[n][n2 + 4] > (float)this.size * 4.0f / 6.0f || n < nArray.length - 5 && (float)nArray[n + 5][n2] > (float)this.size * 5.0f / 6.0f || n2 < nArray[0].length - 5 && (float)nArray[n][n2 + 5] > (float)this.size * 5.0f / 6.0f;
    }

    @Override
    public void paint(Graphics2D graphics2D, ImageTransition imageTransition) {
        int n = imageTransition.getWidth();
        int n2 = imageTransition.getHeight();
        graphics2D.drawImage(imageTransition.getCurrentImage(), 0, 0, n, n2, null);
        if (this.fade) {
            int n3 = this.progress.length;
            int n4 = this.progress[0].length;
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    int n5 = this.progress[i][j];
                    if (n5 <= 0) continue;
                    int n6 = i * this.size;
                    int n7 = j * this.size;
                    int n8 = Math.min(n - n6, this.size);
                    int n9 = Math.min(n2 - n7, this.size);
                    int n10 = n6 + n8;
                    int n11 = n7 + n9;
                    Composite composite = LafUtils.setupAlphaComposite(graphics2D, (float)n5 / (float)this.size, n5 < this.size);
                    graphics2D.drawImage(imageTransition.getOtherImage(), n6, n7, n10, n11, n6, n7, n10, n11, null);
                    LafUtils.restoreComposite(graphics2D, composite, n5 < this.size);
                }
            }
        } else {
            Shape shape = LafUtils.intersectClip(graphics2D, this.clip);
            graphics2D.drawImage(imageTransition.getOtherImage(), 0, 0, n, n2, null);
            LafUtils.restoreClip(graphics2D, shape);
        }
    }
}

