/*
 * Decompiled with CFR 0.152.
 */
package com.alee.graphics.filters;

import com.alee.graphics.filters.BoxBlurFilter;
import com.alee.graphics.filters.GaussianFilter;
import com.alee.graphics.filters.MotionBlurOp;
import com.alee.graphics.filters.OpacityFilter;
import com.alee.utils.ImageUtils;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;

public class ImageFilterUtils {
    private static ColorConvertOp grayscaleColorConvert = new ColorConvertOp(ColorSpace.getInstance(1003), null);

    public static BufferedImage applyBoxBlurFilter(Image image, Image image2, int n, int n2, int n3) {
        return ImageFilterUtils.applyBoxBlurFilter(ImageUtils.getBufferedImage(image), ImageUtils.getBufferedImage(image2), n, n2, n3);
    }

    public static BufferedImage applyBoxBlurFilter(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2, int n3) {
        return new BoxBlurFilter(n, n2, n3).filter(bufferedImage, bufferedImage2);
    }

    public static BufferedImage applyGrayscaleFilter(Image image, Image image2) {
        return ImageFilterUtils.applyGrayscaleFilter(ImageUtils.getBufferedImage(image), ImageUtils.getBufferedImage(image2));
    }

    public static BufferedImage applyGrayscaleFilter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        return grayscaleColorConvert.filter(bufferedImage, bufferedImage2);
    }

    public static BufferedImage applyGaussianFilter(Image image, Image image2, float f) {
        return ImageFilterUtils.applyGaussianFilter(ImageUtils.getBufferedImage(image), ImageUtils.getBufferedImage(image2), f);
    }

    public static BufferedImage applyGaussianFilter(BufferedImage bufferedImage, BufferedImage bufferedImage2, float f) {
        return new GaussianFilter(f).filter(bufferedImage, bufferedImage2);
    }

    public static BufferedImage applyZoomBlurFilter(Image image, Image image2, float f, float f2, float f3) {
        return ImageFilterUtils.applyZoomBlurFilter(ImageUtils.getBufferedImage(image), ImageUtils.getBufferedImage(image2), f, f2, f3);
    }

    public static BufferedImage applyZoomBlurFilter(BufferedImage bufferedImage, BufferedImage bufferedImage2, float f, float f2, float f3) {
        return new MotionBlurOp(0.0f, 0.0f, 0.0f, f, f2, f3).filter(bufferedImage, bufferedImage2);
    }

    public static BufferedImage applyRotationBlurFilter(Image image, Image image2, float f, float f2, float f3) {
        return ImageFilterUtils.applyRotationBlurFilter(ImageUtils.getBufferedImage(image), ImageUtils.getBufferedImage(image2), f, f2, f3);
    }

    public static BufferedImage applyRotationBlurFilter(BufferedImage bufferedImage, BufferedImage bufferedImage2, float f, float f2, float f3) {
        return new MotionBlurOp(0.0f, 0.0f, f, 0.0f, f2, f3).filter(bufferedImage, bufferedImage2);
    }

    public static BufferedImage applyMotionBlurFilter(Image image, Image image2, float f, float f2, float f3, float f4, float f5, float f6) {
        return ImageFilterUtils.applyMotionBlurFilter(ImageUtils.getBufferedImage(image), ImageUtils.getBufferedImage(image2), f, f2, f3, f4, f5, f6);
    }

    public static BufferedImage applyMotionBlurFilter(BufferedImage bufferedImage, BufferedImage bufferedImage2, float f, float f2, float f3, float f4, float f5, float f6) {
        return new MotionBlurOp(f, f2, f3, f4, f5, f6).filter(bufferedImage, bufferedImage2);
    }

    public static BufferedImage applyOpacityFilter(Image image, Image image2, int n) {
        return ImageFilterUtils.applyOpacityFilter(ImageUtils.getBufferedImage(image), ImageUtils.getBufferedImage(image2), n);
    }

    public static BufferedImage applyOpacityFilter(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n) {
        return new OpacityFilter(n).filter(bufferedImage, bufferedImage2);
    }
}

