/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.laf.WebLookAndFeel;
import com.alee.laf.tree.TreeSelectionStyle;
import com.alee.laf.tree.WebTreeUI;
import com.alee.utils.GeometryUtils;
import com.alee.utils.ReflectUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WebTree<E extends DefaultMutableTreeNode>
extends JTree {
    public static final int SINGLE_TREE_SELECTION = 1;
    public static final int CONTIGUOUS_TREE_SELECTION = 2;
    public static final int DISCONTIGUOUS_TREE_SELECTION = 4;

    public WebTree() {
    }

    public WebTree(Object[] objectArray) {
        super(objectArray);
    }

    public WebTree(Vector<?> vector) {
        super(vector);
    }

    public WebTree(Hashtable<?, ?> hashtable) {
        super(hashtable);
    }

    public WebTree(E e) {
        super((TreeNode)e);
    }

    public WebTree(E e, boolean bl) {
        super((TreeNode)e, bl);
    }

    public WebTree(TreeModel treeModel) {
        super(treeModel);
    }

    public void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public void expandNode(E e) {
        this.expandPath(this.getPathForNode(e));
    }

    public TreePath getPathForNode(E e) {
        if (e != null) {
            return new TreePath(((DefaultMutableTreeNode)e).getPath());
        }
        return null;
    }

    public E getNodeForPath(TreePath treePath) {
        if (treePath != null) {
            return (E)((DefaultMutableTreeNode)treePath.getLastPathComponent());
        }
        return null;
    }

    public List<E> getSelectedNodes() {
        ArrayList<E> arrayList = new ArrayList<E>();
        if (this.getSelectionPaths() != null) {
            for (TreePath treePath : this.getSelectionPaths()) {
                arrayList.add(this.getNodeForPath(treePath));
            }
        }
        return arrayList;
    }

    public void setSelectionMode(int n) {
        this.getSelectionModel().setSelectionMode(n);
    }

    public boolean isHighlightRolloverNode() {
        return this.getWebUI().isHighlightRolloverNode();
    }

    public void setHighlightRolloverNode(boolean bl) {
        this.getWebUI().setHighlightRolloverNode(bl);
    }

    public boolean isPaintLines() {
        return this.getWebUI().isPaintLines();
    }

    public void setPaintLines(boolean bl) {
        this.getWebUI().setPaintLines(bl);
    }

    public Color getLinesColor() {
        return this.getWebUI().getLinesColor();
    }

    public void setLinesColor(Color color) {
        this.getWebUI().setLinesColor(color);
    }

    public TreeSelectionStyle getSelectionStyle() {
        return this.getWebUI().getSelectionStyle();
    }

    public void setSelectionStyle(TreeSelectionStyle treeSelectionStyle) {
        this.getWebUI().setSelectionStyle(treeSelectionStyle);
    }

    public int getSelectionRound() {
        return this.getWebUI().getSelectionRound();
    }

    public void setSelectionRound(int n) {
        this.getWebUI().setSelectionRound(n);
    }

    public int getSelectionShadeWidth() {
        return this.getWebUI().getSelectionShadeWidth();
    }

    public void setSelectionShadeWidth(int n) {
        this.getWebUI().setSelectionShadeWidth(n);
    }

    public boolean isSelectorEnabled() {
        return this.getWebUI().isSelectorEnabled();
    }

    public void setSelectorEnabled(boolean bl) {
        this.getWebUI().setSelectorEnabled(bl);
    }

    public Color getSelectorColor() {
        return this.getWebUI().getSelectorColor();
    }

    public void setSelectorColor(Color color) {
        this.getWebUI().setSelectorColor(color);
    }

    public Color getSelectorBorderColor() {
        return this.getWebUI().getSelectorBorderColor();
    }

    public void setSelectorBorderColor(Color color) {
        this.getWebUI().setSelectorBorderColor(color);
    }

    public int getSelectorRound() {
        return this.getWebUI().getSelectorRound();
    }

    public void setSelectorRound(int n) {
        this.getWebUI().setSelectorRound(n);
    }

    public BasicStroke getSelectorStroke() {
        return this.getWebUI().getSelectorStroke();
    }

    public void setSelectorStroke(BasicStroke basicStroke) {
        this.getWebUI().setSelectorStroke(basicStroke);
    }

    public WebTreeUI getWebUI() {
        return (WebTreeUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebTreeUI)) {
            try {
                this.setUI((WebTreeUI)ReflectUtils.createInstance(WebLookAndFeel.treeUI, new Object[0]));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.setUI(new WebTreeUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    public void repaint(int n) {
        this.repaint(this.getWebUI().getRowBounds(n));
    }

    public void repaint(int n, int n2) {
        this.repaint(GeometryUtils.getContainingRect(this.getWebUI().getRowBounds(n), this.getWebUI().getRowBounds(n2)));
    }
}

