/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.extended.image.WebImage;
import com.alee.laf.checkbox.WebCheckBox;
import com.alee.laf.combobox.WebComboBox;
import com.alee.laf.text.WebTextField;
import com.alee.laf.tree.WebTreeStyle;
import com.alee.laf.tree.WebTreeUI;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;

public class WebTreeCellEditor
extends DefaultCellEditor {
    public WebTreeCellEditor() {
        this(new WebTextField());
    }

    public WebTreeCellEditor(WebTextField webTextField) {
        super(webTextField);
        webTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                WebTreeCellEditor.this.stopCellEditing();
            }
        });
    }

    public WebTreeCellEditor(WebCheckBox webCheckBox) {
        super(webCheckBox);
        webCheckBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                WebTreeCellEditor.this.stopCellEditing();
            }
        });
    }

    public WebTreeCellEditor(WebComboBox webComboBox) {
        super(webComboBox);
        webComboBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                WebTreeCellEditor.this.stopCellEditing();
            }
        });
    }

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        Component component = super.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
        Component component2 = jTree.getCellRenderer().getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, true);
        component.setPreferredSize(component2.getPreferredSize());
        if (component2 instanceof JLabel && ((JLabel)component2).getIcon() != null) {
            JLabel jLabel = (JLabel)component2;
            boolean bl4 = jTree.getComponentOrientation().isLeftToRight();
            if (component instanceof WebTextField) {
                TreeUI treeUI = jTree.getUI();
                int n2 = treeUI instanceof WebTreeUI ? ((WebTreeUI)treeUI).getSelectionShadeWidth() : WebTreeStyle.selectionShadeWidth;
                WebTextField webTextField = (WebTextField)component;
                webTextField.setDrawFocus(false);
                webTextField.setShadeWidth(n2);
                webTextField.setDrawShade(false);
                webTextField.setLeadingComponent(new WebImage(jLabel.getIcon()));
                int n3 = n2 + 1;
                Insets insets = jLabel.getInsets();
                webTextField.setMargin(insets.top - n3, insets.left - n3, insets.bottom - n3, insets.right - n3 - 2);
                webTextField.setFieldMargin(0, jLabel.getIconTextGap(), 0, 0);
            }
        }
        component.applyComponentOrientation(jTree.getComponentOrientation());
        return component;
    }
}

