/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.proxy;

import com.alee.utils.xml.PasswordConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.Serializable;

@XStreamAlias(value="ProxySettings")
public class ProxySettings
implements Serializable {
    @XStreamAsAttribute
    private boolean useProxy = false;
    @XStreamAsAttribute
    private String proxyHost = null;
    @XStreamAsAttribute
    private String proxyPort = null;
    @XStreamAsAttribute
    private String nonProxyHosts = null;
    @XStreamAsAttribute
    private boolean useProxyAuthentification = false;
    @XStreamAsAttribute
    private String proxyLogin = null;
    @XStreamAsAttribute
    @XStreamConverter(value=PasswordConverter.class)
    private String proxyPassword = null;

    public ProxySettings() {
        this(null, null);
    }

    public ProxySettings(String string, String string2) {
        this(string, string2, null, null);
    }

    public ProxySettings(String string, String string2, String string3, String string4) {
        if (string != null && string2 != null) {
            this.useProxy = true;
            this.proxyHost = string;
            this.proxyPort = string2;
            if (string3 != null && string4 != null) {
                this.useProxyAuthentification = true;
                this.proxyLogin = string3;
                this.proxyPassword = string4;
            } else {
                this.useProxyAuthentification = false;
            }
        } else {
            this.useProxy = false;
            this.useProxyAuthentification = false;
        }
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    public void setUseProxy(boolean bl) {
        this.useProxy = bl;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String string) {
        this.proxyHost = string;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public int getProxyPortInt() {
        try {
            return Integer.parseInt(this.proxyPort);
        }
        catch (Throwable throwable) {
            return 80;
        }
    }

    public void setProxyPort(String string) {
        this.proxyPort = string;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public void setNonProxyHosts(String string) {
        this.nonProxyHosts = string;
    }

    public boolean isUseProxyAuthentification() {
        return this.useProxyAuthentification;
    }

    public void setUseProxyAuthentification(boolean bl) {
        this.useProxyAuthentification = bl;
    }

    public String getProxyLogin() {
        return this.proxyLogin;
    }

    public void setProxyLogin(String string) {
        this.proxyLogin = string;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String string) {
        this.proxyPassword = string;
    }

    protected ProxySettings clone() {
        ProxySettings proxySettings = new ProxySettings();
        proxySettings.setUseProxy(this.isUseProxy());
        proxySettings.setProxyHost(this.getProxyHost());
        proxySettings.setProxyPort(this.getProxyPort());
        proxySettings.setNonProxyHosts(this.getNonProxyHosts());
        proxySettings.setUseProxyAuthentification(this.isUseProxyAuthentification());
        proxySettings.setProxyLogin(this.getProxyLogin());
        proxySettings.setProxyPassword(this.getProxyPassword());
        return proxySettings;
    }
}

