/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import java.awt.Color;
import java.util.StringTokenizer;

public class ColorUtils {
    public static Color removeAlpha(Color color) {
        if (color.getAlpha() != 255) {
            return new Color(color.getRGB(), false);
        }
        return color;
    }

    public static Color changeAlpha(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public static Color getIntermediateColor(Color color, Color color2, float f) {
        return new Color(ColorUtils.getIntermediateValue(color.getRed(), color2.getRed(), f), ColorUtils.getIntermediateValue(color.getGreen(), color2.getGreen(), f), ColorUtils.getIntermediateValue(color.getBlue(), color2.getBlue(), f), ColorUtils.getIntermediateValue(color.getAlpha(), color2.getAlpha(), f));
    }

    public static int getIntermediateValue(int n, int n2, float f) {
        return n + Math.round(((float)n2 - (float)n) * f);
    }

    public static Color getWebSafeColor(Color color) {
        return new Color(ColorUtils.getWebSafeValue(color.getRed()), ColorUtils.getWebSafeValue(color.getGreen()), ColorUtils.getWebSafeValue(color.getBlue()));
    }

    public static int getWebSafeValue(int n) {
        if (0 <= n && n <= 51) {
            return n > 51 - n ? 51 : 0;
        }
        if (51 <= n && n <= 102) {
            return 51 + n > 102 - n ? 102 : 51;
        }
        if (102 <= n && n <= 153) {
            return 102 + n > 153 - n ? 153 : 102;
        }
        if (153 <= n && n <= 204) {
            return 153 + n > 204 - n ? 204 : 153;
        }
        if (204 <= n && n <= 255) {
            return 204 + n > 255 - n ? 255 : 204;
        }
        return n;
    }

    public static String getHexColor(Color color) {
        return ColorUtils.getHexColor(color.getRGB());
    }

    public static String getHexColor(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        return string.substring(2, string.length());
    }

    public static Color parseHexColor(String string) {
        return Color.decode((string = string.replaceAll(" ", "")).startsWith("#") ? string : "#" + string);
    }

    public static Color parseRgbColor(String string) {
        return ColorUtils.parseRgbColor(string, ",");
    }

    public static Color parseRgbColor(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string = string.replaceAll(" ", ""), string2, false);
        int n = stringTokenizer.countTokens();
        if (n == 3) {
            return new Color(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
        }
        if (n == 4) {
            return new Color(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
        }
        return null;
    }

    public static Color black(int n) {
        return new Color(0, 0, 0, n);
    }

    public static Color white(int n) {
        return new Color(255, 255, 255, n);
    }
}

