/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ExceptionTable
extends Attribute {
    private int number_of_exceptions;
    private int[] exception_index_table;

    public ExceptionTable(ExceptionTable exceptionTable) {
        this(exceptionTable.getNameIndex(), exceptionTable.getLength(), exceptionTable.getExceptionIndexTable(), exceptionTable.getConstantPool());
    }

    public ExceptionTable(int n, int n2, int[] nArray, ConstantPool constantPool) {
        super((byte)3, n, n2, constantPool);
        this.setExceptionIndexTable(nArray);
    }

    ExceptionTable(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, (int[])null, constantPool);
        this.number_of_exceptions = dataInputStream.readUnsignedShort();
        this.exception_index_table = new int[this.number_of_exceptions];
        for (int i = 0; i < this.number_of_exceptions; ++i) {
            this.exception_index_table[i] = dataInputStream.readUnsignedShort();
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitExceptionTable(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.number_of_exceptions);
        for (int i = 0; i < this.number_of_exceptions; ++i) {
            dataOutputStream.writeShort(this.exception_index_table[i]);
        }
    }

    public final int[] getExceptionIndexTable() {
        return this.exception_index_table;
    }

    public final int getNumberOfExceptions() {
        return this.number_of_exceptions;
    }

    public final String[] getExceptionNames() {
        String[] stringArray = new String[this.number_of_exceptions];
        for (int i = 0; i < this.number_of_exceptions; ++i) {
            stringArray[i] = this.constant_pool.getConstantString(this.exception_index_table[i], (byte)7).replace('/', '.');
        }
        return stringArray;
    }

    public final void setExceptionIndexTable(int[] nArray) {
        this.exception_index_table = nArray;
        this.number_of_exceptions = nArray == null ? 0 : nArray.length;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < this.number_of_exceptions; ++i) {
            String string = this.constant_pool.getConstantString(this.exception_index_table[i], (byte)7);
            stringBuffer.append(Utility.compactClassName(string, false));
            if (i >= this.number_of_exceptions - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public Attribute copy(ConstantPool constantPool) {
        ExceptionTable exceptionTable = (ExceptionTable)this.clone();
        exceptionTable.exception_index_table = (int[])this.exception_index_table.clone();
        exceptionTable.constant_pool = constantPool;
        return exceptionTable;
    }
}

