/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.ConfigFactory;
import com.sun.deploy.config.ConfigTrustManager;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.panel.ControlPanel;
import com.sun.deploy.panel.PlatformSpecificUtils;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.DeploymentHooks;
import com.sun.deploy.util.DeploymentHooksHelper;
import com.sun.deploy.util.SyncFileAccess;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.URLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import sun.jkernel.DownloadManager;
import sun.net.www.protocol.https.Handler;

public class Config {
    private static Properties _defaultProps = null;
    private static Properties _systemProps = null;
    private static Properties _props = null;
    private static Properties _changedProps = null;
    private static Properties _lockedProps = null;
    private static Properties _internalProps = null;
    protected static String _javaHome = null;
    private static final String _jreHome;
    private static final String _userHome;
    private static final String _systemHome;
    private static final String _osHome;
    private static final int _maxCommandLineLength;
    private static File _userConfigFile;
    private static SyncFileAccess _userConfigFileSyncAccess;
    private static long _lastChanged;
    private static boolean _dirty;
    private static final String PROPERTIES_FILE = "deployment.properties";
    private static final String CONFIG_FILE = "deployment.config";
    private static final String BASE = "deployment.";
    private static final String USER = "deployment.user.";
    private static final String SYSTEM = "deployment.system.";
    private static final String SEC = "deployment.security.";
    private static final String USEC = "deployment.user.security.";
    private static final String SSEC = "deployment.system.security.";
    private static final String PROX = "deployment.proxy.";
    private static final String JAVAPI = "deployment.javapi.";
    private static final String JAVAWS = "deployment.javaws.";
    private static final String JPROX = "deployment.javaws.proxy.";
    public static final String VERSION_UPDATED_KEY = "deployment.version";
    public static final String VERSION_UPDATE_THIS = "6.0";
    public static final String CACHEDIR_KEY = "deployment.user.cachedir";
    public static final String CACHEDIR_DEF;
    public static final String SYSCACHE_KEY = "deployment.system.cachedir";
    public static final String SEC_TLS_KEY = "deployment.security.TLSv1";
    public static final boolean SEC_TLS_DEF = true;
    public static final String SEC_SSLv2_KEY = "deployment.security.SSLv2Hello";
    public static final boolean SEC_SSLv2_DEF = false;
    public static final String SEC_SSLv3_KEY = "deployment.security.SSLv3";
    public static final boolean SEC_SSLv3_DEF = true;
    public static final String JAVAWS_CACHE_KEY = "deployment.javaws.cachedir";
    public static final String JAVAPI_CACHE_KEY = "deployment.javapi.cachedir";
    public static final String JAVAWS_UPDATE_KEY = "deployment.javaws.cache.update";
    public static final boolean JAVAWS_UPDATE_DEF = false;
    public static final String JAVAPI_UPDATE_KEY = "deployment.javapi.cache.update";
    public static final boolean JAVAPI_UPDATE_DEF = false;
    public static final String LOGDIR_KEY = "deployment.user.logdir";
    public static final String LOGDIR_DEF;
    public static final String PLUGIN_OUTPUTFILE_PREFIX = "plugin";
    public static final String JAVAWS_OUTPUTFILE_PREFIX = "javaws";
    public static final String OUTPUTFILE_LOG_SUFFIX = ".log";
    public static final String OUTPUTFILE_TRACE_SUFFIX = ".trace";
    public static final String JAVAWS_TRACEFILE_KEY = "deployment.javaws.traceFileName";
    public static final String JAVAWS_TRACEFILE_DEF = "";
    public static final String JAVAWS_LOGFILE_KEY = "deployment.javaws.logFileName";
    public static final String JAVAWS_LOGFILE_DEF = "";
    public static final String TMPDIR_KEY = "deployment.user.tmp";
    public static final String TMPDIR_DEF;
    public static final String USR_EXTDIR_KEY = "deployment.user.extdir";
    public static final String USR_EXTDIR_DEF;
    public static final String SYS_EXTDIR_KEY = "deployment.system.extdir";
    public static final String USEC_POLICY_KEY = "deployment.user.security.policy";
    public static final String USEC_CACERTS_KEY = "deployment.user.security.trusted.cacerts";
    public static final String USEC_CACERTS_DEF;
    public static final String USEC_JSSECERTS_KEY = "deployment.user.security.trusted.jssecacerts";
    public static final String USEC_JSSECERTS_DEF;
    public static final String USEC_TRUSTED_CERTS_KEY = "deployment.user.security.trusted.certs";
    public static final String USEC_TRUSTED_CERTS_DEF;
    public static final String USEC_TRUSTED_JSSE_CERTS_KEY = "deployment.user.security.trusted.jssecerts";
    public static final String USEC_TRUSTED_JSSE_CERTS_DEF;
    public static final String USEC_TRUSTED_CLIENT_CERTS_KEY = "deployment.user.security.trusted.clientauthcerts";
    public static final String USEC_TRUSTED_CLIENT_CERTS_DEF;
    public static final String USEC_PRETRUST_KEY = "deployment.user.security.trusted.publishers";
    public static final String USEC_PRETRUST_DEF;
    public static final String USEC_BLACKLIST_KEY = "deployment.user.security.blacklist";
    public static final String USEC_BLACKLIST_DEF;
    public static final String USEC_TRUSTED_LIBRARIES_KEY = "deployment.user.security.trusted.libraries";
    public static final String USEC_TRUSTED_LIBRARIES_DEF;
    public static final String USEC_CREDENTIAL_KEY = "deployment.user.security.saved.credentials";
    public static final String USEC_CREDENTIAL_DEF;
    public static final String SSEC_POLICY_KEY = "deployment.system.security.policy";
    public static final String SSEC_CACERTS_KEY = "deployment.system.security.cacerts";
    public static final String SSEC_CACERTS_DEF;
    public static final String SSEC_OLD_CACERTS_KEY = "deployment.system.security.oldcacerts";
    public static final String SSEC_OLD_CACERTS_DEF;
    public static final String SSEC_JSSECERTS_KEY = "deployment.system.security.jssecacerts";
    public static final String SSEC_JSSECERTS_DEF;
    public static final String SSEC_OLD_JSSECERTS_KEY = "deployment.system.security.oldjssecacerts";
    public static final String SSEC_OLD_JSSECERTS_DEF;
    public static final String SSEC_TRUSTED_CERTS_KEY = "deployment.system.security.trusted.certs";
    public static final String SSEC_TRUSTED_CERTS_DEF;
    public static final String SSEC_TRUSTED_JSSE_CERTS_KEY = "deployment.system.security.trusted.jssecerts";
    public static final String SSEC_TRUSTED_JSSE_CERTS_DEF;
    public static final String SSEC_TRUSTED_CLIENT_CERTS_KEY = "deployment.system.security.trusted.clientauthcerts";
    public static final String SSEC_TRUSTED_CLIENT_CERTS_DEF;
    public static final String SSEC_PRETRUST_KEY = "deployment.system.security.trusted.publishers";
    public static final String SSEC_PRETRUST_DEF;
    public static final String SSEC_BLACKLIST_KEY = "deployment.system.security.blacklist";
    public static final String SSEC_BLACKLIST_DEF;
    public static final String SSEC_TRUSTED_LIBRARIES_KEY = "deployment.system.security.trusted.libraries";
    public static final String SSEC_TRUSTED_LIBRARIES_DEF;
    public static final String APPCONTEXT_APP_NAME_KEY = "deploy.trust.decider.app.name";
    public static final String SEC_ASKGRANT_SHOW_KEY = "deployment.security.askgrantdialog.show";
    public static final boolean SEC_ASKGRANT_SHOW_DEF = true;
    public static final String SEC_ASKGRANT_NOTCA_KEY = "deployment.security.askgrantdialog.notinca";
    public static final boolean SEC_ASKGRANT_NOTCA_DEF = true;
    public static final String SEC_USE_BROWSER_KEYSTORE_KEY = "deployment.security.browser.keystore.use";
    public static final boolean SEC_USE_BROWSER_KEYSTORE_DEF = true;
    public static final String SEC_USE_CLIENTAUTH_AUTO_KEY = "deployment.security.clientauth.keystore.auto";
    public static final boolean SEC_USE_CLIENTAUTH_AUTO_DEF = true;
    public static final String SEC_NOTINCA_WARN_KEY = "deployment.security.notinca.warning";
    public static final boolean SEC_NOTINCA_WARN_DEF = true;
    public static final String SEC_EXPIRED_WARN_KEY = "deployment.security.expired.warning";
    public static final boolean SEC_EXPIRED_WARN_DEF = true;
    public static final String SEC_JSSE_HOST_WARN_KEY = "deployment.security.jsse.hostmismatch.warning";
    public static final boolean SEC_JSSE_HOST_WARN_DEF = true;
    public static final String SEC_HTTPS_DIALOG_WARN_KEY = "deployment.security.https.warning.show";
    public static final boolean SEC_HTTPS_DIALOG_WARN_DEF = false;
    public static final String SEC_TRUSTED_POLICY_KEY = "deployment.security.trusted.policy";
    public static final String SEC_TRUSTED_POLICY_DEF = "";
    public static final String SEC_AWT_WARN_WINDOW_KEY = "deployment.security.sandbox.awtwarningwindow";
    public static final boolean SEC_AWT_WARN_WINDOW_DEF = true;
    public static final String SEC_SANDBOX_JNLP_ENHANCED_KEY = "deployment.security.sandbox.jnlp.enhanced";
    public static final boolean SEC_SANDBOX_JNLP_ENHANCED_DEF = true;
    public static final String SEC_USE_VALIDATION_CRL_KEY = "deployment.security.validation.crl";
    public static final boolean SEC_USE_VALIDATION_CRL_DEF = false;
    public static final String SEC_USE_VALIDATION_CRL_URL_KEY = "deployment.security.validation.crl.url";
    public static final String SEC_USE_VALIDATION_OCSP_KEY = "deployment.security.validation.ocsp";
    public static final boolean SEC_USE_VALIDATION_OCSP_DEF = false;
    public static final String SEC_USE_VALIDATION_OCSP_EE_KEY = "deployment.security.validation.ocsp.publisher";
    public static final boolean SEC_USE_VALIDATION_OCSP_EE_DEF = false;
    public static final String SEC_USE_VALIDATION_OCSP_SIGNER_KEY = "deployment.security.validation.ocsp.signer";
    public static final String SEC_USE_VALIDATION_OCSP_URL_KEY = "deployment.security.validation.ocsp.url";
    public static final String SEC_AUTHENTICATOR_KEY = "deployment.security.authenticator";
    public static final boolean SEC_AUTHENTICATOR_DEF = true;
    public static final String SEC_USE_PRETRUST_LIST_KEY = "deployment.security.pretrust.list";
    public static final boolean SEC_USE_PRETRUST_LIST_DEF = true;
    public static final String SEC_USE_BLACKLIST_CHECK_KEY = "deployment.security.blacklist.check";
    public static final boolean SEC_USE_BLACKLIST_CHECK_DEF = true;
    public static final String SEC_USE_PASSWORD_CACHE_KEY = "deployment.security.password.cache";
    public static final boolean SEC_USE_PASSWORD_CACHE_DEF = true;
    public static final String REMOTE_JNLP_DOCS_KEY = "deployment.javaws.home.jnlp.url";
    public static final String REMOTE_JNLP_DOCS_DEF = "http://java.sun.com/products/javawebstart";
    public static final String JAVAWS_SSV_ENABLED_KEY = "deployment.javaws.ssv.enabled";
    public static final boolean JAVAWS_SSV_ENABLED_DEF = true;
    public static final int PROX_TYPE_UNKNOWN = -1;
    public static final int PROX_TYPE_NONE = 0;
    public static final int PROX_TYPE_MANUAL = 1;
    public static final int PROX_TYPE_AUTO = 2;
    public static final int PROX_TYPE_BROWSER = 3;
    public static final int PROX_TYPE_SYSTEM = 4;
    public static final String PROX_TYPE_KEY = "deployment.proxy.type";
    public static final String JPROX_TYPE_KEY = "deployment.javaws.proxy.type";
    public static final int PROX_TYPE_DEF = 3;
    public static final String PROX_SAME_KEY = "deployment.proxy.same";
    public static final String JPROX_SAME_KEY = "deployment.javaws.proxy.same";
    public static final boolean PROX_SAME_DEF = false;
    public static final String PROX_LOCAL_KEY = "deployment.proxy.bypass.local";
    public static final String JPROX_LOCAL_KEY = "deployment.javaws.proxy.bypass.local";
    public static final boolean PROX_LOCAL_DEF = false;
    public static final String PROX_AUTOCFG_KEY = "deployment.proxy.auto.config.url";
    public static final String JPROX_AUTOCFG_KEY = "deployment.javaws.proxy.auto.config.url";
    public static final String PROX_BYPASS_KEY = "deployment.proxy.bypass.list";
    public static final String JPROX_BYPASS_KEY = "deployment.javaws.proxy.bypass.list";
    public static final String PROX_HTTP_HOST_KEY = "deployment.proxy.http.host";
    public static final String PROX_HTTP_PORT_KEY = "deployment.proxy.http.port";
    public static final String PROX_HTTPS_HOST_KEY = "deployment.proxy.https.host";
    public static final String PROX_HTTPS_PORT_KEY = "deployment.proxy.https.port";
    public static final String PROX_FTP_HOST_KEY = "deployment.proxy.ftp.host";
    public static final String PROX_FTP_PORT_KEY = "deployment.proxy.ftp.port";
    public static final String PROX_SOX_HOST_KEY = "deployment.proxy.socks.host";
    public static final String PROX_SOX_PORT_KEY = "deployment.proxy.socks.port";
    public static final String JPROX_HTTP_HOST_KEY = "deployment.javaws.proxy.http.host";
    public static final String JPROX_HTTP_PORT_KEY = "deployment.javaws.proxy.http.port";
    public static final String JPROX_HTTPS_HOST_KEY = "deployment.javaws.proxy.https.host";
    public static final String JPROX_HTTPS_PORT_KEY = "deployment.javaws.proxy.https.port";
    public static final String JPROX_FTP_HOST_KEY = "deployment.javaws.proxy.ftp.host";
    public static final String JPROX_FTP_PORT_KEY = "deployment.javaws.proxy.ftp.port";
    public static final String JPROX_SOX_HOST_KEY = "deployment.javaws.proxy.socks.host";
    public static final String JPROX_SOX_PORT_KEY = "deployment.javaws.proxy.socks.port";
    public static final String PROX_OVERRIDE_KEY = "deployment.proxy.override.hosts";
    public static final String JPROX_OVERRIDE_KEY = "deployment.javaws.proxy.override.hosts";
    public static final String PROX_OVERRIDE_DEF = "";
    public static final String CACHE_MAX_KEY = "deployment.cache.max.size";
    public static final String CACHE_MAX_DEF = "-1";
    public static final String CACHE_COMPRESSION_KEY = "deployment.cache.jarcompression";
    public static final int CACHE_COMPRESSION_DEF = 0;
    public static final String CACHE_ENABLED_KEY = "deployment.cache.enabled";
    public static final boolean CACHE_ENABLED_DEF = true;
    public static final String OPR_ENABLED_KEY = "deployment.repository.enabled";
    public static final boolean OPR_ENABLED_DEF = true;
    public static final String OPR_ASK_SHOW_KEY = "deployment.repository.askdownloaddialog.show";
    public static final boolean OPR_ASK_SHOW_DEF = true;
    public static final String SPLASH_CACHE_INDEX_KEY = "deployment.javaws.splash.index";
    public static final String CONSOLE_MODE_HIDE = "HIDE";
    public static final String CONSOLE_MODE_SHOW = "SHOW";
    public static final String CONSOLE_MODE_DISABLED = "DISABLE";
    public static final String CONSOLE_MODE_KEY = "deployment.console.startup.mode";
    public static final String CONSOLE_MODE_DEF = "HIDE";
    public static final String TRACE_MODE_KEY = "deployment.trace";
    public static final boolean TRACE_MODE_DEF = false;
    public static final String TRACE_LEVEL_KEY = "deployment.trace.level";
    public static final String MAX_NUM_FILES_KEY = "deployment.max.output.files";
    public static final int MAX_NUM_FILES_DEF = 5;
    public static final String MAX_SIZE_FILE_KEY = "deployment.max.output.file.size";
    public static final int MAX_SIZE_FILE_DEF = 10;
    public static final String LOG_MODE_KEY = "deployment.log";
    public static final boolean LOG_MODE_DEF = false;
    public static final String LOG_CP_KEY = "deployment.control.panel.log";
    public static final boolean LOG_CP_DEF = false;
    public static final String USE_SYSTEM_LF_KEY = "deployment.system.lookandfeel";
    public static final String JPI_TRACE_FILE_KEY = "deployment.javapi.trace.filename";
    public static final String JPI_TRACE_FILE_DEF = "";
    public static final String JPI_LOG_FILE_KEY = "deployment.javapi.log.filename";
    public static final String JPI_LOG_FILE_DEF = "";
    public static final String SHOW_EXCEPTIONS_KEY = "deployment.javapi.lifecycle.exception";
    public static final boolean SHOW_EXCEPTIONS_DEF = false;
    public static final int JPI_RUNTIME_TYPE_JRE = 0;
    public static final int JPI_RUNTIME_TYPE_JDK = 1;
    public static final String BROWSER_VM_IEXPLORER_KEY = "deployment.browser.vm.iexplorer";
    public static final boolean BROWSER_VM_IEXPLORER_DEF = true;
    public static final String BROWSER_VM_MOZILLA_KEY = "deployment.browser.vm.mozilla";
    public static final boolean BROWSER_VM_MOZILLA_DEF = true;
    public static final String SYSTEM_TRAY_ICON_KEY = "deployment.system.tray.icon";
    public static final boolean SYSTEM_TRAY_ICON_DEF = true;
    public static final String JPI_RUNTIME_VER_KEY = "deployment.javapi.runtime.version";
    public static final String JPI_RUNTIME_VER_DEF = "";
    public static final String JPI_RUNTIME_TYPE_KEY = "deployment.javapi.runtime.type";
    public static final int JPI_RUNTIME_TYPE_DEF = 0;
    public static final String JAVAPI_STOP_TIMEOUT_KEY = "deployment.javapi.stop.timeout";
    public static final int JAVAPI_STOP_TIMEOUT_DEF = 200;
    public static final int JAVAPI_STOP_TIMEOUT_MAX = 3000;
    public static final String JAVAWS_CONCURRENT_DOWNLOADS_KEY = "deployment.javaws.concurrentDownloads";
    public static final int JAVAWS_CONCURRENT_DOWNLOADS_DEF = 4;
    public static final int JAVAWS_CONCURRENT_DOWNLOADS_MAX = 10;
    public static final String JPI_JAVA_PATH = ".path";
    public static final String JPI_JAVA_ARGS = ".args";
    public static final String JPI_JAVA_OSNAME = ".osname";
    public static final String JPI_JAVA_OSARCH = ".osarch";
    public static final String JPI_JAVA_ENABLED = ".enabled";
    public static final String JPI_JRE_KEY = "deployment.javapi.jre.";
    public static final String JPI_JDK_KEY = "deployment.javapi.jdk.";
    public static final String ASSOCIATION_MODE_KEY = "deployment.javaws.associations";
    public static final String ASSOCIATION_MODE_ALWAYS = "ALWAYS";
    public static final String ASSOCIATION_MODE_NEVER = "NEVER";
    public static final String ASSOCIATION_MODE_NEW_ONLY = "NEW_ONLY";
    public static final String ASSOCIATION_MODE_ASK_USER = "ASK_USER";
    public static final String ASSOCIATION_MODE_REPLACE_ASK = "REPLACE_ASK";
    public static final String ASSOCIATION_MODE_DEF = "ASK_USER";
    public static final int ASSOCIATION_NEVER = 0;
    public static final int ASSOCIATION_NEW_ONLY = 1;
    public static final int ASSOCIATION_ASK_USER = 2;
    public static final int ASSOCIATION_REPLACE_ASK = 3;
    public static final int ASSOCIATION_ALWAYS = 4;
    public static final int SHORTCUT_NEVER = 0;
    public static final int SHORTCUT_NO = 0;
    public static final int SHORTCUT_ALWAYS = 1;
    public static final int SHORTCUT_YES = 1;
    public static final int SHORTCUT_ASK_USER = 2;
    public static final int SHORTCUT_ASK_IF_HINTED = 3;
    public static final int SHORTCUT_ALWAYS_IF_HINTED = 4;
    public static final String SHORTCUT_MODE_NEVER = "NEVER";
    public static final String SHORTCUT_MODE_ALWAYS = "ALWAYS";
    public static final String SHORTCUT_MODE_ASK_USER = "ASK_USER";
    public static final String SHORTCUT_MODE_ASK_IF_HINTED = "ASK_IF_HINTED";
    public static final String SHORTCUT_MODE_ALWAYS_IF_HINTED = "ALWAYS_IF_HINTED";
    public static final String SHORTCUT_MODE_KEY = "deployment.javaws.shortcut";
    public static final String SHORTCUT_MODE_DEF = "ASK_IF_HINTED";
    public static final String SHORTCUT_UNINSTALL_KEY = "deployment.javaws.uninstall.shortcut";
    public static final boolean SHORTCUT_UNINSTALL_DEF = false;
    public static final String JAVAWS_JRE_PLATFORM_ID = ".platform";
    public static final String JAVAWS_JRE_PRODUCT_ID = ".product";
    public static final String JAVAWS_JRE_LOCATION = ".location";
    public static final String JAVAWS_JRE_PATH = ".path";
    public static final String JAVAWS_JRE_ARGS = ".args";
    public static final String JAVAWS_JRE_OS_ARCH = ".osarch";
    public static final String JAVAWS_JRE_OS_NAME = ".osname";
    public static final String JAVAWS_JRE_ISENABLED = ".enabled";
    public static final String JAVAWS_JRE_ISREGISTERED = ".registered";
    public static final String JAVAWS_JRE_KEY = "deployment.javaws.jre.";
    public static final String JAVAWS_JRE_INSTALL_KEY = "deployment.javaws.installURL";
    public static final String JAVAWS_JRE_INSTALL_DEF = "http://java.sun.com/products/autodl/j2se";
    public static final String AUTODOWNLOAD_MODE_ALWAYS = "ALWAYS";
    public static final String AUTODOWNLOAD_MODE_PROMPT = "PROMPT";
    public static final String AUTODOWNLOAD_MODE_NEVER = "NEVER";
    public static final String JAVAWS_JRE_AUTODOWNLOAD_KEY = "deployment.javaws.autodownload";
    public static final String JAVAWS_JRE_AUTODOWNLOAD_DEF = "ALWAYS";
    public static final int MIXCODE_ENABLE = 0;
    public static final int MIXCODE_HIDE_RUN = 1;
    public static final int MIXCODE_HIDE_CANCEL = 2;
    public static final int MIXCODE_DISABLE = 3;
    public static final String MIXCODE_MODE_ENABLE = "ENABLE";
    public static final String MIXCODE_MODE_HIDE_RUN = "HIDE_RUN";
    public static final String MIXCODE_MODE_HIDE_CANCEL = "HIDE_CANCEL";
    public static final String MIXCODE_MODE_DISABLE = "DISABLE";
    public static final String MIXCODE_MODE_KEY = "deployment.security.mixcode";
    public static final String MIXCODE_MODE_DEF = "ENABLE";
    public static final String JAUTHENTICATOR_SYSTEM_PROP = "javaws.cfg.jauthenticator";
    public static final String BROWSER_PATH_KEY = "deployment.browser.path";
    public static final String BROWSER_PATH_DEF = "";
    public static final String EXTENDED_BROWSER_ARGS_KEY = "deployment.browser.args";
    public static final String EXTENDED_BROWSER_ARGS_DEF = "-remote openURL(%u,new-window)";
    public static final String CAPTURE_MIME_KEY = "deployment.capture.mime.types";
    public static final boolean CAPTURE_MIME_DEF = false;
    public static final String UPDATE_MIME_KEY = "deployment.update.mime.types";
    public static final boolean UPDATE_MIME_DEF = true;
    public static final String MIME_DEFAULTS_KEY = "deployment.mime.types.use.default";
    public static final boolean MIME_DEFAULTS_MIME_DEF = true;
    public static final String JAVAWS_MUFFIN_LIMIT_KEY = "deployment.javaws.muffin.max";
    public static final int JAVAWS_MUFFIN_LIMIT_DEF = 256;
    public static final String JAVAWS_UPDATE_TIMEOUT_KEY = "deployment.javaws.update.timeout";
    public static final int JAVAWS_UPDATE_TIMEOUT_DEF = 1500;
    public static final String SECURE_PROPS_KEY = "deployment.javaws.secure.properties";
    public static final String JQS_KEY = "java.quick.starter";
    public static final boolean JQS_DEF = false;
    public static final String USE_NEW_PLUGIN_KEY = "deployment.jpi.mode.new";
    public static final boolean USE_NEW_PLUGIN_DEF = true;
    public static boolean applyButtonAction;
    public static boolean successDialogShown;
    private static final String[] DefaultSecureProperties;
    private static String[] secureVmArgs;
    private static String[] secureVmPrefixes;
    private static boolean _configOK;
    private static Config _config;
    private static final String _os;
    private static final String _arch;
    private static final String _platform;
    private static ControlPanel _ControlPanel;
    private DeploymentHooks deploymentHooksHelper = new DeploymentHooksHelper();
    private static final String _javaRuntimeNameProperty;
    private static final String _javaVersionProperty;
    private static final boolean _atLeast13;
    private static final boolean _atLeast14;
    private static final boolean _atLeast15;
    private static final boolean _atLeast16;
    private static String _enterprizeConfig;
    private static long _start;
    private static long _end;

    public static String getJavaVersion() {
        return _javaVersionProperty;
    }

    public DeploymentHooks getHooks() {
        return this.deploymentHooksHelper;
    }

    public static void setupPackageAccessRestriction() {
        Config.addToSecurityProperty("package.access", "com.sun.javaws");
        Config.addToSecurityProperty("package.access", "com.sun.deploy");
        Config.addToSecurityProperty("package.access", "com.sun.jnlp");
        Config.addToSecurityProperty("package.definition", "com.sun.javaws");
        Config.addToSecurityProperty("package.definition", "com.sun.deploy");
        Config.addToSecurityProperty("package.definition", "com.sun.jnlp");
        Config.addToSecurityProperty("package.access", "org.mozilla.jss");
        Config.addToSecurityProperty("package.definition", "org.mozilla.jss");
    }

    private static void addToSecurityProperty(String string, String string2) {
        String string3 = Security.getProperty(string);
        Trace.securityPrintln("property " + string + " value " + string3);
        string3 = string3 != null ? string3 + "," + string2 : string2;
        Security.setProperty(string, string3);
        Trace.securityPrintln("property " + string + " new value " + string3);
    }

    public static void setControlPanel(ControlPanel controlPanel) {
        _ControlPanel = controlPanel;
    }

    public static final String getAppContextKeyPrefix() {
        return "deploy-";
    }

    public static boolean isJavaVersionAtLeast16() {
        return _atLeast16;
    }

    public static boolean isJavaVersionAtLeast15() {
        return _atLeast15;
    }

    public static boolean isJavaVersionAtLeast14() {
        return _atLeast14;
    }

    public static boolean isJavaVersionAtLeast13() {
        return _atLeast13;
    }

    public static boolean isJFB() {
        return _javaRuntimeNameProperty.endsWith("Business");
    }

    public static boolean installDeployRMIClassLoaderSpi() {
        return !Boolean.getBoolean("jnlp.noDeployRMIClassLoaderSpi");
    }

    public static synchronized Config getInstance() {
        if (_config == null) {
            _config = ConfigFactory.newInstance();
        }
        return _config;
    }

    public static void reInit() {
        Config.initialize();
    }

    public static boolean isConfigValid() {
        return _configOK;
    }

    private static boolean initialize() {
        String string;
        Object object;
        Properties properties;
        boolean bl = true;
        _defaultProps = Config.getDefaultProps();
        _systemProps = new Properties();
        _internalProps = Config.getInternalProps();
        _userConfigFile = new File(_userHome + File.separator + Config.getPropertiesFilename());
        _userConfigFileSyncAccess = new SyncFileAccess(_userConfigFile);
        File file = new File(_systemHome + File.separator + CONFIG_FILE);
        if (!file.exists()) {
            file = new File(_javaHome + File.separator + "lib" + File.separator + CONFIG_FILE);
        }
        if (file.exists() && (properties = Config.loadPropertiesFile(new Properties(), file)) != null) {
            object = properties.getProperty("deployment.system.config.mandatory");
            boolean bl2 = object != null && !((String)object).equalsIgnoreCase("false");
            _enterprizeConfig = string = properties.getProperty("deployment.system.config");
            if (string != null && !Config.tryDownloading(string, _systemProps)) {
                bl = !bl2;
            }
        }
        Config.refreshProps();
        Config.versionUpdateCheck();
        properties = System.getProperties();
        object = _props.propertyNames();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            string = Config.getProperty(string2);
            if (string == null) continue;
            properties.put(string2, string);
        }
        System.setProperties(properties);
        Config.setPolicyFiles();
        return bl;
    }

    public static void getBrowserSettings() {
        PlatformSpecificUtils.initBrowserSettings();
    }

    public static void setBrowserSettings() {
        PlatformSpecificUtils.applyBrowserSettings();
    }

    public static boolean isJREComplete() {
        try {
            return DownloadManager.isJREComplete();
        }
        catch (Error error) {
            return true;
        }
    }

    public static boolean getJqsSettings() {
        boolean bl = PlatformSpecificUtils.getJqsSettings();
        if (!Config.isJREComplete() || Config.getInstance().isPlatformWindowsVista()) {
            _lockedProps.setProperty(JQS_KEY, "false");
        } else {
            _lockedProps.remove(JQS_KEY);
        }
        Config.getInstance();
        Config.setProperty(JQS_KEY, new Boolean(bl).toString());
        return bl;
    }

    public static void setJqsSettings(boolean bl) {
        PlatformSpecificUtils.setJqsSettings(bl);
    }

    public static boolean getJavaPluginSettings() {
        boolean bl = true;
        if (_arch.equalsIgnoreCase("amd64")) {
            _lockedProps.setProperty(USE_NEW_PLUGIN_KEY, new Boolean(true).toString());
        } else {
            bl = PlatformSpecificUtils.getJavaPluginSettings();
            if (!Config.isJREComplete()) {
                _lockedProps.setProperty(USE_NEW_PLUGIN_KEY, new Boolean(true).toString());
            } else {
                _lockedProps.remove(USE_NEW_PLUGIN_KEY);
            }
        }
        Config.getInstance();
        Config.setProperty(USE_NEW_PLUGIN_KEY, new Boolean(bl).toString());
        return bl;
    }

    public static int setJavaPluginSettings(boolean bl) {
        return PlatformSpecificUtils.setJavaPluginSettings(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tryDownloading(String string, Properties properties) {
        URLConnection uRLConnection = null;
        try {
            URL uRL = null;
            uRL = string.toLowerCase().startsWith("https:") ? new URL(null, string, new Handler()) : new URL(string);
            uRLConnection = uRL.openConnection();
            if (uRLConnection instanceof HttpsURLConnection) {
                ConfigTrustManager.resetHttpsFactory((HttpsURLConnection)uRLConnection);
            }
            InputStream inputStream = uRLConnection.getInputStream();
            properties.load(inputStream);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
            boolean bl = false;
            return bl;
        }
        finally {
            if (uRLConnection != null && uRLConnection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)uRLConnection).disconnect();
            }
        }
    }

    private static void setPolicyFiles() {
        String string = Config.getSystemSecurityPolicyURL();
        String string2 = Config.getUserSecurityPolicyURL();
        if (string != null || string2 != null) {
            int n = 1;
            String string3 = null;
            while ((string3 = Security.getProperty("policy.url." + n)) != null) {
                ++n;
            }
            if (string != null) {
                Security.setProperty("policy.url." + n, string);
                ++n;
            }
            if (string2 != null) {
                Security.setProperty("policy.url." + n, string2);
                ++n;
            }
        }
    }

    public static void refreshProps() {
        String string;
        String string2;
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        Properties properties3 = new Properties();
        Properties properties4 = new Properties();
        Properties properties5 = new Properties();
        _lockedProps = new Properties();
        _props = new Properties(_defaultProps);
        if (_userConfigFile.exists()) {
            Config.loadPropertiesFile(properties, _userConfigFile);
            _lastChanged = _userConfigFile.lastModified();
        } else {
            _lastChanged = System.currentTimeMillis();
        }
        Enumeration<Object> enumeration = _systemProps.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            string = _systemProps.getProperty(string2);
            if (string2.startsWith(JAVAWS_JRE_KEY)) {
                properties3.setProperty(string2, string);
                continue;
            }
            if (string2.endsWith(".locked")) {
                int n = string2.length() - ".locked".length();
                String string3 = _systemProps.getProperty(string2 = string2.substring(0, n));
                if (string3 == null) continue;
                _lockedProps.setProperty(string2, string3);
                continue;
            }
            if (!string2.startsWith(BASE)) continue;
            _props.setProperty(string2, string);
        }
        enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            string = properties.getProperty(string2);
            if (string2.startsWith(JAVAWS_JRE_KEY)) {
                properties2.setProperty(string2, string);
                continue;
            }
            if (string2.startsWith(JPI_JRE_KEY)) {
                properties4.setProperty(string2, string);
                continue;
            }
            if (string2.startsWith(JPI_JDK_KEY)) {
                properties5.setProperty(string2, string);
                continue;
            }
            if (!string2.startsWith(BASE) && !string2.startsWith("javaplugin")) continue;
            _props.setProperty(string2, string);
        }
        enumeration = _lockedProps.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            _props.setProperty(string2, _lockedProps.getProperty(string2));
        }
        JREInfo.initialize(properties3, properties2);
        JREInfo.importJpiEntries(properties4);
        _dirty = false;
        _changedProps = new Properties();
        if (Config.getInstance().isPlatformWindowsVista()) {
            _lockedProps.setProperty(BROWSER_VM_IEXPLORER_KEY, new Boolean(true).toString());
        } else {
            _lockedProps.remove(BROWSER_VM_IEXPLORER_KEY);
        }
        Config.getJavaPluginSettings();
        Config.getJqsSettings();
    }

    public static void refreshUnchangedProps() {
        Properties properties = _changedProps;
        Config.refreshProps();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Config.setProperty(string, properties.getProperty(string));
        }
    }

    public static String getPropertiesFilename() {
        return PROPERTIES_FILE;
    }

    public static boolean isDiskNewer() {
        return _userConfigFile.exists() && _userConfigFile.lastModified() > _lastChanged;
    }

    public static String booleanToString(boolean bl) {
        if (bl) {
            return "true";
        }
        return "false";
    }

    public static void refreshIfNecessary() {
        if (!_dirty && Config.isDiskNewer()) {
            Config.refreshProps();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Properties properties;
        if (_dirty && Config.isDiskNewer()) {
            properties = _changedProps;
            Config.refreshProps();
            object4 = properties.keys();
            while (object4.hasMoreElements()) {
                object3 = (String)object4.nextElement();
                Config.setProperty((String)object3, properties.getProperty((String)object3));
            }
        }
        properties = new Properties();
        object4 = new Properties();
        object3 = _props.keys();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            if (Config.isLocked((String)object2) || Config.dontSave((String)object2)) continue;
            String string = _props.getProperty((String)object2);
            String string2 = _systemProps.getProperty((String)object2);
            object = _defaultProps.getProperty((String)object2);
            if (string != null && (string2 == null || string.equals(string2)) && (string2 != null || string.equals(object))) continue;
            properties.setProperty((String)object2, string);
        }
        object2 = JREInfo.getAll();
        int n = 0;
        for (int i = 0; i < ((JREInfo[])object2).length; ++i) {
            if (object2[i].isSystemJRE()) continue;
            if (object2[i].getPlatform() != null) {
                ((Properties)object4).setProperty(JAVAWS_JRE_KEY + n + JAVAWS_JRE_PLATFORM_ID, object2[i].getPlatform());
            }
            if (object2[i].getProduct() != null) {
                ((Properties)object4).setProperty(JAVAWS_JRE_KEY + n + JAVAWS_JRE_PRODUCT_ID, object2[i].getProduct());
            }
            if (object2[i].getLocation() != null) {
                ((Properties)object4).setProperty(JAVAWS_JRE_KEY + n + JAVAWS_JRE_LOCATION, object2[i].getLocation());
            }
            if (object2[i].getPath() != null) {
                ((Properties)object4).setProperty(JAVAWS_JRE_KEY + n + ".path", object2[i].getPath());
            }
            if (object2[i].getVmArgs() != null) {
                ((Properties)object4).setProperty(JAVAWS_JRE_KEY + n + ".args", object2[i].getVmArgs());
            }
            if (object2[i].getOSArch() != null) {
                ((Properties)object4).setProperty(JAVAWS_JRE_KEY + n + ".osarch", object2[i].getOSArch());
            }
            if (object2[i].getOSName() != null) {
                ((Properties)object4).setProperty(JAVAWS_JRE_KEY + n + ".osname", object2[i].getOSName());
            }
            ((Properties)object4).setProperty(JAVAWS_JRE_KEY + n + ".enabled", Config.booleanToString(object2[i].isEnabled()));
            ((Properties)object4).setProperty(JAVAWS_JRE_KEY + n + JAVAWS_JRE_ISREGISTERED, Config.booleanToString(object2[i].isRegistered()));
            ++n;
        }
        _userConfigFile.getParentFile().mkdirs();
        try {
            SyncFileAccess.FileOutputStreamLock fileOutputStreamLock = _userConfigFileSyncAccess.openLockFileOutputStream(false, 2000, false);
            object = fileOutputStreamLock != null ? fileOutputStreamLock.getFileOutputStream() : new FileOutputStream(_userConfigFile);
            try {
                if (object != null) {
                    try {
                        properties.store((OutputStream)object, Config.getPropertiesFilename());
                        ((Properties)object4).store((OutputStream)object, "Java Deployment jre's");
                    }
                    catch (IOException iOException) {
                        Trace.println("Exception: " + iOException);
                    }
                }
            }
            finally {
                if (object != null) {
                    ((OutputStream)object).flush();
                    try {
                        ((FileOutputStream)object).close();
                    }
                    catch (IOException iOException) {}
                }
                if (fileOutputStreamLock != null) {
                    fileOutputStreamLock.release();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        _dirty = false;
        _changedProps = new Properties();
        long l = _lastChanged = _userConfigFile.exists() ? _userConfigFile.lastModified() : System.currentTimeMillis();
        if (_ControlPanel != null) {
            ControlPanel.propertyChanged(false);
        }
    }

    public static void storeIfDirty() {
        if (_dirty) {
            Config.store();
        }
    }

    public static boolean isDirty() {
        return _dirty;
    }

    public static boolean isPropertyChanged(String string) {
        return _changedProps.containsKey(string);
    }

    public static Properties getProperties() {
        Properties properties = new Properties(_props);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string2 == null) continue;
            properties.setProperty(string, Config.replaceVariables(string2).trim());
        }
        return properties;
    }

    public static boolean isLocked(String string) {
        return _lockedProps.containsKey(string);
    }

    public static boolean dontSave(String string) {
        return _internalProps.containsKey(string);
    }

    public static String getJavaHome() {
        if (_javaHome == null) {
            String string = System.getProperty("jnlpx.home");
            string = string != null ? string.substring(0, string.lastIndexOf(File.separator)) : System.getProperty("java.home");
            _javaHome = string;
        }
        return _javaHome;
    }

    public static String getJREHome() {
        return _jreHome;
    }

    public static String getOSHome() {
        return _osHome;
    }

    public static String getSystemHome() {
        return _systemHome;
    }

    public static String getUserHome() {
        return _userHome;
    }

    public static String getOSName() {
        return _os;
    }

    public static String getOSArch() {
        return _arch;
    }

    public static String getOSPlatform() {
        return _platform;
    }

    protected int getPlatformMaxCommandLineLength() {
        return 0;
    }

    public static int getMaxCommandLineLength() {
        return _maxCommandLineLength;
    }

    protected long getPlatformPID() {
        return -1L;
    }

    public static long getNativePID() {
        return Config.getInstance().getPlatformPID();
    }

    public static String getProperty(String string) {
        String string2 = _props.getProperty(string);
        if (string2 != null) {
            return Config.replaceVariables(string2).trim();
        }
        return null;
    }

    public static String getSystemProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    public static void setProperty(String string, String string2) {
        Config.setProperty(string, string2, true);
    }

    public static void setProperty(String string, String string2, boolean bl) {
        if (Config.isDiskNewer()) {
            Config.refreshIfNecessary();
        }
        if (string2 == null || string2.length() == 0) {
            _dirty |= _props.containsKey(string);
            _props.remove(string);
            _changedProps.remove(string);
        } else {
            if (bl) {
                string2 = Config.restoreVariables(string2);
            }
            if (!string2.equals(_props.getProperty(string))) {
                _dirty = true;
                _props.setProperty(string, string2);
                _changedProps.setProperty(string, string2);
                if (_ControlPanel != null) {
                    ControlPanel.propertyChanged(true);
                }
            }
        }
    }

    public static int getIntProperty(String string) {
        String string2 = Config.getProperty(string);
        if (string2 == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static void setIntProperty(String string, int n) {
        Config.setProperty(string, Integer.toString(n));
    }

    public static boolean getBooleanProperty(String string) {
        String string2 = Config.getProperty(string);
        if (string2 == null) {
            return false;
        }
        return Boolean.valueOf(string2);
    }

    public static void setBooleanProperty(String string, boolean bl) {
        Config.setProperty(string, Config.booleanToString(bl));
    }

    private static String restoreVariables(String string) {
        if (string.indexOf(_javaHome) >= 0) {
            string = Config.substitute(string, "$JAVA_HOME", _javaHome);
        }
        if (string.indexOf(_jreHome) >= 0) {
            string = Config.substitute(string, "$JRE_HOME", _jreHome);
        }
        if (string.indexOf(_userHome) >= 0) {
            string = Config.substitute(string, "$USER_HOME", _userHome);
        }
        if (string.indexOf(_systemHome) >= 0) {
            string = Config.substitute(string, "$SYSTEM_HOME", _systemHome);
        }
        return string;
    }

    private static String replaceVariables(String string) {
        if (string.indexOf("$JAVA_HOME") >= 0) {
            string = Config.substitute(string, _javaHome, "$JAVA_HOME");
        }
        if (string.indexOf("$JRE_HOME") >= 0) {
            string = Config.substitute(string, _jreHome, "$JRE_HOME");
        }
        if (string.indexOf("$USER_HOME") >= 0) {
            string = Config.substitute(string, _userHome, "$USER_HOME");
        }
        if (string.indexOf("SYSTEM_HOME") >= 0) {
            string = Config.substitute(string, _systemHome, "$SYSTEM_HOME");
        }
        return string;
    }

    private static String substitute(String string, String string2, String string3) {
        int n = string.indexOf(string3);
        return n < 0 ? string : string.substring(0, n) + string2 + string.substring(n + string3.length());
    }

    private static void versionUpdateCheck() {
        String string = Config.getProperty(VERSION_UPDATED_KEY);
        if (string == null || string.compareTo("1.5.0") < 0) {
            String string2;
            Object object;
            Properties properties = Config.translateMantisProperties(_props);
            if (properties.getProperty(JAVAWS_CACHE_KEY) == null && new File((String)(object = _userHome + File.separator + JAVAWS_OUTPUTFILE_PREFIX + File.separator + "cache")).exists()) {
                properties.setProperty(JAVAWS_CACHE_KEY, (String)object);
            }
            object = null;
            Object object2 = new File(_userHome);
            String string3 = ((File)object2).getParent() + File.separator + ".deployment";
            Object object3 = string3 + File.separator + PROPERTIES_FILE;
            File file = new File((String)object3);
            if (file.exists() && ((Properties)(object = Config.translateMantisProperties(Config.loadPropertiesFile(new Properties(), file)))).getProperty(JAVAWS_CACHE_KEY) == null && new File(string2 = string3 + File.separator + JAVAWS_OUTPUTFILE_PREFIX + File.separator + "cache").exists()) {
                ((Properties)object).setProperty(JAVAWS_CACHE_KEY, string2);
            }
            if (object == null && ((File)(object3 = new File(string3 = (String)(object2 = System.getProperty("user.home") + File.separator + ".javaws") + File.separator + "javaws.cfg"))).exists()) {
                object = Config.translateOlderProperties(Config.loadPropertiesFile(new Properties(), (File)object3), (String)object2);
            }
            if (object != null) {
                Config.setProperties((Properties)object);
            }
            if (properties != null) {
                Config.setProperties(properties);
            }
            Config.setProperty(BROWSER_PATH_KEY, Config.getInstance().getBrowserPath());
            string = "1.5.0";
        }
        if (string.compareTo(VERSION_UPDATE_THIS) < 0) {
            Config.setProperties(Config.translateTigerProperties(_props));
            Config.setProperty(VERSION_UPDATED_KEY, VERSION_UPDATE_THIS);
            Config.setBooleanProperty(JAVAWS_UPDATE_KEY, true);
            Config.setBooleanProperty(JAVAPI_UPDATE_KEY, true);
            Config.setBooleanProperty(CAPTURE_MIME_KEY, true);
            Config.storeIfDirty();
        }
    }

    private static void setProperties(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Config.setProperty(string, properties.getProperty(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFile(Properties properties, File file) {
        SyncFileAccess.FileInputStreamLock fileInputStreamLock = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStreamLock = file.equals(_userConfigFile) ? _userConfigFileSyncAccess.openLockFileInputStream(1000, false) : null;
            fileInputStream = fileInputStreamLock != null ? fileInputStreamLock.getFileInputStream() : new FileInputStream(file);
            properties.load(fileInputStream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Trace.println("Cannot find prop file: " + file.getAbsolutePath());
            Properties properties3 = null;
            return properties3;
        }
        catch (IOException iOException) {
            Trace.println("IO Execption: " + iOException);
            Properties properties4 = null;
            return properties4;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileInputStreamLock != null) {
                fileInputStreamLock.release();
            }
        }
    }

    private static Properties translateTigerProperties(Properties properties) {
        Properties properties2 = new Properties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string.equals(ASSOCIATION_MODE_KEY) && (string2.equals(ASSOCIATION_MODE_NEW_ONLY) || string2.equals(ASSOCIATION_MODE_REPLACE_ASK))) {
                string2 = "ASK_USER";
            }
            properties2.setProperty(string, string2);
        }
        return properties2;
    }

    private static Properties translateMantisProperties(Properties properties) {
        String string;
        Properties properties2 = new Properties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            String string2 = null;
            String string3 = properties.getProperty(string);
            if (string.startsWith("deployment.javaws.proxy")) {
                if (string.equals("deployment.javaws.proxy.httpport")) {
                    string2 = PROX_HTTP_PORT_KEY;
                } else if (string.equals("deployment.javaws.proxy.http")) {
                    string2 = PROX_HTTP_HOST_KEY;
                } else if (string.equals("deployment.javaws.proxy.httpproxyoverride")) {
                    string2 = PROX_OVERRIDE_KEY;
                }
            } else if (string.startsWith(JAVAWS)) {
                if (string.equals(JAVAWS_LOGFILE_KEY)) {
                    string2 = JAVAWS_TRACEFILE_KEY;
                } else if (string.equals("deployment.javaws.showConsole")) {
                    if (string3.equals("true")) {
                        string2 = CONSOLE_MODE_KEY;
                        string3 = CONSOLE_MODE_SHOW;
                    }
                } else if (string.equals("deployment.javaws.updateTimeout")) {
                    string2 = JAVAWS_UPDATE_TIMEOUT_KEY;
                } else if (string.equals("deployment.javaws.version")) {
                    string3 = null;
                }
            } else if (string.startsWith("javaplugin")) {
                properties2.setProperty(string, string3);
                if (string.equals("javaplugin.cache.disabled")) {
                    string2 = CACHE_ENABLED_KEY;
                    string3 = string3.equals("true") ? "false" : "true";
                } else if (string.equals("javaplugin.cache.size")) {
                    string2 = CACHE_MAX_KEY;
                } else if (string.equals("javaplugin.cache.compression")) {
                    string2 = CACHE_COMPRESSION_KEY;
                } else if (string.equals("javaplugin.console")) {
                    string2 = CONSOLE_MODE_KEY;
                    string3 = string3.equals("show") ? CONSOLE_MODE_SHOW : (string3.equals("hide") ? "HIDE" : "DISABLE");
                } else if (string.equals("javaplugin.exception")) {
                    string2 = SHOW_EXCEPTIONS_KEY;
                }
            }
            if (string2 == null || string3 == null || string3.length() <= 0) continue;
            properties2.setProperty(string2, string3);
        }
        string = properties.getProperty("deployment.javaws.cache.dir");
        if (string != null) {
            properties2.setProperty(JAVAWS_CACHE_KEY, string);
        }
        return properties2;
    }

    private static Properties translateOlderProperties(Properties properties, String string) {
        String string2;
        Properties properties2 = new Properties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            if (string2.startsWith("javaws.cfg.jre.") || string2.startsWith("javaws.cfg.splash") || string2.startsWith("javaws.cfg.player")) continue;
            if (string2.equals("javaws.cfg.cache.dir")) {
                properties2.setProperty(JAVAWS_CACHE_KEY, string3);
            }
            if (!string2.startsWith("javaws.cfg.")) continue;
            string2 = string2.equals("javaws.cfg.proxy.httpport") ? PROX_HTTP_PORT_KEY : (string2.equals("javaws.cfg.proxy.http") ? PROX_HTTP_HOST_KEY : (string2.equals("javaws.cfg.proxy.httpproxyoverride") ? PROX_OVERRIDE_KEY : string2.replaceFirst("javaws.cfg.", BASE)));
            if (string3 == null || string3.length() <= 0) continue;
            properties2.setProperty(string2, string3);
        }
        if (properties2.getProperty(JAVAWS_CACHE_KEY) == null && new File(string2 = string + File.separator + "cache").exists()) {
            properties2.setProperty(JAVAWS_CACHE_KEY, string2);
        }
        return properties2;
    }

    private static Properties getInternalProps() {
        Properties properties = new Properties();
        properties.setProperty(JQS_KEY, "false");
        properties.setProperty(BROWSER_VM_IEXPLORER_KEY, "true");
        properties.setProperty(BROWSER_VM_MOZILLA_KEY, "true");
        properties.setProperty(SYSTEM_TRAY_ICON_KEY, "true");
        properties.setProperty(USE_NEW_PLUGIN_KEY, "true");
        return properties;
    }

    private static Properties getDefaultProps() {
        Properties properties = new Properties();
        properties.setProperty(JPI_TRACE_FILE_KEY, "");
        properties.setProperty(JPI_LOG_FILE_KEY, "");
        properties.setProperty(ASSOCIATION_MODE_KEY, "ASK_USER");
        properties.setProperty(JAVAWS_TRACEFILE_KEY, "");
        properties.setProperty(JAVAWS_LOGFILE_KEY, "");
        properties.setProperty(SEC_TLS_KEY, "true");
        properties.setProperty(SEC_SSLv2_KEY, "false");
        properties.setProperty(SEC_SSLv3_KEY, "true");
        properties.setProperty(CACHEDIR_KEY, CACHEDIR_DEF);
        String string = Config.getInstance().getDefaultSystemCache();
        if (string != null) {
            properties.setProperty(SYSCACHE_KEY, string);
        }
        properties.setProperty(LOGDIR_KEY, LOGDIR_DEF);
        properties.setProperty(TMPDIR_KEY, TMPDIR_DEF);
        properties.setProperty(USR_EXTDIR_KEY, USR_EXTDIR_DEF);
        String string2 = _userHome + File.separator + "security" + File.separator + "java.policy";
        properties.setProperty(USEC_POLICY_KEY, "file:/" + URLUtil.encodePath(string2));
        properties.setProperty(USEC_CACERTS_KEY, USEC_CACERTS_DEF);
        properties.setProperty(USEC_JSSECERTS_KEY, USEC_JSSECERTS_DEF);
        properties.setProperty(USEC_TRUSTED_CERTS_KEY, USEC_TRUSTED_CERTS_DEF);
        properties.setProperty(USEC_TRUSTED_JSSE_CERTS_KEY, USEC_TRUSTED_JSSE_CERTS_DEF);
        properties.setProperty(USEC_TRUSTED_CLIENT_CERTS_KEY, USEC_TRUSTED_CLIENT_CERTS_DEF);
        properties.setProperty(USEC_PRETRUST_KEY, USEC_PRETRUST_DEF);
        properties.setProperty(USEC_BLACKLIST_KEY, USEC_BLACKLIST_DEF);
        properties.setProperty(USEC_TRUSTED_LIBRARIES_KEY, USEC_TRUSTED_LIBRARIES_DEF);
        properties.setProperty(USEC_CREDENTIAL_KEY, USEC_CREDENTIAL_DEF);
        properties.setProperty(SSEC_CACERTS_KEY, SSEC_CACERTS_DEF);
        properties.setProperty(SSEC_OLD_CACERTS_KEY, SSEC_OLD_CACERTS_DEF);
        properties.setProperty(SSEC_JSSECERTS_KEY, SSEC_JSSECERTS_DEF);
        properties.setProperty(SSEC_OLD_JSSECERTS_KEY, SSEC_OLD_JSSECERTS_DEF);
        properties.setProperty(SSEC_TRUSTED_CERTS_KEY, SSEC_TRUSTED_CERTS_DEF);
        properties.setProperty(SSEC_TRUSTED_JSSE_CERTS_KEY, SSEC_TRUSTED_JSSE_CERTS_DEF);
        properties.setProperty(SSEC_TRUSTED_CLIENT_CERTS_KEY, SSEC_TRUSTED_CLIENT_CERTS_DEF);
        properties.setProperty(SSEC_PRETRUST_KEY, SSEC_PRETRUST_DEF);
        properties.setProperty(SSEC_BLACKLIST_KEY, SSEC_BLACKLIST_DEF);
        properties.setProperty(SSEC_TRUSTED_LIBRARIES_KEY, SSEC_TRUSTED_LIBRARIES_DEF);
        properties.setProperty(SEC_ASKGRANT_SHOW_KEY, "true");
        properties.setProperty(SEC_ASKGRANT_NOTCA_KEY, "true");
        properties.setProperty(SEC_USE_BROWSER_KEYSTORE_KEY, "true");
        properties.setProperty(SEC_USE_CLIENTAUTH_AUTO_KEY, "true");
        properties.setProperty(SEC_USE_PRETRUST_LIST_KEY, "true");
        properties.setProperty(SEC_USE_BLACKLIST_CHECK_KEY, "true");
        properties.setProperty(SEC_USE_PASSWORD_CACHE_KEY, "true");
        properties.setProperty(SEC_NOTINCA_WARN_KEY, "true");
        properties.setProperty(SEC_EXPIRED_WARN_KEY, "true");
        properties.setProperty(SEC_JSSE_HOST_WARN_KEY, "true");
        properties.setProperty(SEC_HTTPS_DIALOG_WARN_KEY, "false");
        properties.setProperty(SEC_TRUSTED_POLICY_KEY, "");
        properties.setProperty(SEC_AWT_WARN_WINDOW_KEY, "true");
        properties.setProperty(SEC_SANDBOX_JNLP_ENHANCED_KEY, "true");
        properties.setProperty(SEC_USE_VALIDATION_CRL_KEY, "false");
        properties.setProperty(SEC_USE_VALIDATION_OCSP_KEY, "false");
        properties.setProperty(SEC_USE_VALIDATION_OCSP_EE_KEY, "false");
        properties.setProperty(SEC_AUTHENTICATOR_KEY, "true");
        properties.setProperty(PROX_TYPE_KEY, "3");
        properties.setProperty(PROX_SAME_KEY, "false");
        properties.setProperty(PROX_LOCAL_KEY, "false");
        properties.setProperty(PROX_OVERRIDE_KEY, "");
        properties.setProperty(CACHE_MAX_KEY, CACHE_MAX_DEF);
        properties.setProperty(CACHE_COMPRESSION_KEY, "0");
        properties.setProperty(CACHE_ENABLED_KEY, "true");
        properties.setProperty(OPR_ENABLED_KEY, "true");
        properties.setProperty(OPR_ASK_SHOW_KEY, "true");
        properties.setProperty(CONSOLE_MODE_KEY, "HIDE");
        properties.setProperty(TRACE_MODE_KEY, "false");
        properties.setProperty(LOG_MODE_KEY, "false");
        properties.setProperty(MAX_NUM_FILES_KEY, "5");
        properties.setProperty(MAX_SIZE_FILE_KEY, "10");
        properties.setProperty(LOG_CP_KEY, "false");
        properties.setProperty(SHOW_EXCEPTIONS_KEY, "false");
        properties.setProperty(JPI_RUNTIME_TYPE_KEY, "0");
        properties.setProperty(SHORTCUT_MODE_KEY, "ASK_IF_HINTED");
        properties.setProperty(SHORTCUT_UNINSTALL_KEY, "false");
        properties.setProperty(CAPTURE_MIME_KEY, "false");
        properties.setProperty(UPDATE_MIME_KEY, "true");
        properties.setProperty(MIME_DEFAULTS_KEY, "true");
        properties.setProperty(JAVAWS_JRE_INSTALL_KEY, JAVAWS_JRE_INSTALL_DEF);
        properties.setProperty(MIXCODE_MODE_KEY, "ENABLE");
        if (!Config.getInstance().canAutoDownloadJRE()) {
            properties.setProperty(JAVAWS_JRE_AUTODOWNLOAD_KEY, "NEVER");
        } else {
            properties.setProperty(JAVAWS_JRE_AUTODOWNLOAD_KEY, "ALWAYS");
        }
        properties.setProperty(JAVAWS_MUFFIN_LIMIT_KEY, "256");
        properties.setProperty(JAVAWS_UPDATE_TIMEOUT_KEY, "1500");
        properties.setProperty(JAVAWS_UPDATE_KEY, "false");
        properties.setProperty(JAVAPI_UPDATE_KEY, "false");
        properties.setProperty(JAVAPI_STOP_TIMEOUT_KEY, "200");
        properties.setProperty(JAVAWS_CONCURRENT_DOWNLOADS_KEY, "4");
        properties.setProperty(REMOTE_JNLP_DOCS_KEY, REMOTE_JNLP_DOCS_DEF);
        if (_os.equals("Windows")) {
            properties.setProperty(BROWSER_VM_IEXPLORER_KEY, "true");
            properties.setProperty(BROWSER_VM_MOZILLA_KEY, "true");
            properties.setProperty(SYSTEM_TRAY_ICON_KEY, "true");
        } else {
            properties.setProperty(BROWSER_PATH_KEY, "");
            properties.setProperty(EXTENDED_BROWSER_ARGS_KEY, EXTENDED_BROWSER_ARGS_DEF);
        }
        properties.setProperty(JAVAWS_SSV_ENABLED_KEY, "true");
        String string3 = System.getProperty(JAUTHENTICATOR_SYSTEM_PROP);
        if (string3 != null) {
            String string4 = "" + (!string3.equalsIgnoreCase("all") && !string3.equalsIgnoreCase("true"));
            properties.setProperty(SEC_AUTHENTICATOR_KEY, string4);
        }
        return properties;
    }

    public static void printProps() {
        Trace.println("\n_defaultProps:");
        Config.printP(_defaultProps);
        Trace.println("\n_systemProps:");
        Config.printP(_systemProps);
        Trace.println("\n_props:");
        Config.printP(_props);
    }

    private static void printP(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            Trace.println("  " + string + " : " + string2);
        }
        Trace.println("");
    }

    public static String getUserTrustedCertificateFile() {
        return Config.getProperty(USEC_TRUSTED_CERTS_KEY);
    }

    public static String getSystemTrustedCertificateFile() {
        return Config.getProperty(SSEC_TRUSTED_CERTS_KEY);
    }

    public static String getUserTrustedHttpsCertificateFile() {
        return Config.getProperty(USEC_TRUSTED_JSSE_CERTS_KEY);
    }

    public static String getSystemTrustedHttpsCertificateFile() {
        return Config.getProperty(SSEC_TRUSTED_JSSE_CERTS_KEY);
    }

    public static String getUserRootCertificateFile() {
        return Config.getProperty(USEC_CACERTS_KEY);
    }

    public static String getSystemRootCertificateFile() {
        return Config.getProperty(SSEC_CACERTS_KEY);
    }

    public static String getOldSystemRootCertificateFile() {
        return Config.getProperty(SSEC_OLD_CACERTS_KEY);
    }

    public static String getUserSSLRootCertificateFile() {
        return Config.getProperty(USEC_JSSECERTS_KEY);
    }

    public static String getSystemSSLRootCertificateFile() {
        return Config.getProperty(SSEC_JSSECERTS_KEY);
    }

    public static String getOldSystemSSLRootCertificateFile() {
        return Config.getProperty(SSEC_OLD_JSSECERTS_KEY);
    }

    public static String getUserClientAuthCertFile() {
        return Config.getProperty(USEC_TRUSTED_CLIENT_CERTS_KEY);
    }

    public static String getSystemClientAuthCertFile() {
        return Config.getProperty(SSEC_TRUSTED_CLIENT_CERTS_KEY);
    }

    public static String getUserPretrustFile() {
        return Config.getProperty(USEC_PRETRUST_KEY);
    }

    public static String getSystemPretrustFile() {
        return Config.getProperty(SSEC_PRETRUST_KEY);
    }

    public static String getUserBlacklistFile() {
        return Config.getProperty(USEC_BLACKLIST_KEY);
    }

    public static String getSystemBlacklistFile() {
        return Config.getProperty(SSEC_BLACKLIST_KEY);
    }

    public static String getUserTrustedLibrariesFile() {
        return Config.getProperty(USEC_TRUSTED_LIBRARIES_KEY);
    }

    public static String getSystemTrustedLibrariesFile() {
        return Config.getProperty(SSEC_TRUSTED_LIBRARIES_KEY);
    }

    public static String getUserAuthFile() {
        return Config.getProperty(USEC_CREDENTIAL_KEY);
    }

    public static String getUserCookieFile() {
        return _userHome + File.separator + "security" + File.separator + "cookie.txt";
    }

    public static String getCacheDirectory() {
        return Config.getProperty(CACHEDIR_KEY);
    }

    public static String getDefaultCacheDirectory() {
        return Config.replaceVariables(CACHEDIR_DEF).trim();
    }

    public static String getPluginCacheDir() {
        String string = Config.getProperty(JAVAPI_CACHE_KEY);
        if (string != null) {
            return string;
        }
        return Config.getCacheDirectory() + File.separator + "javapi";
    }

    public static String getTempCacheDir() {
        return Config.getCacheDirectory() + File.separator + "tmp";
    }

    public static String getSystemCacheDirectory() {
        return Config.getProperty(SYSCACHE_KEY);
    }

    public static void setCacheDirectory(String string) {
        Config.setProperty(CACHEDIR_KEY, string, true);
    }

    public static String getLogDirectory() {
        return Config.getProperty(LOGDIR_KEY);
    }

    public static String getTempDirectory() {
        return Config.getProperty(TMPDIR_KEY);
    }

    public static String getUserExtensionDirectory() {
        return Config.getProperty(USR_EXTDIR_KEY);
    }

    public static String getSystemExtensionDirectory() {
        return Config.getProperty(SYS_EXTDIR_KEY);
    }

    public static int getMaxAppletThreadCount() {
        return 50;
    }

    public static String getUserSecurityPolicyURL() {
        return Config.getProperty(USEC_POLICY_KEY);
    }

    public static String getSystemSecurityPolicyURL() {
        return Config.getProperty(SSEC_POLICY_KEY);
    }

    public static int getProxyType() {
        int n = Config.getIntProperty(PROX_TYPE_KEY);
        if (Environment.isJavaWebStart() && Config.getProperty(JPROX_TYPE_KEY) != null) {
            n = Config.getIntProperty(JPROX_TYPE_KEY);
        }
        return n;
    }

    public static boolean isProxySame() {
        boolean bl = Config.getBooleanProperty(PROX_SAME_KEY);
        if (Environment.isJavaWebStart() && Config.getProperty(JPROX_SAME_KEY) != null) {
            bl = Config.getBooleanProperty(JPROX_SAME_KEY);
        }
        return bl;
    }

    public static boolean isProxyBypassLocal() {
        boolean bl = Config.getBooleanProperty(PROX_LOCAL_KEY);
        if (Environment.isJavaWebStart() && Config.getProperty(JPROX_LOCAL_KEY) != null) {
            bl = Config.getBooleanProperty(JPROX_LOCAL_KEY);
        }
        return bl;
    }

    public static String getProxyAutoConfig() {
        String string = Config.getProperty(PROX_AUTOCFG_KEY);
        if (Environment.isJavaWebStart() && Config.getProperty(JPROX_AUTOCFG_KEY) != null) {
            string = Config.getProperty(JPROX_AUTOCFG_KEY);
        }
        return string;
    }

    public static String getProxyBypass() {
        String string = Config.getProperty(PROX_BYPASS_KEY);
        if (Environment.isJavaWebStart() && Config.getProperty(JPROX_BYPASS_KEY) != null) {
            string = Config.getProperty(JPROX_BYPASS_KEY);
        }
        return string;
    }

    public static String getProxyOverride() {
        String string = Config.getProperty(PROX_OVERRIDE_KEY);
        if (Environment.isJavaWebStart() && Config.getProperty(JPROX_OVERRIDE_KEY) != null) {
            string = Config.getProperty(JPROX_OVERRIDE_KEY);
        }
        return string;
    }

    public static String getProxyHttpHost() {
        String string = Config.getProperty(PROX_HTTP_HOST_KEY);
        if (Environment.isJavaWebStart() && Config.getProperty(JPROX_HTTP_HOST_KEY) != null) {
            string = Config.getProperty(JPROX_HTTP_HOST_KEY);
        }
        return string;
    }

    public static String getProxyHttpsHost() {
        String string = Config.getProperty(PROX_HTTPS_HOST_KEY);
        if (Environment.isJavaWebStart() && Config.getProperty(JPROX_HTTPS_HOST_KEY) != null) {
            string = Config.getProperty(JPROX_HTTPS_HOST_KEY);
        }
        return string;
    }

    public static String getProxyFtpHost() {
        String string = Config.getProperty(PROX_FTP_HOST_KEY);
        if (Environment.isJavaWebStart() && Config.getProperty(JPROX_FTP_HOST_KEY) != null) {
            string = Config.getProperty(JPROX_FTP_HOST_KEY);
        }
        return string;
    }

    public static String getProxySocksHost() {
        String string = Config.getProperty(PROX_SOX_HOST_KEY);
        if (Environment.isJavaWebStart() && Config.getProperty(JPROX_SOX_HOST_KEY) != null) {
            string = Config.getProperty(JPROX_SOX_HOST_KEY);
        }
        return string;
    }

    public static int getProxyHttpPort() {
        int n = Config.getIntProperty(PROX_HTTP_PORT_KEY);
        if (Environment.isJavaWebStart() && Config.getProperty(JPROX_HTTP_PORT_KEY) != null) {
            n = Config.getIntProperty(JPROX_HTTP_PORT_KEY);
        }
        return n;
    }

    public static int getProxyHttpsPort() {
        int n = Config.getIntProperty(PROX_HTTPS_PORT_KEY);
        if (Environment.isJavaWebStart() && Config.getProperty(JPROX_HTTPS_PORT_KEY) != null) {
            n = Config.getIntProperty(JPROX_HTTPS_PORT_KEY);
        }
        return n;
    }

    public static int getProxyFtpPort() {
        int n = Config.getIntProperty(PROX_FTP_PORT_KEY);
        if (Environment.isJavaWebStart() && Config.getProperty(JPROX_FTP_PORT_KEY) != null) {
            n = Config.getIntProperty(JPROX_FTP_PORT_KEY);
        }
        return n;
    }

    public static int getProxySocksPort() {
        int n = Config.getIntProperty(PROX_SOX_PORT_KEY);
        if (Environment.isJavaWebStart() && Config.getProperty(JPROX_SOX_PORT_KEY) != null) {
            n = Config.getIntProperty(JPROX_SOX_PORT_KEY);
        }
        return n;
    }

    public static void validateSystemCacheDirectory() {
        if (Config.getSystemCacheDirectory() != null && Config.getSystemCacheDirectory().equalsIgnoreCase(Config.getCacheDirectory())) {
            Trace.println(ResourceManager.getMessage("launch.warning.cachedir"));
            Environment.setSystemCacheMode(false);
            Cache.setSystemCacheDir(null);
        }
    }

    public static boolean useSystemLookAndFeel() {
        String string = Config.getProperty(USE_SYSTEM_LF_KEY);
        if (string != null) {
            return Boolean.valueOf(string);
        }
        return Config.getInstance().systemLookAndFeelDefault();
    }

    public static String getJavaCommand() {
        String string = System.getProperty("java.home");
        return Config.getJavaCommand(string);
    }

    public static String getJavaCommand(String string) {
        if (null == string) {
            return null;
        }
        if (string.endsWith(Config.getInstance().getPlatformSpecificJavaName())) {
            return string;
        }
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        string = string + "bin" + File.separator + Config.getInstance().getPlatformSpecificJavaName();
        return string;
    }

    public static String getJavaHome(String string) {
        if (null == string) {
            return null;
        }
        String string2 = "bin" + File.separator + Config.getInstance().getPlatformSpecificJavaName();
        if (string.endsWith(string2)) {
            string = string.substring(0, string.length() - string2.length());
        }
        while (string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String getJavawsCommand() {
        String string = Config.getJavaHome();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        string = string + "bin" + File.separator + JAVAWS_OUTPUTFILE_PREFIX + Config.getInstance().getPlatformExtension();
        return string;
    }

    public Vector getInstalledJREList() {
        return null;
    }

    public static void storeInstalledJREList(Vector vector) {
        JREInfo.setInstalledJREList(vector);
        Config.store();
    }

    public static String getOldJavawsCacheDir() {
        String string = Config.getProperty(JAVAWS_CACHE_KEY);
        if (string != null) {
            return string;
        }
        return Config.getCacheDirectory() + File.separator + JAVAWS_OUTPUTFILE_PREFIX;
    }

    public static String getSplashDir() {
        return Cache.getCacheDir().getPath() + File.separator + "splash";
    }

    public static String getSplashIndex() {
        return Config.getSplashDir() + File.separator + "splash.xml";
    }

    public static void setSplashCache() {
        Config.setProperty(SPLASH_CACHE_INDEX_KEY, Config.getSplashIndex(), false);
    }

    public static String[] getSecureProperties() {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        int n = 0;
        while (n < DefaultSecureProperties.length) {
            arrayList.add(DefaultSecureProperties[n++]);
        }
        String string = Config.getProperty(SECURE_PROPS_KEY);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public static boolean isSecureVmArg(String string) {
        int n;
        for (n = 0; n < secureVmArgs.length; ++n) {
            if (!string.equals(secureVmArgs[n])) continue;
            return true;
        }
        for (n = 0; n < secureVmPrefixes.length; ++n) {
            if (!string.startsWith(secureVmPrefixes[n])) continue;
            return !Config.containsUnsupportedCharacters(string);
        }
        if (string.startsWith("-D") || string.startsWith("\"-D")) {
            return Config.isSecureSystemProperty(string);
        }
        return false;
    }

    public static boolean isSecureSystemProperty(String string) {
        String string2 = "";
        if (string.startsWith("-D")) {
            string = string.substring(2);
        } else if (string.startsWith("\"-D")) {
            string = string.substring(3);
        }
        int n = string.indexOf(61);
        if (n != -1) {
            if (n + 1 < string.length()) {
                string2 = string.substring(n + 1);
            }
            string = string.substring(0, n);
        }
        return Config.isSecureProperty(string, string2);
    }

    private static boolean isSecurePropertyKey(String string) {
        if (Config.containsUnsupportedCharacters(string)) {
            return false;
        }
        if (string.startsWith("jnlp.") || string.startsWith("javaws.") || string.startsWith("javapi.")) {
            return true;
        }
        for (int i = 0; i < DefaultSecureProperties.length; ++i) {
            if (!string.equals(DefaultSecureProperties[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isSecureProperty(String string, String string2) {
        return Config.isSecurePropertyKey(string) && !Config.containsUnsupportedCharacters(string2);
    }

    private static boolean containsUnsupportedCharacters(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < ' ' || c > '~' || c == '%') {
                return true;
            }
            if (c != '\"') continue;
            int n = string.length() - 1;
            if ((i == 0 || i == n) && string.charAt(0) == '\"' && string.charAt(n) == '\"') continue;
            return true;
        }
        return false;
    }

    public static void addSecureSystemPropertiesTo(Properties properties) {
        String[] stringArray = Config.getSecureProperties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = System.getProperty(string);
            if (string2 == null) continue;
            properties.setProperty(string, string2);
        }
    }

    public static void addAllSystemPropertiesTo(Properties properties) {
        Properties properties2 = System.getProperties();
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties2.getProperty(string);
            properties.setProperty(string, string2);
        }
    }

    public static List getProxyOverrideList() {
        return null;
    }

    public static void setMixcodeValue(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "ENABLE";
                break;
            }
            default: {
                string = MIXCODE_MODE_HIDE_RUN;
                break;
            }
            case 2: {
                string = MIXCODE_MODE_HIDE_CANCEL;
                break;
            }
            case 3: {
                string = "DISABLE";
            }
        }
        Config.setProperty(MIXCODE_MODE_KEY, string);
    }

    public static int getMixcodeValue() {
        String string = Config.getProperty(MIXCODE_MODE_KEY);
        if (string.equals("ENABLE")) {
            return 0;
        }
        if (string.equals(MIXCODE_MODE_HIDE_RUN)) {
            return 1;
        }
        if (string.equals(MIXCODE_MODE_HIDE_CANCEL)) {
            return 2;
        }
        if (string.equals("DISABLE")) {
            return 3;
        }
        return 0;
    }

    public static void setShortcutValue(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "NEVER";
                break;
            }
            case 1: {
                string = "ALWAYS";
                break;
            }
            default: {
                string = "ASK_USER";
                break;
            }
            case 3: {
                string = "ASK_IF_HINTED";
                break;
            }
            case 4: {
                string = SHORTCUT_MODE_ALWAYS_IF_HINTED;
            }
        }
        Config.setProperty(SHORTCUT_MODE_KEY, string);
    }

    public static int getShortcutValue() {
        String string = Config.getProperty(SHORTCUT_MODE_KEY);
        if (string.equals("NEVER")) {
            return 0;
        }
        if (string.equals("ALWAYS")) {
            return 1;
        }
        if (string.equals("ASK_USER")) {
            return 2;
        }
        if (string.equals("ASK_IF_HINTED")) {
            return 3;
        }
        if (string.equals(SHORTCUT_MODE_ALWAYS_IF_HINTED)) {
            return 4;
        }
        return 0;
    }

    public static void setAssociationValue(int n) {
        String string;
        switch (n) {
            case 4: {
                string = "ALWAYS";
                break;
            }
            case 0: {
                string = "NEVER";
                break;
            }
            case 1: {
                string = ASSOCIATION_MODE_NEW_ONLY;
                break;
            }
            default: {
                string = "ASK_USER";
                break;
            }
            case 3: {
                string = ASSOCIATION_MODE_REPLACE_ASK;
            }
        }
        Config.setProperty(ASSOCIATION_MODE_KEY, string);
    }

    public static int getAssociationValue() {
        String string = Config.getProperty(ASSOCIATION_MODE_KEY);
        if (string.equals("ALWAYS")) {
            return 4;
        }
        if (string.equals("NEVER")) {
            return 0;
        }
        if (string.equals(ASSOCIATION_MODE_NEW_ONLY)) {
            return 1;
        }
        if (string.equals("ASK_USER")) {
            return 2;
        }
        if (string.equals(ASSOCIATION_MODE_REPLACE_ASK)) {
            return 3;
        }
        return 0;
    }

    public static long getCacheSizeMax() {
        long l = -1L;
        String string = Config.getProperty(CACHE_MAX_KEY);
        if (string != null && string.length() > 0) {
            long l2;
            if (string.endsWith("M") || string.endsWith("m")) {
                l2 = 0x100000L;
                string = string.substring(0, string.length() - 1);
            } else if (string.endsWith("K") || string.endsWith("k")) {
                l2 = 1024L;
                string = string.substring(0, string.length() - 1);
            } else {
                l2 = 0x100000L;
            }
            try {
                long l3 = Long.valueOf(string);
                if (l3 > 0L) {
                    l = l2 * l3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                l = 0x6400000L;
            }
        }
        return l;
    }

    public String escapeBackslashAndQuoteString(String string) {
        return null;
    }

    public String getPlatformOSHome() {
        return null;
    }

    public String getPlatformSystemHome() {
        return null;
    }

    public String getPlatformUserHome() {
        return null;
    }

    public String getSystemJavawsPath() {
        return Config.getJavawsCommand();
    }

    public String toExecArg(String string) {
        return string;
    }

    public String getLibraryPrefix() {
        return null;
    }

    public String getPlatformSpecificJavaName() {
        return null;
    }

    public String getPlatformExtension() {
        return null;
    }

    public String getDebugJavaPath(String string) {
        return string;
    }

    public void resetJavaHome() {
    }

    public String getLibrarySufix() {
        return null;
    }

    public boolean useAltFileSystemView() {
        return false;
    }

    public boolean showDocument(String string) {
        return false;
    }

    public String getBrowserPath() {
        return null;
    }

    public String getMozillaUserProfileDirectory() {
        return null;
    }

    public String getFireFoxUserProfileDirectory() {
        return null;
    }

    public int installShortcut(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return 0;
    }

    public boolean isLocalInstallSupported() {
        return true;
    }

    public String getUserHomeOverride() {
        return null;
    }

    public void setUserHomeOverride(String string) {
    }

    public void addRemoveProgramsAdd(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
    }

    public void addRemoveProgramsRemove(String string, boolean bl) {
    }

    public void sendJFXPing(String string, String string2, String string3, String string4, String string5, int n, String string6) {
    }

    public boolean systemLookAndFeelDefault() {
        return true;
    }

    public String getSessionSpecificString() {
        return "";
    }

    public boolean isPlatformIconType(String string) {
        return string.toLowerCase().endsWith(".ico");
    }

    public boolean canAutoDownloadJRE() {
        return true;
    }

    public void notifyJREInstalled(String string) {
    }

    public boolean isNativeModalDialogUp() {
        return false;
    }

    public boolean isPlatformWindowsVista() {
        return false;
    }

    public boolean isBrowserFireFox() {
        return false;
    }

    public long getSysStartupTime() {
        return 0L;
    }

    public String getDefaultSystemCache() {
        return null;
    }

    public int getSystemShortcutIconSize(boolean bl) {
        return bl ? 32 : 16;
    }

    private static void showIExplorerErrorDialog() {
        if (applyButtonAction) {
            UIFactory.showErrorDialog(null, ResourceManager.getMessage("browser.settings.fail.masthead"), ResourceManager.getMessage("browser.settings.fail.ie.text"), ResourceManager.getMessage("browser.settings.fail.caption"));
        }
    }

    private static void showMozillaErrorDialog() {
        if (applyButtonAction) {
            UIFactory.showErrorDialog(null, ResourceManager.getMessage("browser.settings.fail.masthead"), ResourceManager.getMessage("browser.settings.fail.moz.text"), ResourceManager.getMessage("browser.settings.fail.caption"));
        }
    }

    public static void showJPISettingsErrorDialog() {
        if (applyButtonAction) {
            UIFactory.showErrorDialog(null, ResourceManager.getMessage("jpi.settings.fail.masthead"), ResourceManager.getMessage("jpi.settings.fail.text"), ResourceManager.getMessage("jpi.settings.fail.caption"));
        }
    }

    private static void showSuccessDialog() {
        if (applyButtonAction && !successDialogShown) {
            UIFactory.showInformationDialog(null, ResourceManager.getMessage("browser.settings.success.masthead"), ResourceManager.getMessage("browser.settings.success.text"), ResourceManager.getMessage("browser.settings.success.caption"));
            successDialogShown = true;
        }
    }

    public static void showJPISettingsSuccessDialog() {
        if (applyButtonAction && !successDialogShown) {
            UIFactory.showInformationDialog(null, ResourceManager.getMessage("jpi.settings.success.masthead"), ResourceManager.getMessage("jpi.settings.success.text"), ResourceManager.getMessage("jpi.settings.success.caption"));
            successDialogShown = true;
        }
    }

    private static boolean showAlertDialog() {
        int n = UIFactory.showConfirmDialog(null, null, ResourceManager.getMessage("browser.settings.alert.text"), null);
        return n == 0;
    }

    public static String getEnterprizeString() {
        return _enterprizeConfig;
    }

    public static boolean isDebugMode() {
        String string = System.getProperty("deploy.debugMode");
        return string != null && string.equalsIgnoreCase("true");
    }

    public static boolean isDebugVMMode() {
        String string = System.getProperty("deploy.useDebugJavaVM");
        return string != null && string.equalsIgnoreCase("true");
    }

    public static boolean getHasAdminPrivileges() {
        return PlatformSpecificUtils.getHasAdminPrivileges();
    }

    public static String getLongPathName(String string) {
        return PlatformSpecificUtils.getLongPathName(string);
    }

    public static boolean samePaths(String string, String string2) {
        return PlatformSpecificUtils.samePaths(string, string2);
    }

    public String getBrowserHomePath() {
        return null;
    }

    public void loadDeployNativeLib() {
    }

    public static boolean checkClassName(String string) {
        try {
            Class<?> clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    static {
        _userConfigFile = null;
        _userConfigFileSyncAccess = null;
        CACHEDIR_DEF = "$USER_HOME" + File.separator + "cache";
        LOGDIR_DEF = "$USER_HOME" + File.separator + "log";
        TMPDIR_DEF = "$USER_HOME" + File.separator + "tmp";
        USR_EXTDIR_DEF = "$USER_HOME" + File.separator + "ext";
        USEC_CACERTS_DEF = "$USER_HOME" + File.separator + "security" + File.separator + "trusted.cacerts";
        USEC_JSSECERTS_DEF = "$USER_HOME" + File.separator + "security" + File.separator + "trusted.jssecacerts";
        USEC_TRUSTED_CERTS_DEF = "$USER_HOME" + File.separator + "security" + File.separator + "trusted.certs";
        USEC_TRUSTED_JSSE_CERTS_DEF = "$USER_HOME" + File.separator + "security" + File.separator + "trusted.jssecerts";
        USEC_TRUSTED_CLIENT_CERTS_DEF = "$USER_HOME" + File.separator + "security" + File.separator + "trusted.clientcerts";
        USEC_PRETRUST_DEF = "$USER_HOME" + File.separator + "security" + File.separator + "trusted.publishers";
        USEC_BLACKLIST_DEF = "$USER_HOME" + File.separator + "security" + File.separator + "blacklist";
        USEC_TRUSTED_LIBRARIES_DEF = "$USER_HOME" + File.separator + "security" + File.separator + "trusted.libraries";
        USEC_CREDENTIAL_DEF = "$USER_HOME" + File.separator + "security" + File.separator + "auth.dat";
        SSEC_CACERTS_DEF = "$JAVA_HOME" + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
        SSEC_OLD_CACERTS_DEF = "$JRE_HOME" + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
        SSEC_JSSECERTS_DEF = "$JAVA_HOME" + File.separator + "lib" + File.separator + "security" + File.separator + "jssecacerts";
        SSEC_OLD_JSSECERTS_DEF = "$JRE_HOME" + File.separator + "lib" + File.separator + "security" + File.separator + "jssecacerts";
        SSEC_TRUSTED_CERTS_DEF = "$JAVA_HOME" + File.separator + "lib" + File.separator + "security" + File.separator + "trusted.certs";
        SSEC_TRUSTED_JSSE_CERTS_DEF = "$JAVA_HOME" + File.separator + "lib" + File.separator + "security" + File.separator + "trusted.jssecerts";
        SSEC_TRUSTED_CLIENT_CERTS_DEF = "$JAVA_HOME" + File.separator + "lib" + File.separator + "security" + File.separator + "trusted.clientcerts";
        SSEC_PRETRUST_DEF = "$JAVA_HOME" + File.separator + "lib" + File.separator + "security" + File.separator + "trusted.publishers";
        SSEC_BLACKLIST_DEF = "$JAVA_HOME" + File.separator + "lib" + File.separator + "security" + File.separator + "blacklist";
        SSEC_TRUSTED_LIBRARIES_DEF = "$JAVA_HOME" + File.separator + "lib" + File.separator + "security" + File.separator + "trusted.libraries";
        applyButtonAction = false;
        successDialogShown = false;
        DefaultSecureProperties = new String[]{"sun.java2d.noddraw", JAUTHENTICATOR_SYSTEM_PROP, "swing.useSystemFontSettings", "swing.metalTheme", "http.agent", "http.keepAlive", "sun.awt.noerasebackground", "sun.java2d.opengl", "sun.java2d.d3d", "java.awt.syncLWRequests", "java.awt.Window.locationByPlatform", "sun.awt.erasebackgroundonresize", "swing.noxp", "swing.boldMetal", "awt.useSystemAAFontSettings", "sun.java2d.dpiaware", "sun.awt.disableMixing", "sun.lang.ClassLoader.allowArraySyntax"};
        secureVmArgs = new String[]{"-d32", "-client", "-server", "-verbose", "-version", "-showversion", "-help", "-X", "-ea", "-enableassertions", "-da", "-disableassertions", "-esa", "-enablesystemassertions", "-dsa", "-disablesystemassertions", "-Xmixed", "-Xint", "-Xnoclassgc", "-Xincgc", "-Xbatch", "-Xprof", "-Xdebug", "-Xfuture", "-Xrs", "-XX:+ForceTimeHighResolution", "-XX:-ForceTimeHighResolution", "-XX:+PrintGCDetails", "-XX:+PrintGCTimeStamps", "-XX:+PrintHeapAtGC", "-XX:PrintCMSStatistics", "-XX:+PrintTenuringDistribution", "-XX:+TraceClassUnloading", "-XX:SurvivorRatio", "-XX:MaxTenuringThreshol", "-XX:CMSMarkStackSize", "-XX:CMSMarkStackSizeMax", "-XX:+CMSClassUnloadingEnabled", "-XX:+CMSIncrementalMode", "-XX:CMSIncrementalDutyCycleMin", "-XX:+CMSIncrementalPacing", "-XX:CMSInitiatingOccupancyFraction", "-XX:+UseConcMarkSweepGC", "-XX:-ParallelRefProcEnabled", "-XX:ParallelGCThreads", "-XX:ParallelCMSThreads", "-XX:+DisableExplicitGC", "-XX:+UseCompressedOops", "-XX:+UseG1GC", "-XX:GCPauseIntervalMillis", "-XX:MaxGCPauseMillis"};
        secureVmPrefixes = new String[]{"-ea:", "-enableassertions:", "-da:", "-disableassertions:", "-verbose:", "-Xmn", "-Xms", "-Xmx", "-Xss", "-XX:NewRatio", "-XX:NewSize", "-XX:MaxNewSize", "-XX:PermSize", "-XX:MaxPermSize", "-XX:MaxHeapFreeRatio", "-XX:MinHeapFreeRatio", "-XX:UseSerialGC", "-XX:ThreadStackSize", "-XX:MaxInlineSize", "-XX:ReservedCodeCacheSize", "-XX:MaxDirectMemorySize"};
        _configOK = false;
        _ControlPanel = null;
        _javaRuntimeNameProperty = System.getProperty("java.runtime.name");
        _javaVersionProperty = System.getProperty("java.version");
        _atLeast13 = !_javaVersionProperty.startsWith("1.2");
        _atLeast14 = _atLeast13 && !_javaVersionProperty.startsWith("1.3");
        _atLeast15 = _atLeast14 && !_javaVersionProperty.startsWith("1.4");
        _atLeast16 = _atLeast15 && !_javaVersionProperty.startsWith("1.5");
        _enterprizeConfig = null;
        _javaHome = Config.getJavaHome();
        _jreHome = System.getProperty("java.home");
        _userHome = Config.getInstance().getPlatformUserHome();
        _systemHome = Config.getInstance().getPlatformSystemHome();
        _osHome = Config.getInstance().getPlatformOSHome();
        String string = System.getProperty("os.name");
        _os = string.startsWith("Win") ? "Windows" : string;
        _arch = System.getProperty("os.arch");
        _platform = System.getProperty("os.platform");
        _maxCommandLineLength = Config.getInstance().getPlatformMaxCommandLineLength();
        _configOK = Config.initialize();
    }
}

