/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileUtils {
    public static boolean copyFile(File srcFile, File destFile) {
        boolean result = false;
        try {
            FileInputStream in = new FileInputStream(srcFile);
            try {
                result = FileUtils.copyToFile(in, destFile);
            }
            finally {
                ((InputStream)in).close();
            }
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }

    public static boolean copyToFile(InputStream inputStream, File destFile) {
        try {
            if (destFile.exists()) {
                destFile.delete();
            }
            FileOutputStream out = new FileOutputStream(destFile);
            try {
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = inputStream.read(buffer)) >= 0) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            finally {
                out.flush();
                try {
                    out.getFD().sync();
                }
                catch (IOException iOException) {}
                out.close();
            }
        }
        catch (IOException e) {
            return false;
        }
    }
}

