/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui;

import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class AnimationPlayPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(AnimationPlayPanel.class.getName());
    private String baseDir;
    private int cycle_time;
    private String[][] strData;
    boolean flag = false;
    private String image_play_name;
    private int row_current = 0;
    private int play_num;
    private int pause_num;
    private ArrayList<String> list_pic_names;
    private int i = 0;
    private int j = 0;
    private boolean isPlaying = true;
    private int currentFrame = -1;
    private boolean isStop;

    public AnimationPlayPanel() {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                AnimationPlayPanel.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                AnimationPlayPanel.this.setCursor(new Cursor(0));
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                AnimationPlayPanel.this.modifyFrame();
            }
        });
    }

    public void play(String baseDir, int w, int h, int my_fps, String[][] data) {
        this.i = 0;
        this.j = 0;
        this.baseDir = baseDir;
        this.strData = data;
        this.cycle_time = 1000 / my_fps;
        this.init();
        this.validate();
        this.isPlaying = true;
        this.isStop = false;
        new Thread(){

            @Override
            public void run() {
                int count = -1;
                while (AnimationPlayPanel.this.isPlaying) {
                    if (AnimationPlayPanel.this.play_num == 0) {
                        AnimationPlayPanel.this.play_num = Integer.MAX_VALUE;
                    }
                    int size = AnimationPlayPanel.this.list_pic_names.size();
                    AnimationPlayPanel.this.i = 0;
                    while (AnimationPlayPanel.this.i < AnimationPlayPanel.this.play_num && AnimationPlayPanel.this.isPlaying) {
                        AnimationPlayPanel.this.j = 0;
                        while (AnimationPlayPanel.this.j < size && AnimationPlayPanel.this.isPlaying) {
                            if (count++ >= AnimationPlayPanel.this.currentFrame) {
                                AnimationPlayPanel animationPlayPanel = AnimationPlayPanel.this;
                                animationPlayPanel.currentFrame = animationPlayPanel.currentFrame + 1;
                                logger.debug("current == " + AnimationPlayPanel.this.currentFrame);
                                AnimationPlayPanel.this.image_play_name = (String)AnimationPlayPanel.this.list_pic_names.get(AnimationPlayPanel.this.j);
                                AnimationPlayPanel.this.repaint();
                                try {
                                    Thread.sleep(AnimationPlayPanel.this.cycle_time);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                            AnimationPlayPanel animationPlayPanel = AnimationPlayPanel.this;
                            animationPlayPanel.j = animationPlayPanel.j + 1;
                        }
                        AnimationPlayPanel animationPlayPanel = AnimationPlayPanel.this;
                        animationPlayPanel.i = animationPlayPanel.i + 1;
                    }
                    try {
                        Thread.sleep(AnimationPlayPanel.this.cycle_time * AnimationPlayPanel.this.pause_num);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    AnimationPlayPanel animationPlayPanel = AnimationPlayPanel.this;
                    animationPlayPanel.row_current = animationPlayPanel.row_current + 1;
                    if (AnimationPlayPanel.this.row_current >= AnimationPlayPanel.this.strData.length) break;
                    AnimationPlayPanel.this.list_pic_names.clear();
                    AnimationPlayPanel.this.updateData(AnimationPlayPanel.this.row_current);
                }
                if (AnimationPlayPanel.this.isStop) {
                    AnimationPlayPanel.this.currentFrame = 0;
                }
            }
        }.start();
    }

    public void stop() {
        this.isPlaying = false;
        this.isStop = true;
        this.currentFrame = 0;
    }

    public void pause() {
        this.isPlaying = false;
    }

    public boolean preFrame(String baseDir, int w, int h, int my_fps, String[][] data) {
        this.i = 0;
        this.j = 0;
        this.baseDir = baseDir;
        this.strData = data;
        this.cycle_time = 1000 / my_fps;
        this.init();
        if (this.currentFrame <= 0) {
            return false;
        }
        logger.debug("preFrame");
        --this.currentFrame;
        int count = -1;
        while (true) {
            if (this.play_num == 0) {
                this.play_num = Integer.MAX_VALUE;
            }
            int size = this.list_pic_names.size();
            this.i = 0;
            while (this.i < this.play_num) {
                this.j = 0;
                while (this.j < size) {
                    if (count++ >= this.currentFrame) {
                        logger.debug("current == " + this.currentFrame);
                        this.image_play_name = this.list_pic_names.get(this.j);
                        this.repaint();
                        return true;
                    }
                    ++this.j;
                }
                ++this.i;
            }
            ++this.row_current;
            if (this.row_current >= this.strData.length) break;
            this.list_pic_names.clear();
            this.updateData(this.row_current);
        }
        this.validate();
        return false;
    }

    public boolean nextFrame(String baseDir, int w, int h, int my_fps, String[][] data) {
        this.i = 0;
        this.j = 0;
        this.baseDir = baseDir;
        this.strData = data;
        this.cycle_time = 1000 / my_fps;
        this.init();
        logger.debug("nextFrame");
        ++this.currentFrame;
        this.validate();
        int count = -1;
        while (true) {
            if (this.play_num == 0) {
                this.play_num = Integer.MAX_VALUE;
            }
            int size = this.list_pic_names.size();
            this.i = 0;
            while (this.i < this.play_num) {
                this.j = 0;
                while (this.j < size) {
                    if (count++ >= this.currentFrame) {
                        logger.debug("current == " + this.currentFrame);
                        this.image_play_name = this.list_pic_names.get(this.j);
                        this.repaint();
                        return true;
                    }
                    ++this.j;
                }
                ++this.i;
            }
            ++this.row_current;
            if (this.row_current >= this.strData.length) break;
            this.list_pic_names.clear();
            this.updateData(this.row_current);
        }
        this.validate();
        return false;
    }

    public void modifyFrame(String baseDir, String[][] data, int frameNum) {
        if (frameNum < 0) {
            return;
        }
        this.i = 0;
        this.j = 0;
        this.baseDir = baseDir;
        this.init();
        this.validate();
        if (this.play_num == 0) {
            this.play_num = Integer.MAX_VALUE;
        }
        if (frameNum >= this.list_pic_names.size()) {
            return;
        }
        JFileChooser jfc = new JFileChooser();
        jfc.setBounds(20, 20, 300, 300);
        jfc.setVisible(true);
        jfc.setCurrentDirectory(new File(ThemeHelper.sLastClosedInfo.get("iconPath")));
        jfc.setDialogTitle("\u9009\u62e9\u4e00\u4e2a.png\u6587\u4ef6");
        jfc.setFileSelectionMode(0);
        jfc.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().toLowerCase().endsWith(".png") || file.isDirectory();
            }

            @Override
            public String getDescription() {
                return "png file";
            }
        });
        int state = jfc.showOpenDialog(this);
        if (state == 0) {
            File f = jfc.getSelectedFile();
            try {
                if (f.exists()) {
                    IOUtils.copy((InputStream)new FileInputStream(f), (OutputStream)new FileOutputStream(new File(this.list_pic_names.get(frameNum))));
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (f.getParent() != null) {
                ThemeHelper.sLastClosedInfo.put("iconPath", f.getParent());
            }
        }
        this.image_play_name = this.list_pic_names.get(frameNum);
        this.repaint();
    }

    public void modifyFrame() {
        if (this.currentFrame < 0) {
            return;
        }
        this.i = 0;
        this.j = 0;
        this.init();
        this.validate();
        int count = -1;
        boolean find = false;
        while (!find) {
            if (this.play_num == 0) {
                this.play_num = Integer.MAX_VALUE;
            }
            int size = this.list_pic_names.size();
            this.i = 0;
            while (this.i < this.play_num && !find) {
                this.j = 0;
                while (this.j < size && !find) {
                    if (count++ >= this.currentFrame) {
                        logger.debug("current == " + this.currentFrame);
                        this.image_play_name = this.list_pic_names.get(this.j);
                        find = true;
                        break;
                    }
                    ++this.j;
                }
                ++this.i;
            }
            ++this.row_current;
            if (this.row_current >= this.strData.length) break;
            this.list_pic_names.clear();
            this.updateData(this.row_current);
        }
        JFileChooser jfc = new JFileChooser();
        jfc.setBounds(20, 20, 300, 300);
        jfc.setVisible(true);
        jfc.setCurrentDirectory(new File(ThemeHelper.sLastClosedInfo.get("iconPath")));
        jfc.setDialogTitle("\u9009\u62e9\u4e00\u4e2a.png\u6587\u4ef6");
        jfc.setFileSelectionMode(0);
        jfc.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().toLowerCase().endsWith(".png") || file.isDirectory();
            }

            @Override
            public String getDescription() {
                return "png file";
            }
        });
        int state = jfc.showOpenDialog(this);
        if (state == 0) {
            File f = jfc.getSelectedFile();
            try {
                if (f.exists()) {
                    IOUtils.copy((InputStream)new FileInputStream(f), (OutputStream)new FileOutputStream(new File(this.image_play_name)));
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (f.getParent() != null) {
                ThemeHelper.sLastClosedInfo.put("iconPath", f.getParent());
            }
        }
        this.repaint();
    }

    public void init() {
        this.row_current = 0;
        this.play_num = Integer.parseInt(this.strData[this.row_current][1]);
        this.pause_num = Integer.parseInt(this.strData[this.row_current][2]);
        File f = new File(String.valueOf(this.baseDir) + File.separator + this.strData[this.i][0]);
        Object[] list_file = f.listFiles();
        Arrays.sort(list_file);
        this.list_pic_names = new ArrayList();
        Object[] objectArray = list_file;
        int n = list_file.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            if (((File)file).isFile()) {
                this.list_pic_names.add(((File)file).getAbsolutePath());
            }
            ++n2;
        }
    }

    public void updateData(int row_to_play) {
        this.play_num = Integer.parseInt(this.strData[row_to_play][1]);
        this.pause_num = Integer.parseInt(this.strData[row_to_play][2]);
        File f = new File(String.valueOf(this.baseDir) + File.separator + this.strData[row_to_play][0]);
        Object[] file_list = f.listFiles();
        Arrays.sort(file_list);
        Object[] objectArray = file_list;
        int n = file_list.length;
        int n2 = 0;
        while (n2 < n) {
            Object eachFile = objectArray[n2];
            if (((File)eachFile).isFile()) {
                this.list_pic_names.add(((File)eachFile).getAbsolutePath());
            }
            ++n2;
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.list_pic_names == null || this.list_pic_names.size() <= 0) {
            return;
        }
        g.setColor(Color.black);
        try {
            FileInputStream fis = new FileInputStream(this.image_play_name);
            BufferedImage img = ImageIO.read(fis);
            fis.close();
            double rate1 = (double)img.getWidth(null) / ((double)this.getWidth() - 10.0) + 0.1;
            double rate2 = (double)img.getHeight(null) / ((double)this.getHeight() - 10.0) + 0.1;
            double rate = rate1 > rate2 ? rate1 : rate2;
            int new_w = (int)((double)img.getWidth(null) / rate);
            int new_h = (int)((double)img.getHeight(null) / rate);
            g.drawImage(img, (this.getWidth() - new_w) / 2, (this.getHeight() - new_h) / 2, new_w, new_h, null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

