/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui;

import com.miui.theme.tool.gui.CheckListCheckBox;
import com.miui.theme.tool.resource.ResourceFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class CheckList
extends JList
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private DefaultListModel model;
    private Vector<String> vecFileNames = null;
    private CellRenderer cell;
    private boolean singleSelection = false;
    private JCheckBox boxLastSelected = null;

    public CheckList(Vector<String> vec, Vector<String> vcSelected) {
        if (vec == null) {
            return;
        }
        this.vecFileNames = vec;
        Collections.sort(this.vecFileNames, new Comparator(){

            public int compare(Object o1, Object o2) {
                return Collator.getInstance(Locale.CHINESE).compare(o1, o2);
            }
        });
        this.model = new DefaultListModel();
        this.cell = new CellRenderer();
        int i = 0;
        while (i < this.vecFileNames.size()) {
            CheckListCheckBox box = new CheckListCheckBox(this.vecFileNames.get(i));
            if (vcSelected != null && vcSelected.contains(box.getName())) {
                box.setSelected(true);
            }
            this.model.add(i, box);
            ++i;
        }
        this.setModel(this.model);
        this.setCellRenderer(this.cell);
        this.addMouseListener(this);
    }

    public void setSingleSelect() {
        this.singleSelection = true;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JCheckBox selectBox = (JCheckBox)this.getSelectedValue();
        if (selectBox == null) {
            return;
        }
        if (this.singleSelection) {
            if (this.boxLastSelected == null) {
                selectBox.setSelected(!selectBox.isSelected());
            } else {
                this.boxLastSelected.setSelected(false);
                selectBox.setSelected(!selectBox.isSelected());
            }
            if (selectBox.isSelected()) {
                this.boxLastSelected = selectBox;
            }
        } else if (e.isShiftDown()) {
            Object[] selectedBoxes = this.getSelectedValues();
            int i = 0;
            while (i < selectedBoxes.length) {
                JCheckBox cc = (JCheckBox)selectedBoxes[i];
                cc.setSelected(true);
                ++i;
            }
        } else if (e.isControlDown()) {
            CheckListCheckBox cb;
            boolean b = (cb = (CheckListCheckBox)this.model.get(this.locationToIndex(e.getPoint()))).isSelected();
            cb.setSelected(!b);
        } else {
            selectBox.setSelected(!selectBox.isSelected());
        }
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public Object getSingleSelctedItem() {
        ListModel dm = this.getModel();
        int iMax = dm.getSize();
        int i = 0;
        while (i < iMax) {
            JCheckBox box = (JCheckBox)dm.getElementAt(i);
            if (box.isSelected()) {
                return box;
            }
            ++i;
        }
        return null;
    }

    public String[] getSelectedFileNames() {
        ListModel dm = this.getModel();
        int iMax = dm.getSize();
        String[] rvTmp = new String[iMax];
        int n = 0;
        int i = 0;
        while (i < iMax) {
            JCheckBox box = (JCheckBox)dm.getElementAt(i);
            if (box.isSelected()) {
                rvTmp[n++] = box.getName();
            }
            ++i;
        }
        String[] rv = new String[n];
        System.arraycopy(rvTmp, 0, rv, 0, n);
        return rv;
    }

    class CellRenderer
    implements ListCellRenderer {
        private JCheckBox box;

        CellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.box = new JCheckBox();
            this.box.setText(value.toString());
            if (ResourceFactory.containsKey(value.toString())) {
                this.box.setText(String.valueOf(ResourceFactory.getString(value.toString())) + " (" + value.toString() + ")");
            }
            if (isSelected) {
                this.box.setBackground(Color.GRAY);
            } else {
                this.box.setBackground(Color.WHITE);
            }
            JCheckBox selectBox = (JCheckBox)value;
            this.box.setSelected(selectBox.isSelected());
            return this.box;
        }
    }
}

